/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.label;

import com.mojang.serialization.MapCodec;
import dev.obscuria.tooltips.client.tooltip.label.LabelProvider;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;

public record RarityLabelProvider() implements LabelProvider
{
    public static final RarityLabelProvider INSTANCE = new RarityLabelProvider();
    public static final MapCodec<RarityLabelProvider> CODEC = MapCodec.unit((Object)INSTANCE);

    public MapCodec<RarityLabelProvider> codec() {
        return CODEC;
    }

    @Override
    public ClientTooltipComponent create(ItemStack stack) {
        String key = this.makeRarityKey(stack.getRarity());
        MutableComponent component = Component.translatable((String)key).withStyle(ChatFormatting.GRAY);
        return ClientTooltipComponent.create((FormattedCharSequence)component.getVisualOrderText());
    }

    private String makeRarityKey(Rarity rarity) {
        String name = rarity.name().toLowerCase(Locale.US).replaceAll(":", ".");
        String shortKey = "rarity." + name;
        if (I18n.exists((String)shortKey)) {
            return shortKey;
        }
        return "rarity." + name + ".name";
    }
}

