/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.obscuria.fragmentum.content.util.color.ARGB;
import dev.obscuria.fragmentum.content.util.color.Colors;
import dev.obscuria.tooltips.client.tooltip.element.QuadPalette;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import org.joml.Matrix4f;

public interface GraphicUtils {
    public static final ARGB WHITE = Colors.argbOf((int)-1);

    public static void setShaderColor(ARGB color) {
        RenderSystem.setShaderColor((float)color.red(), (float)color.green(), (float)color.blue(), (float)color.alpha());
    }

    public static void resetShaderColor() {
        GraphicUtils.setShaderColor(WHITE);
    }

    public static void drawFrame(GuiGraphics graphics, int x, int y, int width, int height, QuadPalette palette) {
        GraphicUtils.drawFrame(graphics, x, y, width, height, palette.topLeft(), palette.topRight(), palette.bottomLeft(), palette.bottomRight());
    }

    public static void drawFrame(GuiGraphics graphics, int x, int y, int width, int height, ARGB topLeft, ARGB topRight, ARGB bottomLeft, ARGB bottomRight) {
        GraphicUtils.drawHLine(graphics, x, y, width, topLeft, topRight);
        GraphicUtils.drawHLine(graphics, x, y + height - 1, width, bottomLeft, bottomRight);
        GraphicUtils.drawVLine(graphics, x, y + 1, height - 2, topLeft, bottomLeft);
        GraphicUtils.drawVLine(graphics, x + width - 1, y + 1, height - 2, topRight, bottomRight);
    }

    public static void drawHLine(GuiGraphics graphics, int x, int y, int length, ARGB start, ARGB end) {
        GraphicUtils.drawRect(graphics, RenderType.gui(), x, y, length, 1, start, end, start, end);
    }

    public static void drawVLine(GuiGraphics graphics, int x, int y, int length, ARGB start, ARGB end) {
        GraphicUtils.drawRect(graphics, RenderType.gui(), x, y, 1, length, start, start, end, end);
    }

    public static void drawHLineOverlay(GuiGraphics graphics, int x, int y, int length, ARGB start, ARGB end) {
        GraphicUtils.drawRect(graphics, RenderType.guiOverlay(), x, y, length, 1, start, end, start, end);
    }

    public static void drawVLineOverlay(GuiGraphics graphics, int x, int y, int length, ARGB start, ARGB end) {
        GraphicUtils.drawRect(graphics, RenderType.guiOverlay(), x, y, 1, length, start, start, end, end);
    }

    public static void drawRect(GuiGraphics graphics, int x, int y, int width, int height, QuadPalette palette) {
        GraphicUtils.drawRect(graphics, RenderType.gui(), x, y, width, height, palette.topLeft(), palette.topRight(), palette.bottomLeft(), palette.bottomRight());
    }

    public static void drawRect(GuiGraphics graphics, RenderType type, int x, int y, int width, int height, ARGB topLeft, ARGB topRight, ARGB bottomLeft, ARGB bottomRight) {
        VertexConsumer consumer = graphics.bufferSource().getBuffer(type);
        Matrix4f matrix = graphics.pose().last().pose();
        float minX = x;
        float minY = y;
        float maxX = x + width;
        float maxY = y + height;
        GraphicUtils.color(consumer.addVertex(matrix, minX, minY, 0.0f), topLeft);
        GraphicUtils.color(consumer.addVertex(matrix, minX, maxY, 0.0f), bottomLeft);
        GraphicUtils.color(consumer.addVertex(matrix, maxX, maxY, 0.0f), bottomRight);
        GraphicUtils.color(consumer.addVertex(matrix, maxX, minY, 0.0f), topRight);
    }

    public static VertexConsumer color(VertexConsumer consumer, ARGB color) {
        return consumer.setColor(color.red(), color.green(), color.blue(), color.alpha());
    }
}

