/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client;

import com.mojang.math.Axis;
import dev.obscuria.tooltips.client.ParticleStatus;
import dev.obscuria.tooltips.client.TooltipState;
import dev.obscuria.tooltips.client.tooltip.particle.TooltipParticle;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;

public abstract class ParticleData {
    public final Object source;
    public final float startTime;
    public final Vec2 origin;
    public final Vec2 destination;
    public ParticleStatus status = ParticleStatus.ALIVE;

    public void render(GuiGraphics graphics, TooltipState state, TooltipParticle particle, int x, int y) {
        float progress = this.computeProgress(state);
        Vec2 translation = this.computeTranslation(state, progress);
        float scale = this.computeScale(state, progress);
        float rotation = this.computeRotation(state, progress);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)x + this.origin.f_82470_ + translation.f_82470_, (float)y + this.origin.f_82471_ + translation.f_82471_, 0.0f);
        graphics.m_280168_().m_85841_(scale, scale, scale);
        graphics.m_280168_().m_252781_(Axis.f_252403_.m_252961_(rotation));
        particle.render(graphics, state, this);
        graphics.m_280168_().m_85849_();
        this.status = progress <= 1.0f ? ParticleStatus.ALIVE : ParticleStatus.EXPIRED;
    }

    public float computeProgress(TooltipState state) {
        return Mth.m_14036_((float)(state.timeInSeconds() - this.startTime), (float)0.0f, (float)1.0f);
    }

    public Vec2 computeTranslation(TooltipState state, float progress) {
        return new Vec2((this.destination.f_82470_ - this.origin.f_82470_) * progress, (this.destination.f_82471_ - this.origin.f_82471_) * progress);
    }

    public float computeScale(TooltipState state, float progress) {
        return 1.0f;
    }

    public float computeRotation(TooltipState state, float progress) {
        return 0.0f;
    }

    public boolean isExpired() {
        return this.status == ParticleStatus.EXPIRED;
    }

    @Generated
    public ParticleData(Object source, float startTime, Vec2 origin, Vec2 destination) {
        this.source = source;
        this.startTime = startTime;
        this.origin = origin;
        this.destination = destination;
    }
}

