/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.filter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.tooltips.client.tooltip.filter.ItemFilter;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public record EnchantmentFilter(Optional<Boolean> anyEnchantment, Optional<Boolean> anyCurse, Optional<List<Enchantment>> enchantments) implements ItemFilter
{
    public static final Codec<EnchantmentFilter> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Codec.BOOL.optionalFieldOf("any_enchantment").forGetter(EnchantmentFilter::anyEnchantment), (App)Codec.BOOL.optionalFieldOf("any_curse").forGetter(EnchantmentFilter::anyCurse), (App)BuiltInRegistries.f_256876_.m_194605_().listOf().optionalFieldOf("enchantments").forGetter(EnchantmentFilter::enchantments)).apply((Applicative)codec, EnchantmentFilter::new));

    public Codec<EnchantmentFilter> codec() {
        return CODEC;
    }

    @Override
    public boolean test(ItemStack stack) {
        if (this.anyEnchantment.isPresent() && !this.anyEnchantment.get().equals(stack.m_41793_())) {
            return false;
        }
        if (this.anyCurse.isPresent() && !this.anyCurse.get().equals(this.isCursed(stack))) {
            return false;
        }
        return !this.enchantments.isPresent() || this.containsAll(stack, this.enchantments.get());
    }

    private boolean isCursed(ItemStack stack) {
        return EnchantmentHelper.m_44831_((ItemStack)stack).keySet().stream().anyMatch(Enchantment::m_6589_);
    }

    private boolean containsAll(ItemStack stack, List<Enchantment> enchantments) {
        return enchantments.stream().allMatch(it -> EnchantmentHelper.m_44843_((Enchantment)it, (ItemStack)stack) > 0);
    }
}

