/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.element.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.fragmentum.content.util.easing.Easing;
import dev.obscuria.fragmentum.content.util.easing.EasingFunction;
import dev.obscuria.tooltips.client.ParticleData;
import dev.obscuria.tooltips.client.TooltipState;
import dev.obscuria.tooltips.client.tooltip.element.effect.TooltipEffect;
import dev.obscuria.tooltips.client.tooltip.particle.TooltipParticle;
import java.util.List;
import net.minecraft.class_241;
import net.minecraft.class_332;
import org.apache.commons.lang3.RandomUtils;

public record InwardParticleEffect(TooltipParticle particle) implements TooltipEffect
{
    public static final MapCodec<InwardParticleEffect> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)TooltipParticle.CODEC.fieldOf("particle").forGetter(InwardParticleEffect::particle)).apply((Applicative)codec, InwardParticleEffect::new));

    public MapCodec<InwardParticleEffect> codec() {
        return CODEC;
    }

    @Override
    public boolean canApply(List<TooltipEffect> effects) {
        return effects.stream().noneMatch(it -> it instanceof InwardParticleEffect);
    }

    @Override
    public void renderBack(TooltipState state, class_332 graphics, int x, int y, int width, int height) {
        float lastParticleTime = 0.0f;
        for (ParticleData particle : state.particles) {
            if (!particle.source.equals(this)) continue;
            particle.render(graphics, state, this.particle, x, y);
            lastParticleTime = Math.max(lastParticleTime, particle.startTime);
        }
        if (state.timeInSeconds() - lastParticleTime < 0.2f) {
            return;
        }
        int edge = RandomUtils.nextInt((int)1, (int)5);
        float ratio = RandomUtils.nextFloat((float)0.0f, (float)1.0f);
        class_241 center = new class_241((float)width * 0.5f, (float)height * 0.5f);
        class_241 origin = switch (edge) {
            case 1 -> new class_241((float)width * ratio, 0.0f);
            case 2 -> new class_241((float)width * ratio, (float)height);
            case 3 -> new class_241(0.0f, (float)height * ratio);
            case 4 -> new class_241((float)width, (float)height * ratio);
            default -> class_241.field_1340;
        };
        state.addParticle(new InwardParticle(this, state.timeInSeconds(), origin, center));
    }

    private static final class InwardParticle
    extends ParticleData {
        public InwardParticle(Object source, float startTime, class_241 origin, class_241 destination) {
            super(source, startTime, origin, destination);
        }

        @Override
        public float computeProgress(TooltipState state) {
            return Easing.EASE_OUT_CUBIC.compute(super.computeProgress(state));
        }

        @Override
        public class_241 computeTranslation(TooltipState state, float progress) {
            return super.computeTranslation(state, progress).method_35582(0.4f);
        }

        @Override
        public float computeScale(TooltipState state, float progress) {
            return Easing.EASE_OUT_CUBIC.mergeOut((EasingFunction)Easing.EASE_IN_CUBIC, 0.2f).compute(progress * 1.25f);
        }

        @Override
        public float computeRotation(TooltipState state, float progress) {
            return (float)Math.atan2(this.destination.field_1342 - this.origin.field_1342, this.destination.field_1343 - this.origin.field_1343);
        }
    }
}

