/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.element.panel;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.fragmentum.util.color.ARGB;
import dev.obscuria.tooltips.client.tooltip.element.QuadPalette;
import dev.obscuria.tooltips.client.tooltip.element.panel.TooltipPanel;
import dev.obscuria.tooltips.client.tooltip.particle.GraphicUtils;
import dev.obscuria.tooltips.config.ClientConfig;
import net.minecraft.class_332;

public record ColorRectPanel(QuadPalette background, QuadPalette border) implements TooltipPanel
{
    public static final Codec<ColorRectPanel> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)QuadPalette.CODEC.fieldOf("background_palette").forGetter(ColorRectPanel::background), (App)QuadPalette.CODEC.fieldOf("border_palette").forGetter(ColorRectPanel::border)).apply((Applicative)codec, ColorRectPanel::new));

    public Codec<ColorRectPanel> codec() {
        return CODEC;
    }

    @Override
    public void render(class_332 graphics, int x, int y, int width, int height) {
        this.dropShadow(graphics, x - 3, y - 3, width + 6, height + 6);
        GraphicUtils.drawRect(graphics, x - 3, y - 3, width + 6, height + 6, this.background);
        GraphicUtils.drawFrame(graphics, x - 3, y - 3, width + 6, height + 6, this.border);
        GraphicUtils.drawHLine(graphics, x - 3, y - 4, width + 6, this.background.topLeft(), this.background.topRight());
        GraphicUtils.drawHLine(graphics, x - 3, y + height + 3, width + 6, this.background.bottomLeft(), this.background.bottomRight());
        GraphicUtils.drawVLine(graphics, x - 4, y - 3, height + 6, this.background.topLeft(), this.background.bottomLeft());
        GraphicUtils.drawVLine(graphics, x + width + 3, y - 3, height + 6, this.background.topRight(), this.background.bottomRight());
    }

    @Override
    public ARGB separatorColor() {
        return this.border.topLeft().lerp(this.border.bottomRight(), 0.5f);
    }

    private void dropShadow(class_332 graphics, int x, int y, int width, int height) {
        if (!((Boolean)ClientConfig.SHADOWS_ENABLED.get()).booleanValue()) {
            return;
        }
        int color = (int)(Math.round((Double)ClientConfig.SHADOW_OPACITY.get() * 255.0) << 24);
        graphics.method_25292(x + 2, x + width, y + height + 1, color);
        graphics.method_25292(x + 3, x + width + 1, y + height + 2, color);
        graphics.method_25301(x + width + 1, y + 1, y + height + 1, color);
        graphics.method_25301(x + width + 2, y + 2, y + height + 2, color);
        graphics.method_25292(x + width, x + width, y + height, color);
        graphics.method_25292(x + width + 1, x + width + 1, y + height + 1, color);
    }
}

