/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.element.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.tooltips.client.TooltipState;
import dev.obscuria.tooltips.client.tooltip.element.QuadPalette;
import dev.obscuria.tooltips.client.tooltip.element.effect.TooltipEffect;
import dev.obscuria.tooltips.client.tooltip.particle.GraphicUtils;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import org.joml.Matrix4f;

public record RimLightEffect(QuadPalette outerPalette, QuadPalette innerPalette) implements TooltipEffect
{
    public static final MapCodec<RimLightEffect> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)QuadPalette.CODEC.fieldOf("outer_palette").forGetter(RimLightEffect::outerPalette), (App)QuadPalette.CODEC.fieldOf("inner_palette").forGetter(RimLightEffect::innerPalette)).apply((Applicative)codec, RimLightEffect::new));

    public MapCodec<RimLightEffect> codec() {
        return CODEC;
    }

    @Override
    public boolean canApply(List<TooltipEffect> effects) {
        return effects.stream().noneMatch(it -> it instanceof RimLightEffect);
    }

    @Override
    public void renderBack(TooltipState state, class_332 graphics, int x, int y, int width, int height) {
        float pX = (float)x - 3.0f;
        float pY = (float)y - 3.0f;
        float pWidth = (float)width + 6.0f;
        float pHeight = (float)height + 6.0f;
        Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
        class_4588 buffer = graphics.method_51450().getBuffer(class_1921.method_51785());
        float scale = 0.8f + 0.4f * (float)Math.cos(state.timeInSeconds());
        float offset = Math.min(pWidth, pHeight) * 0.25f * scale;
        GraphicUtils.color(buffer.method_22918(matrix, pX, pY, 0.0f), this.outerPalette.topLeft());
        GraphicUtils.color(buffer.method_22918(matrix, pX + offset, pY + offset, 0.0f), this.innerPalette.topLeft());
        GraphicUtils.color(buffer.method_22918(matrix, pX + pWidth - offset, pY + offset, 0.0f), this.innerPalette.topRight());
        GraphicUtils.color(buffer.method_22918(matrix, pX + pWidth, pY, 0.0f), this.outerPalette.topRight());
        GraphicUtils.color(buffer.method_22918(matrix, pX + offset, pY + pHeight - offset, 0.0f), this.innerPalette.bottomLeft());
        GraphicUtils.color(buffer.method_22918(matrix, pX, pY + pHeight, 0.0f), this.outerPalette.bottomLeft());
        GraphicUtils.color(buffer.method_22918(matrix, pX + pWidth, pY + pHeight, 0.0f), this.outerPalette.bottomRight());
        GraphicUtils.color(buffer.method_22918(matrix, pX + pWidth - offset, pY + pHeight - offset, 0.0f), this.innerPalette.bottomRight());
        GraphicUtils.color(buffer.method_22918(matrix, pX, pY, 0.0f), this.outerPalette.topLeft());
        GraphicUtils.color(buffer.method_22918(matrix, pX, pY + pHeight, 0.0f), this.outerPalette.bottomLeft());
        GraphicUtils.color(buffer.method_22918(matrix, pX + offset, pY + pHeight - offset, 0.0f), this.innerPalette.bottomLeft());
        GraphicUtils.color(buffer.method_22918(matrix, pX + offset, pY + offset, 0.0f), this.innerPalette.topLeft());
        GraphicUtils.color(buffer.method_22918(matrix, pX + pWidth - offset, pY + offset, 0.0f), this.innerPalette.topRight());
        GraphicUtils.color(buffer.method_22918(matrix, pX + pWidth - offset, pY + pHeight - offset, 0.0f), this.innerPalette.bottomRight());
        GraphicUtils.color(buffer.method_22918(matrix, pX + pWidth, pY + pHeight, 0.0f), this.outerPalette.bottomRight());
        GraphicUtils.color(buffer.method_22918(matrix, pX + pWidth, pY, 0.0f), this.outerPalette.topRight());
    }
}

