/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.filter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.tooltips.client.tooltip.filter.ItemFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.commons.compress.utils.Lists;

public record ItemOrTagFilter(List<class_6862<class_1792>> tags, List<class_1792> items) implements ItemFilter
{
    public static final MapCodec<ItemOrTagFilter> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)class_5699.field_39274.listOf().fieldOf("values").forGetter(ItemOrTagFilter::pack)).apply((Applicative)codec, ItemOrTagFilter::unpack));

    public MapCodec<ItemOrTagFilter> codec() {
        return CODEC;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean test(class_1799 stack) {
        if (this.items.contains(stack.method_7909())) return true;
        if (!this.tags.stream().anyMatch(arg_0 -> ((class_1799)stack).method_31573(arg_0))) return false;
        return true;
    }

    private List<class_5699.class_7476> pack() {
        return Stream.concat(this.tags.stream().map(ItemOrTagFilter::packTag), this.items.stream().map(ItemOrTagFilter::packItem)).toList();
    }

    private static class_5699.class_7476 packTag(class_6862<class_1792> tag) {
        return new class_5699.class_7476(tag.comp_327(), true);
    }

    private static class_5699.class_7476 packItem(class_1792 item) {
        return new class_5699.class_7476(item.method_40131().method_40237().method_29177(), false);
    }

    private static ItemOrTagFilter unpack(List<class_5699.class_7476> packed) {
        ArrayList tags = Lists.newArrayList();
        ArrayList items = Lists.newArrayList();
        for (class_5699.class_7476 location : packed) {
            if (location.comp_814()) {
                tags.add(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)location.comp_813()));
                continue;
            }
            items.add((class_1792)class_7923.field_41178.method_10223(location.comp_813()));
        }
        return new ItemOrTagFilter(tags, items);
    }
}

