/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.filter;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.tooltips.client.filter.ItemFilter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.item.ItemStack;

public record NbtFilter(CompoundTag nbt) implements ItemFilter
{
    public static final Codec<NbtFilter> CODEC;

    public Codec<NbtFilter> codec() {
        return CODEC;
    }

    @Override
    public boolean test(ItemStack stack) {
        return NbtUtils.m_129235_((Tag)this.nbt, (Tag)stack.m_41783_(), (boolean)false);
    }

    private static DataResult<CompoundTag> tryParseNbt(String input) {
        try {
            return DataResult.success((Object)TagParser.m_129359_((String)input));
        }
        catch (CommandSyntaxException exception) {
            return DataResult.error(() -> "Invalid tag: " + exception.getMessage());
        }
    }

    static {
        Codec tagCodec = Codec.STRING.comapFlatMap(NbtFilter::tryParseNbt, CompoundTag::toString);
        CODEC = RecordCodecBuilder.create(codec -> codec.group((App)tagCodec.fieldOf("nbt").forGetter(NbtFilter::nbt)).apply((Applicative)codec, NbtFilter::new));
    }
}

