/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.tooltips.client.tooltip.element.effect;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.obscuria.fragmentum.util.color.ARGB;
import dev.obscuria.tooltips.client.TooltipState;
import dev.obscuria.tooltips.client.tooltip.element.effect.TooltipEffect;
import java.util.List;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_332;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public record GlintEffect(int segments, boolean clipWaves, boolean clipRings, List<WaveSpecs> waves, List<RingSpecs> rings) implements TooltipEffect
{
    public static final Codec<GlintEffect> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Codec.INT.fieldOf("segments").forGetter(GlintEffect::segments), (App)Codec.BOOL.optionalFieldOf("clip_waves", (Object)true).forGetter(GlintEffect::clipWaves), (App)Codec.BOOL.optionalFieldOf("clip_rings", (Object)true).forGetter(GlintEffect::clipRings), (App)WaveSpecs.CODEC.listOf().fieldOf("waves").forGetter(GlintEffect::waves), (App)RingSpecs.CODEC.listOf().fieldOf("rings").forGetter(GlintEffect::rings)).apply((Applicative)codec, GlintEffect::new));
    private static final float TAU = (float)Math.PI * 2;

    public Codec<GlintEffect> codec() {
        return CODEC;
    }

    @Override
    public boolean canApply(List<TooltipEffect> effects) {
        return effects.stream().noneMatch(it -> it instanceof GlintEffect);
    }

    @Override
    public void renderBack(TooltipState state, class_332 graphics, int x, int y, int width, int height) {
        graphics.method_51448().method_22903();
        float centerX = (float)x + (float)width * 0.5f;
        float centerY = (float)y + (float)height * 0.5f;
        float radius = (float)Math.hypot(width, height) * 0.85f;
        float timer = state.timeInSeconds() * 0.1f;
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(class_757::method_34540);
        Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        if (this.clipWaves) {
            graphics.method_44379(x - 3, y - 3, x + width + 3, y + height + 3);
        }
        this.renderWaves(buffer, matrix, centerX, centerY, width, height, radius, timer);
        if (this.clipWaves) {
            graphics.method_44380();
        }
        if (this.clipRings) {
            graphics.method_44379(x - 3, y - 3, x + width + 3, y + height + 3);
        }
        this.renderRings(buffer, matrix, centerX, centerY, radius, timer);
        if (this.clipRings) {
            graphics.method_44380();
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        graphics.method_51448().method_22909();
    }

    private void renderWaves(class_287 buffer, Matrix4f matrix, float x, float y, int width, int height, float radius, float timer) {
        if (this.waves.isEmpty()) {
            return;
        }
        float aspect = (float)height / (float)Math.max(1, width);
        for (int waveIndex = 0; waveIndex < this.waves.size(); ++waveIndex) {
            WaveSpecs specs = this.waves.get(waveIndex);
            ARGB color = specs.color;
            float baseRadius = radius * specs.radialOffset();
            float thickness = radius * specs.thickness() * 0.5f;
            float progress = timer * ((float)Math.PI * 2) * specs.flowSpeed();
            buffer.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
            for (int i = 0; i <= this.segments; ++i) {
                float segment = (float)i / (float)this.segments;
                float angle = segment * ((float)Math.PI * 2) + progress;
                float sin = (float)Math.sin(angle);
                float cos = (float)Math.cos(angle);
                float swirl = this.computeSwirl(angle, progress, waveIndex) * radius;
                float ringRadius = baseRadius + swirl;
                float innerR = ringRadius + thickness * specs.innerBias();
                float outerR = ringRadius + thickness * specs.outerBias();
                float ix = x + cos * innerR;
                float iy = y + sin * innerR * aspect;
                float ox = x + cos * outerR;
                float oy = y + sin * outerR * aspect;
                float intensity = this.computeIntensity(sin, angle, progress, waveIndex, specs.verticalFade());
                float innerA = color.alpha() * intensity * specs.innerAlpha();
                float outerA = color.alpha() * intensity * specs.outerAlpha();
                buffer.method_22918(matrix, ox, oy, 0.0f).method_22915(color.red(), color.green(), color.blue(), outerA).method_1344();
                buffer.method_22918(matrix, ix, iy, 0.0f).method_22915(color.red(), color.green(), color.blue(), innerA).method_1344();
            }
            class_286.method_43433((class_287.class_7433)buffer.method_1326());
        }
    }

    private void renderRings(class_287 buffer, Matrix4f matrix, float x, float y, float radius, float timer) {
        if (this.rings.isEmpty()) {
            return;
        }
        for (int ringIndex = 0; ringIndex < this.rings.size(); ++ringIndex) {
            RingSpecs specs = this.rings.get(ringIndex);
            ARGB color = specs.color();
            float baseRadius = radius * specs.radius();
            float thickness = radius * specs.thickness();
            float progress = timer * ((float)Math.PI * 2) * specs.spinSpeed();
            float arcSpan = 4.3982296f;
            buffer.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
            for (int i = 0; i <= this.segments; ++i) {
                float segment = (float)i / (float)this.segments;
                float angle = (segment - 0.5f) * 4.3982296f + progress + specs.arcOffset();
                float sin = (float)Math.sin(angle);
                float cos = (float)Math.cos(angle);
                float wobble = this.computeWobble(segment, timer, ringIndex);
                float rBase = baseRadius + wobble * radius * 0.18f;
                float innerR = rBase - thickness * 0.5f;
                float outerR = rBase + thickness * 0.5f;
                float ix = x + cos * innerR;
                float iy = y + sin * innerR;
                float ox = x + cos * outerR;
                float oy = y + sin * outerR;
                float intensity = this.computeIntensity(segment, timer, ringIndex);
                float edgeA = color.alpha() * intensity * 0.4f;
                float coreA = color.alpha() * intensity * 0.9f;
                buffer.method_22918(matrix, ox, oy, 0.0f).method_22915(color.red(), color.green(), color.blue(), edgeA).method_1344();
                buffer.method_22918(matrix, ix, iy, 0.0f).method_22915(color.red(), color.green(), color.blue(), coreA).method_1344();
            }
            class_286.method_43433((class_287.class_7433)buffer.method_1326());
        }
    }

    private float computeSwirl(float angle, float progress, float waveIndex) {
        float swirl1 = 0.12f * (float)Math.sin(angle * 3.0f + progress * 2.1f + waveIndex * 0.7f);
        float swirl2 = 0.07f * (float)Math.sin(angle * 7.0f - progress * 1.4f);
        return swirl1 + swirl2;
    }

    private float computeIntensity(float sin, float angle, float progress, float waveIndex, boolean verticalFade) {
        float band = 0.5f + 0.5f * (float)Math.sin(angle * 2.0f - progress * 1.3f + waveIndex);
        if (verticalFade) {
            float vertical = Math.max(0.0f, sin * 0.8f + 0.2f);
            return vertical * (0.4f + 0.6f * band);
        }
        float hMask = (float)Math.pow(Math.abs(sin), 1.4f);
        return hMask * (0.35f + 0.65f * band);
    }

    private float computeWobble(float segment, float timer, int ringIndex) {
        return 0.08f * (float)Math.sin(segment * 6.0f + timer * ((float)Math.PI * 2) * 2.0f + (float)ringIndex * 1.7f);
    }

    private float computeIntensity(float segment, float timer, int ringIndex) {
        float arcMask = (float)Math.sin((double)segment * Math.PI);
        float pulse = 0.6f + 0.4f * (float)Math.sin(timer * ((float)Math.PI * 2) * 3.0f + segment * 5.0f + (float)ringIndex * 1.3f);
        return arcMask * pulse;
    }

    public record WaveSpecs(ARGB color, float innerAlpha, float innerBias, float outerAlpha, float outerBias, float radialOffset, float thickness, float flowSpeed, boolean verticalFade) {
        public static final Codec<WaveSpecs> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)ARGB.CODEC.fieldOf("color").forGetter(WaveSpecs::color), (App)Codec.FLOAT.fieldOf("inner_alpha").forGetter(WaveSpecs::innerAlpha), (App)Codec.FLOAT.fieldOf("inner_bias").forGetter(WaveSpecs::innerBias), (App)Codec.FLOAT.fieldOf("outer_alpha").forGetter(WaveSpecs::outerAlpha), (App)Codec.FLOAT.fieldOf("outer_bias").forGetter(WaveSpecs::outerBias), (App)Codec.FLOAT.fieldOf("radial_offset").forGetter(WaveSpecs::radialOffset), (App)Codec.FLOAT.fieldOf("thickness").forGetter(WaveSpecs::thickness), (App)Codec.FLOAT.fieldOf("flow_speed").forGetter(WaveSpecs::flowSpeed), (App)Codec.BOOL.fieldOf("vertical_fade").forGetter(WaveSpecs::verticalFade)).apply((Applicative)codec, WaveSpecs::new));
    }

    public record RingSpecs(ARGB color, float spinSpeed, float radius, float thickness, float arcOffset) {
        public static final Codec<RingSpecs> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)ARGB.CODEC.fieldOf("color").forGetter(RingSpecs::color), (App)Codec.FLOAT.fieldOf("spin_speed").forGetter(RingSpecs::spinSpeed), (App)Codec.FLOAT.fieldOf("radius").forGetter(RingSpecs::radius), (App)Codec.FLOAT.fieldOf("thickness").forGetter(RingSpecs::thickness), (App)Codec.FLOAT.fieldOf("arc_offset").forGetter(RingSpecs::arcOffset)).apply((Applicative)codec, RingSpecs::new));
    }
}

