/*
 * Decompiled with CFR 0.152.
 */
package me.dev.zShop;

import java.util.List;
import me.dev.zShop.commands.ShopCommand;
import me.dev.zShop.gui.GUIManager;
import me.dev.zShop.listeners.GUIListener;
import me.dev.zShop.listeners.ItemInteractionListener;
import me.dev.zShop.utils.ConfigManager;
import me.dev.zShop.utils.ItemManager;
import me.dev.zShop.utils.TransactionLogger;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public final class Main
extends JavaPlugin {
    private static Main instance;
    private ConfigManager configManager;
    private GUIManager guiManager;
    private Economy economy;
    private TransactionLogger transactionLogger;
    private ItemManager itemManager;
    private ItemInteractionListener itemInteractionListener;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.updateConfig();
        this.configManager = new ConfigManager(this);
        this.itemManager = new ItemManager(this);
        this.transactionLogger = new TransactionLogger(this);
        if (!this.setupEconomy()) {
            this.getLogger().severe("Vault or an Economy plugin could not be found!");
            this.getLogger().severe("Disabling zShop...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.guiManager = new GUIManager(this);
        ShopCommand shopCommand = new ShopCommand(this);
        this.getCommand("shop").setExecutor((CommandExecutor)shopCommand);
        this.getCommand("shop").setTabCompleter((TabCompleter)shopCommand);
        this.getServer().getPluginManager().registerEvents((Listener)new GUIListener(this), (Plugin)this);
        this.itemInteractionListener = new ItemInteractionListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.itemInteractionListener, (Plugin)this);
        this.getLogger().info("zShop has been successfully enabled!");
    }

    private void updateConfig() {
        boolean configUpdated = false;
        if (!this.getConfig().contains("settings")) {
            this.getLogger().warning("Settings section missing in configuration!");
            this.getConfig().createSection("settings");
            configUpdated = true;
        }
        if (!this.getConfig().contains("settings.prefix")) {
            this.getConfig().set("settings.prefix", (Object)"&8[&bz&3Shop&8] &7");
            configUpdated = true;
        }
        if (!this.getConfig().contains("main-menu")) {
            this.getLogger().warning("Main-Menu section missing in configuration!");
            this.getConfig().createSection("main-menu");
            this.getConfig().set("main-menu.title", (Object)"&8\u00bb &bShop");
            this.getConfig().set("main-menu.size", (Object)27);
            this.getConfig().createSection("main-menu.categories");
            configUpdated = true;
        }
        if (!this.getConfig().contains("category-settings")) {
            this.getLogger().warning("Category-Settings missing in configuration!");
            this.getConfig().createSection("category-settings");
            configUpdated = true;
        }
        for (int i = 1; i <= 7; ++i) {
            String categoryKey = "category" + i;
            if (!this.getConfig().contains("category-settings." + categoryKey)) {
                this.getLogger().warning("Category settings for " + categoryKey + " are missing!");
                this.getConfig().createSection("category-settings." + categoryKey);
                this.getConfig().set("category-settings." + categoryKey + ".name", (Object)("&bCategory " + i));
                this.getConfig().set("category-settings." + categoryKey + ".title", (Object)("&8\u00bb &bCategory " + i));
                this.getConfig().set("category-settings." + categoryKey + ".material", (Object)"STONE");
                this.getConfig().set("category-settings." + categoryKey + ".slot", (Object)(9 + i));
                configUpdated = true;
            }
            if (!this.getConfig().contains(categoryKey)) {
                this.getLogger().warning("Category " + categoryKey + " missing in configuration!");
                this.getConfig().createSection(categoryKey);
                this.getConfig().set(categoryKey + ".size", (Object)27);
                configUpdated = true;
            }
            if (!this.getConfig().contains(categoryKey + ".items")) {
                this.getLogger().warning("Items section for category " + categoryKey + " is missing!");
                this.getConfig().createSection(categoryKey + ".items");
                String itemKey = "example_item_" + i;
                this.getConfig().set(categoryKey + ".items." + itemKey + ".name", (Object)("&bExample Item " + i));
                this.getConfig().set(categoryKey + ".items." + itemKey + ".material", (Object)"STONE");
                this.getConfig().set(categoryKey + ".items." + itemKey + ".price", (Object)10.0);
                this.getConfig().set(categoryKey + ".items." + itemKey + ".slot", (Object)10);
                configUpdated = true;
            }
            if (this.getConfig().contains("main-menu.categories." + categoryKey)) continue;
            this.getConfig().createSection("main-menu.categories." + categoryKey);
            configUpdated = true;
        }
        if (!this.getConfig().contains("settings.item-lore")) {
            this.getLogger().warning("Global item lore missing in configuration!");
            this.getConfig().set("settings.item-lore", List.of("&7Price: &a{price}", "", "&7Click to purchase"));
            configUpdated = true;
        }
        if (!this.getConfig().contains("settings.category-lore")) {
            this.getLogger().warning("Global category lore missing in configuration!");
            this.getConfig().set("settings.category-lore", List.of("", "&7Click to open this category"));
            configUpdated = true;
        }
        if (!this.getConfig().contains("sounds")) {
            this.getLogger().warning("Sound configuration missing! Adding default sounds...");
            this.getConfig().createSection("sounds");
            this.getConfig().set("sounds.menu_open.sound", (Object)"BLOCK_CHEST_OPEN");
            this.getConfig().set("sounds.menu_open.volume", (Object)0.5);
            this.getConfig().set("sounds.menu_open.pitch", (Object)1.0);
            this.getConfig().set("sounds.menu_close.sound", (Object)"BLOCK_CHEST_CLOSE");
            this.getConfig().set("sounds.menu_close.volume", (Object)0.5);
            this.getConfig().set("sounds.menu_close.pitch", (Object)1.0);
            this.getConfig().set("sounds.category_click.sound", (Object)"UI_BUTTON_CLICK");
            this.getConfig().set("sounds.category_click.volume", (Object)0.5);
            this.getConfig().set("sounds.category_click.pitch", (Object)1.0);
            this.getConfig().set("sounds.item_click.sound", (Object)"ENTITY_ITEM_PICKUP");
            this.getConfig().set("sounds.item_click.volume", (Object)0.5);
            this.getConfig().set("sounds.item_click.pitch", (Object)1.2);
            this.getConfig().set("sounds.amount_change.sound", (Object)"BLOCK_NOTE_BLOCK_HAT");
            this.getConfig().set("sounds.amount_change.volume", (Object)0.3);
            this.getConfig().set("sounds.amount_change.pitch", (Object)1.5);
            this.getConfig().set("sounds.purchase_success.sound", (Object)"ENTITY_PLAYER_LEVELUP");
            this.getConfig().set("sounds.purchase_success.volume", (Object)0.5);
            this.getConfig().set("sounds.purchase_success.pitch", (Object)1.0);
            this.getConfig().set("sounds.purchase_failed.sound", (Object)"ENTITY_VILLAGER_NO");
            this.getConfig().set("sounds.purchase_failed.volume", (Object)0.5);
            this.getConfig().set("sounds.purchase_failed.pitch", (Object)1.0);
            this.getConfig().set("sounds.inventory_full.sound", (Object)"ENTITY_VILLAGER_NO");
            this.getConfig().set("sounds.inventory_full.volume", (Object)0.5);
            this.getConfig().set("sounds.inventory_full.pitch", (Object)0.8);
            this.getConfig().set("sounds.transaction_error.sound", (Object)"ENTITY_ENDERMAN_TELEPORT");
            this.getConfig().set("sounds.transaction_error.volume", (Object)0.5);
            this.getConfig().set("sounds.transaction_error.pitch", (Object)0.5);
            this.getConfig().set("sounds.command_execute.sound", (Object)"ENTITY_EXPERIENCE_ORB_PICKUP");
            this.getConfig().set("sounds.command_execute.volume", (Object)0.5);
            this.getConfig().set("sounds.command_execute.pitch", (Object)1.2);
            configUpdated = true;
        }
        if (!this.getConfig().contains("back-button")) {
            this.getLogger().warning("Back button configuration missing! Adding default button...");
            this.getConfig().set("back-button.name", (Object)"&c\u00ab \u0299\u1d00\u1d04\u1d0b");
            this.getConfig().set("back-button.material", (Object)"RED_DYE");
            this.getConfig().set("back-button.lore", List.of("&7\u0280\u1d07\u1d1b\u1d1c\u0280\u0274 \u1d1b\u1d0f \u1d1b\u029c\u1d07 \u1d18\u0280\u1d07\u1d20\u026a\u1d0f\u1d1cs \u1d0d\u1d07\u0274\u1d1c"));
            configUpdated = true;
        }
        if (!this.getConfig().contains("buy-button")) {
            this.getLogger().warning("Buy button configuration missing! Adding default button...");
            this.getConfig().set("buy-button.name", (Object)"&a\u2713 \u0299\u1d1c\u028f");
            this.getConfig().set("buy-button.material", (Object)"LIME_DYE");
            this.getConfig().set("buy-button.lore", List.of("&7\u1d04\u1d0f\u0274\u0493\u026a\u0280\u1d0d \u028f\u1d0f\u1d1c\u0280 \u1d18\u1d1c\u0280\u1d04\u029c\u1d00s\u1d07"));
            configUpdated = true;
        }
        if (!this.getConfig().contains("cancel-button")) {
            this.getLogger().warning("Cancel button configuration missing! Adding default button...");
            this.getConfig().set("cancel-button.name", (Object)"&c\u2717 \u1d04\u1d00\u0274\u1d04\u1d07\u029f");
            this.getConfig().set("cancel-button.material", (Object)"RED_DYE");
            this.getConfig().set("cancel-button.lore", List.of("&7\u1d04\u1d00\u0274\u1d04\u1d07\u029f \u1d1b\u029c\u1d07 \u1d1b\u0280\u1d00\u0274s\u1d00\u1d04\u1d1b\u026a\u1d0f\u0274"));
            configUpdated = true;
        }
        if (configUpdated) {
            this.getLogger().info("Configuration has been updated!");
            this.saveConfig();
        }
    }

    public void onDisable() {
        if (this.itemManager != null) {
            this.itemManager.saveAll();
        }
        this.getLogger().info("zShop has been disabled!");
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return this.economy != null;
    }

    public static Main getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public GUIManager getGuiManager() {
        return this.guiManager;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public TransactionLogger getTransactionLogger() {
        return this.transactionLogger;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public void reloadPlugin() {
        this.reloadConfig();
        this.configManager = new ConfigManager(this);
        if (this.guiManager != null) {
            this.guiManager.refreshInventories();
        }
        this.getLogger().info("zShop has been reloaded!");
    }

    public void openShopGui(Player player) {
        this.configManager.playSound(player, "menu_open");
        this.guiManager.openMainMenu(player);
    }

    public ItemInteractionListener getItemInteractionListener() {
        return this.itemInteractionListener;
    }
}

