/*
 * Decompiled with CFR 0.152.
 */
package me.dev.zShop.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.dev.zShop.Main;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ShopCommand
implements CommandExecutor,
TabCompleter {
    private final Main plugin;
    private final NamespacedKey commandKey;

    public ShopCommand(Main plugin) {
        this.plugin = plugin;
        this.commandKey = new NamespacedKey((Plugin)plugin, "shop_command");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("player-only", new String[0]));
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("zshop.use")) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission", new String[0]));
                return true;
            }
            this.plugin.getGuiManager().openMainMenu(player);
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("zshop.reload")) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission", new String[0]));
                return true;
            }
            this.plugin.reloadPlugin();
            sender.sendMessage(this.plugin.getConfigManager().getMessage("config-reloaded", new String[0]));
            return true;
        }
        if (args.length >= 2 && args[1].equalsIgnoreCase("handset")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("player-only", new String[0]));
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("zshop.admin")) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission", new String[0]));
                return true;
            }
            String categoryKey = this.getCategoryKeyByName(args[0]);
            if (categoryKey == null) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("category-not-found", new String[0]));
                return true;
            }
            ItemStack handItem = player.getInventory().getItemInMainHand();
            if (handItem == null || handItem.getType() == Material.AIR) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("no-item-in-hand", new String[0]));
                return true;
            }
            double price = 10.0;
            int slot = -1;
            String itemCommand = null;
            if (args.length >= 3) {
                try {
                    price = Double.parseDouble(args[2]);
                    if (price < 0.0) {
                        sender.sendMessage(this.plugin.getConfigManager().getMessage("invalid-price", new String[0]));
                        return true;
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.plugin.getConfigManager().getMessage("invalid-price", new String[0]));
                    return true;
                }
            }
            if (args.length >= 4) {
                try {
                    slot = Integer.parseInt(args[3]);
                    if (slot < 10 || slot > 16) {
                        sender.sendMessage(this.plugin.getConfigManager().getMessage("invalid-slot", "%min%", "10", "%max%", "16"));
                        return true;
                    }
                }
                catch (NumberFormatException e) {
                    itemCommand = args[3];
                }
            }
            if (args.length >= 5 && itemCommand == null) {
                itemCommand = args[4];
            }
            String itemKey = "custom_" + UUID.randomUUID().toString().substring(0, 8);
            this.addItemToShop(categoryKey, itemKey, handItem, price, slot, itemCommand);
            sender.sendMessage(this.plugin.getConfigManager().getMessage("item-added", "item", handItem.getType().name(), "price", this.plugin.getConfigManager().formatPrice(price), "category", this.plugin.getGuiManager().getCategoryNameByKey(categoryKey), "slot", String.valueOf(slot == -1 ? this.findNextFreeSlot(categoryKey) : slot)));
            this.plugin.getGuiManager().refreshInventories();
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("player-only", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        String categoryKey = this.getCategoryKeyByName(args[0]);
        if (categoryKey != null) {
            if (!player.hasPermission("zshop.use")) {
                sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission", new String[0]));
                return true;
            }
            this.plugin.getGuiManager().openCategoryMenu(player, categoryKey);
            return true;
        }
        sender.sendMessage(this.plugin.getConfigManager().getMessage("category-not-found", new String[0]));
        return true;
    }

    private String getCategoryKeyByName(String name) {
        ConfigurationSection categorySettings = this.plugin.getConfig().getConfigurationSection("category-settings");
        if (categorySettings == null) {
            return null;
        }
        if (name.matches("category[1-7]")) {
            return name;
        }
        for (String key : categorySettings.getKeys(false)) {
            ConfigurationSection category = categorySettings.getConfigurationSection(key);
            if (category == null) continue;
            String categoryName = category.getString("name", "");
            categoryName = this.plugin.getConfigManager().stripColor(categoryName);
            if (!categoryName.equalsIgnoreCase(name)) continue;
            return key;
        }
        return null;
    }

    private void addItemToShop(String categoryKey, String itemKey, ItemStack item, double price, int slot, String itemCommand) {
        ItemMeta meta;
        String itemName;
        String string = itemName = item.getItemMeta() != null && item.getItemMeta().hasDisplayName() ? item.getItemMeta().getDisplayName() : this.plugin.getConfigManager().formatMaterialName(item.getType().name());
        if (slot == -1 || slot < 10 || slot > 16) {
            slot = this.findNextFreeSlot(categoryKey);
        }
        if (itemCommand != null && !itemCommand.isEmpty() && (meta = item.getItemMeta()) != null) {
            PersistentDataContainer container = meta.getPersistentDataContainer();
            container.set(this.commandKey, PersistentDataType.STRING, (Object)itemCommand);
            item.setItemMeta(meta);
        }
        this.plugin.getItemManager().saveCustomItem(itemKey, item);
        String path = categoryKey + ".items." + itemKey;
        this.plugin.getConfig().set(path + ".name", (Object)("&b" + itemName));
        this.plugin.getConfig().set(path + ".material", (Object)item.getType().name());
        this.plugin.getConfig().set(path + ".price", (Object)price);
        this.plugin.getConfig().set(path + ".slot", (Object)slot);
        if (itemCommand != null && !itemCommand.isEmpty()) {
            this.plugin.getConfig().set(path + ".command", (Object)itemCommand);
        }
        this.plugin.getConfig().set(path + ".has-meta", (Object)true);
        this.plugin.getConfig().set(path + ".lore", null);
        if (item.hasItemMeta()) {
            ItemMeta meta2 = item.getItemMeta();
            if (meta2.hasEnchants()) {
                for (Map.Entry entry : meta2.getEnchants().entrySet()) {
                    try {
                        String enchantName = ((Enchantment)entry.getKey()).getName().toLowerCase();
                        this.plugin.getConfig().set(path + ".enchants." + enchantName, entry.getValue());
                    }
                    catch (Exception e) {
                        try {
                            String enchantKey = ((Enchantment)entry.getKey()).getKey().getKey();
                            this.plugin.getConfig().set(path + ".enchants." + enchantKey, entry.getValue());
                        }
                        catch (Exception ex) {
                            String className = ((Enchantment)entry.getKey()).getClass().getSimpleName();
                            this.plugin.getConfig().set(path + ".enchants." + className, entry.getValue());
                        }
                    }
                }
            }
            if (!meta2.getItemFlags().isEmpty()) {
                ArrayList<String> flags = new ArrayList<String>();
                for (ItemFlag flag : meta2.getItemFlags()) {
                    flags.add(flag.name());
                }
                this.plugin.getConfig().set(path + ".item-flags", flags);
            }
        }
        this.plugin.saveConfig();
    }

    private int findNextFreeSlot(String categoryKey) {
        ConfigurationSection items = this.plugin.getConfig().getConfigurationSection(categoryKey + ".items");
        if (items == null) {
            return 10;
        }
        ArrayList<Integer> occupiedSlots = new ArrayList<Integer>();
        for (String key : items.getKeys(false)) {
            ConfigurationSection item = items.getConfigurationSection(key);
            if (item == null) continue;
            occupiedSlots.add(item.getInt("slot", 0));
        }
        for (int slot = 10; slot <= 16; ++slot) {
            if (occupiedSlots.contains(slot)) continue;
            return slot;
        }
        this.plugin.getLogger().warning("All slots 10-16 in category " + categoryKey + " are occupied. Overwriting slot 10.");
        return 10;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block9: {
            block10: {
                block8: {
                    ConfigurationSection categorySettings;
                    completions = new ArrayList<String>();
                    if (args.length != 1) break block8;
                    if ("reload".startsWith(args[0].toLowerCase()) && sender.hasPermission("zshop.reload")) {
                        completions.add("reload");
                    }
                    if ((categorySettings = this.plugin.getConfig().getConfigurationSection("category-settings")) == null) break block9;
                    for (String key : categorySettings.getKeys(false)) {
                        String name;
                        ConfigurationSection category = categorySettings.getConfigurationSection(key);
                        if (category == null) continue;
                        if (key.toLowerCase().startsWith(args[0].toLowerCase())) {
                            completions.add(key);
                        }
                        if (!(name = this.plugin.getConfigManager().stripColor(category.getString("name", key))).toLowerCase().startsWith(args[0].toLowerCase())) continue;
                        completions.add(name);
                    }
                    break block9;
                }
                if (args.length != 2) break block10;
                if (args[0].equalsIgnoreCase("reload")) {
                    return completions;
                }
                if (!sender.hasPermission("zshop.admin") || !"handset".startsWith(args[1].toLowerCase())) break block9;
                completions.add("handset");
                break block9;
            }
            if (args.length == 3 && args[1].equalsIgnoreCase("handset")) {
                completions.add("10");
                completions.add("50");
                completions.add("100");
                completions.add("500");
                completions.add("1000");
                completions.add("5000");
                completions.add("10000");
            } else if (args.length == 4 && args[1].equalsIgnoreCase("handset")) {
                for (int i = 10; i <= 16; ++i) {
                    completions.add(String.valueOf(i));
                }
            }
        }
        return completions;
    }
}

