/*
 * Decompiled with CFR 0.152.
 */
package me.dev.zShop.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.dev.zShop.Main;
import me.dev.zShop.utils.ItemBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;

public class GUIManager {
    private final Main plugin;
    private final Map<String, Inventory> categoryInventories;
    private final Map<UUID, PurchaseSession> purchaseSessions;
    private Inventory mainInventory;

    public GUIManager(Main plugin) {
        this.plugin = plugin;
        this.categoryInventories = new HashMap<String, Inventory>();
        this.purchaseSessions = new HashMap<UUID, PurchaseSession>();
        this.initializeInventories();
    }

    private void initializeInventories() {
        this.createMainInventory();
        ConfigurationSection categorySettings = this.plugin.getConfig().getConfigurationSection("category-settings");
        if (categorySettings != null) {
            for (String key : categorySettings.getKeys(false)) {
                this.createCategoryInventory(key);
            }
        }
    }

    private void createMainInventory() {
        ConfigurationSection mainConfig = this.plugin.getConfigManager().getMainMenuConfig();
        if (mainConfig == null) {
            this.plugin.getLogger().warning("Hauptmen\u00fc-Konfiguration nicht gefunden!");
            return;
        }
        String title = this.plugin.getConfigManager().colorize(mainConfig.getString("title", "Shop"));
        int size = mainConfig.getInt("size", 27);
        this.plugin.getLogger().info("Erstelle Hauptmen\u00fc: Titel = " + title + ", Gr\u00f6\u00dfe = " + size);
        this.mainInventory = Bukkit.createInventory((InventoryHolder)new ShopInventoryHolder("main"), (int)size, (String)title);
        ConfigurationSection categorySettings = this.plugin.getConfig().getConfigurationSection("category-settings");
        List globalCategoryLore = this.plugin.getConfig().getStringList("settings.category-lore");
        if (categorySettings != null) {
            for (String key : categorySettings.getKeys(false)) {
                Material material;
                ConfigurationSection settings = categorySettings.getConfigurationSection(key);
                if (settings == null) continue;
                String name = settings.getString("name", key);
                String materialName = settings.getString("material", "STONE");
                int slot = settings.getInt("slot", 0);
                this.plugin.getLogger().info("Kategorie: " + key + " Material: " + materialName + " Slot: " + slot);
                ArrayList<String> lore = new ArrayList<String>(globalCategoryLore);
                try {
                    material = Material.valueOf((String)materialName);
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Ung\u00fcltiges Material f\u00fcr Kategorie " + key + ": " + materialName);
                    material = Material.STONE;
                }
                ItemStack item = new ItemBuilder(material).setName(name).setLore(lore).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).build();
                this.mainInventory.setItem(slot, item);
            }
        } else {
            this.plugin.getLogger().severe("Keine Kategorie-Einstellungen in der Konfiguration gefunden!");
        }
    }

    private void createCategoryInventory(String category) {
        ConfigurationSection categoryConfig = this.plugin.getConfig().getConfigurationSection(category);
        ConfigurationSection categorySettings = this.plugin.getConfig().getConfigurationSection("category-settings." + category);
        if (categoryConfig == null) {
            this.plugin.getLogger().warning("Kategorie-Konfiguration f\u00fcr '" + category + "' nicht gefunden!");
            return;
        }
        if (categorySettings == null) {
            this.plugin.getLogger().warning("Kategorie-Einstellungen f\u00fcr '" + category + "' nicht gefunden!");
            return;
        }
        String title = this.plugin.getConfigManager().colorize(categorySettings.getString("title", category));
        int size = categoryConfig.getInt("size", 27);
        this.plugin.getLogger().info("Erstelle Kategorie-Inventar f\u00fcr " + category + ": Titel = " + title + ", Gr\u00f6\u00dfe = " + size);
        Inventory inventory = Bukkit.createInventory((InventoryHolder)new ShopInventoryHolder("category", category), (int)size, (String)title);
        List globalItemLore = this.plugin.getConfig().getStringList("settings.item-lore");
        ConfigurationSection items = categoryConfig.getConfigurationSection("items");
        if (items != null) {
            for (String key : items.getKeys(false)) {
                ItemStack item;
                Material material;
                ConfigurationSection itemSection = items.getConfigurationSection(key);
                if (itemSection == null) continue;
                String name = itemSection.getString("name", key);
                String materialName = itemSection.getString("material", "STONE");
                int slot = itemSection.getInt("slot", 0);
                double price = itemSection.getDouble("price", 0.0);
                if (slot < 10 || slot > 16) {
                    this.plugin.getLogger().warning("Item '" + key + "' hat ung\u00fcltigen Slot " + slot + ". Setze auf n\u00e4chsten freien Slot zwischen 10-16.");
                    slot = this.findNextFreeSlot(category, inventory);
                    this.plugin.getConfig().set(category + ".items." + key + ".slot", (Object)slot);
                    this.plugin.saveConfig();
                }
                this.plugin.getLogger().info("Item: " + key + " Material: " + materialName + " Slot: " + slot + " Preis: " + price);
                List lore = itemSection.contains("lore") ? itemSection.getStringList("lore") : new ArrayList(this.plugin.getConfig().getStringList("settings.item-lore"));
                ArrayList<String> processedLore = new ArrayList<String>();
                for (String loreLine : lore) {
                    String formattedPrice = this.plugin.getConfigManager().formatPrice(price);
                    String replacedLine = loreLine;
                    replacedLine = replacedLine.replace("{price}", formattedPrice);
                    replacedLine = replacedLine.replace("%price%", formattedPrice);
                    replacedLine = replacedLine.replace("{PRICE}", formattedPrice);
                    replacedLine = replacedLine.replace("%PRICE%", formattedPrice);
                    processedLore.add(replacedLine);
                }
                try {
                    material = Material.valueOf((String)materialName);
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Ung\u00fcltiges Material f\u00fcr Item " + key + ": " + materialName);
                    material = Material.STONE;
                }
                if (itemSection.getBoolean("has-meta", false)) {
                    ItemStack customItem = this.plugin.getItemManager().getCustomItem(key);
                    if (customItem != null) {
                        item = customItem.clone();
                        ItemMeta meta = item.getItemMeta();
                        if (meta != null) {
                            meta.setDisplayName(this.plugin.getConfigManager().colorize(name));
                            ArrayList<String> coloredLore = new ArrayList<String>();
                            for (String line : processedLore) {
                                coloredLore.add(this.plugin.getConfigManager().colorize(line));
                            }
                            meta.setLore(coloredLore);
                            item.setItemMeta(meta);
                        }
                    } else {
                        item = this.createItemFromConfig(material, name, processedLore, itemSection);
                    }
                } else {
                    item = this.createItemFromConfig(material, name, processedLore, itemSection);
                }
                inventory.setItem(slot, item);
            }
        } else {
            this.plugin.getLogger().warning("Keine Items in Kategorie '" + category + "' gefunden!");
        }
        ItemStack backButton = this.plugin.getConfigManager().getShopHead("back-button");
        if (backButton == null) {
            this.plugin.getLogger().severe("Failed to create back button for category " + category);
            backButton = new ItemStack(Material.RED_DYE);
            ItemMeta meta = backButton.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(this.plugin.getConfigManager().colorize("&c\u00ab Back"));
                backButton.setItemMeta(meta);
            }
        }
        inventory.setItem(size - 5, backButton);
        this.categoryInventories.put(category, inventory);
    }

    private List<String> createLoreList(String ... lines) {
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : lines) {
            lore.add(line);
        }
        return lore;
    }

    private ItemStack createItemFromConfig(Material material, String name, List<String> lore, ConfigurationSection itemSection) {
        ItemBuilder builder = new ItemBuilder(material).setName(name).setLore(lore).addItemFlags(ItemFlag.HIDE_ATTRIBUTES);
        ConfigurationSection enchants = itemSection.getConfigurationSection("enchants");
        if (enchants != null) {
            for (String enchantKey : enchants.getKeys(false)) {
                try {
                    Enchantment enchantment = Enchantment.getByName((String)enchantKey.toUpperCase());
                    if (enchantment == null) {
                        try {
                            enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchantKey.toLowerCase()));
                        }
                        catch (NoClassDefFoundError | NoSuchMethodError e) {
                            this.plugin.getLogger().warning("NamespacedKey nicht unterst\u00fctzt in dieser Minecraft-Version.");
                        }
                    }
                    if (enchantment != null) {
                        int level = enchants.getInt(enchantKey, 1);
                        builder.addEnchant(enchantment, level, true);
                        continue;
                    }
                    this.plugin.getLogger().warning("Verzauberung nicht gefunden: " + enchantKey);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Fehler beim Hinzuf\u00fcgen der Verzauberung " + enchantKey + ": " + e.getMessage());
                }
            }
            builder.addItemFlags(ItemFlag.HIDE_ENCHANTS);
        }
        List flagsList = itemSection.getStringList("item-flags");
        for (String flagName : flagsList) {
            try {
                ItemFlag flag = ItemFlag.valueOf((String)flagName);
                builder.addItemFlags(flag);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return builder.build();
    }

    private ItemStack createPotion(String type) {
        block7: {
            try {
                ItemStack potion = new ItemStack(Material.POTION);
                PotionMeta meta = (PotionMeta)potion.getItemMeta();
                if (meta == null) break block7;
                try {
                    PotionType potionType = PotionType.valueOf((String)type.toUpperCase());
                    try {
                        if (potionType.getEffectType() != null) {
                            meta.setMainEffect(potionType.getEffectType());
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    potion.setItemMeta((ItemMeta)meta);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return potion;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ItemStack(Material.POTION);
    }

    public void openMainMenu(Player player) {
        player.openInventory(this.mainInventory);
    }

    public void openCategoryMenu(Player player, String category) {
        Inventory inventory = this.categoryInventories.get(category);
        if (inventory == null) {
            this.createCategoryInventory(category);
            inventory = this.categoryInventories.get(category);
            if (inventory == null) {
                player.sendMessage(this.plugin.getConfigManager().getMessage("category-not-found", new String[0]));
                return;
            }
        }
        player.openInventory(inventory);
    }

    public void openPurchaseMenu(Player player, String category, String itemKey, ItemStack clickedItem) {
        ItemStack originalItem;
        ConfigurationSection itemConfig = this.plugin.getConfigManager().getCategoryItems(category);
        if (itemConfig == null) {
            return;
        }
        ConfigurationSection itemSection = itemConfig.getConfigurationSection(itemKey);
        if (itemSection == null) {
            return;
        }
        String itemName = this.plugin.getConfigManager().colorize(itemSection.getString("name", itemKey));
        String materialName = itemSection.getString("material", "STONE");
        double price = itemSection.getDouble("price", 0.0);
        Material material = Material.getMaterial((String)materialName);
        if (material == null) {
            material = Material.STONE;
        }
        String title = this.plugin.getConfig().getString("purchase-gui.title", "&8\u00bb &bKauf-Men\u00fc: &7%item%").replace("%item%", itemName);
        title = this.plugin.getConfigManager().colorize(title);
        Inventory inventory = Bukkit.createInventory((InventoryHolder)new ShopInventoryHolder("purchase", category), (int)27, (String)title);
        ItemStack displayItemBase = clickedItem.clone();
        displayItemBase.setAmount(1);
        if (itemSection.getBoolean("has-meta", false) && (originalItem = this.plugin.getItemManager().getCustomItem(itemKey)) != null) {
            PurchaseSession session = new PurchaseSession(category, itemKey, price, originalItem, 1);
            this.purchaseSessions.put(player.getUniqueId(), session);
            this.updatePurchaseInventory(inventory, session, itemName);
            player.openInventory(inventory);
            return;
        }
        PurchaseSession session = new PurchaseSession(category, itemKey, price, displayItemBase, 1);
        this.purchaseSessions.put(player.getUniqueId(), session);
        this.updatePurchaseInventory(inventory, session, itemName);
        player.openInventory(inventory);
    }

    private void updatePurchaseInventory(Inventory inventory, PurchaseSession session, String itemName) {
        inventory.clear();
        ItemStack minusSixteen = new ItemBuilder(Material.RED_STAINED_GLASS_PANE).setName(this.plugin.getConfigManager().colorize("&c-16")).setLore(this.createLoreList(this.plugin.getConfigManager().colorize("&7Decrease amount by 16"))).build();
        inventory.setItem(10, minusSixteen);
        ItemStack minusThirtyTwo = new ItemBuilder(Material.RED_STAINED_GLASS_PANE).setName(this.plugin.getConfigManager().colorize("&c-32")).setLore(this.createLoreList(this.plugin.getConfigManager().colorize("&7Decrease amount by 32"))).build();
        inventory.setItem(11, minusThirtyTwo);
        ItemStack minusSixtyFour = new ItemBuilder(Material.RED_STAINED_GLASS_PANE).setName(this.plugin.getConfigManager().colorize("&c-64")).setLore(this.createLoreList(this.plugin.getConfigManager().colorize("&7Decrease amount by 64"))).build();
        inventory.setItem(12, minusSixtyFour);
        ItemStack displayItem = session.getItemStack().clone();
        int displayAmount = Math.min(session.getAmount(), displayItem.getMaxStackSize());
        displayItem.setAmount(displayAmount > 0 ? displayAmount : 1);
        if (displayItem != null) {
            ItemMeta meta = displayItem.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(this.plugin.getConfigManager().colorize("&b" + itemName + " &7x" + session.getAmount()));
                ArrayList<String> coloredLore = new ArrayList<String>();
                coloredLore.add(this.plugin.getConfigManager().colorize("&7Price per unit: &a" + this.plugin.getConfigManager().formatPrice(session.getUnitPrice())));
                coloredLore.add(this.plugin.getConfigManager().colorize("&7Total price: &a" + this.plugin.getConfigManager().formatPrice(session.getTotalPrice())));
                coloredLore.add("");
                coloredLore.add(this.plugin.getConfigManager().colorize("&7Current amount: &e" + session.getAmount()));
                meta.setLore(coloredLore);
                displayItem.setItemMeta(meta);
            }
            inventory.setItem(13, displayItem);
        }
        ItemStack plusSixteen = new ItemBuilder(Material.LIME_STAINED_GLASS_PANE).setName(this.plugin.getConfigManager().colorize("&a+16")).setLore(this.createLoreList(this.plugin.getConfigManager().colorize("&7Increase amount by 16"))).build();
        inventory.setItem(14, plusSixteen);
        ItemStack plusThirtyTwo = new ItemBuilder(Material.LIME_STAINED_GLASS_PANE).setName(this.plugin.getConfigManager().colorize("&a+32")).setLore(this.createLoreList(this.plugin.getConfigManager().colorize("&7Increase amount by 32"))).build();
        inventory.setItem(15, plusThirtyTwo);
        ItemStack plusSixtyFour = new ItemBuilder(Material.LIME_STAINED_GLASS_PANE).setName(this.plugin.getConfigManager().colorize("&a+64")).setLore(this.createLoreList(this.plugin.getConfigManager().colorize("&7Increase amount by 64"))).build();
        inventory.setItem(16, plusSixtyFour);
        ItemStack confirmButton = this.plugin.getConfigManager().getShopHead("buy-button");
        inventory.setItem(26, confirmButton);
        ItemStack cancelButton = this.plugin.getConfigManager().getShopHead("cancel-button");
        inventory.setItem(18, cancelButton);
    }

    private void addButton(Inventory inventory, ConfigurationSection config, String key, int modifier) {
        ConfigurationSection buttonConfig = config.getConfigurationSection(key);
        if (buttonConfig == null) {
            return;
        }
        Material material = Material.getMaterial((String)buttonConfig.getString("material", "STONE"));
        if (material == null) {
            material = Material.STONE;
        }
        ItemStack button = new ItemBuilder(material).setName(this.plugin.getConfigManager().colorize(buttonConfig.getString("name", key))).setLore(buttonConfig.getStringList("lore")).build();
        inventory.setItem(buttonConfig.getInt("slot", 0), button);
    }

    public void updatePurchaseMenu(Player player) {
        PurchaseSession session = this.purchaseSessions.get(player.getUniqueId());
        if (session == null) {
            return;
        }
        String itemName = this.plugin.getConfigManager().colorize(this.plugin.getConfigManager().getCategoryItems(session.getCategory()).getConfigurationSection(session.getItemKey()).getString("name", session.getItemKey()));
        this.updatePurchaseInventory(player.getOpenInventory().getTopInventory(), session, itemName);
    }

    public PurchaseSession getPurchaseSession(UUID playerUUID) {
        return this.purchaseSessions.get(playerUUID);
    }

    public void removePurchaseSession(UUID playerUUID) {
        this.purchaseSessions.remove(playerUUID);
    }

    public boolean isShopInventory(Inventory inventory) {
        return inventory.getHolder() instanceof ShopInventoryHolder;
    }

    public boolean isPurchaseInventory(Inventory inventory) {
        return inventory.getHolder() instanceof ShopInventoryHolder && ((ShopInventoryHolder)inventory.getHolder()).getType().equals("purchase");
    }

    public String getCategoryByInventory(Inventory inventory) {
        ShopInventoryHolder holder;
        if (inventory.getHolder() instanceof ShopInventoryHolder && (holder = (ShopInventoryHolder)inventory.getHolder()).getType().equals("category")) {
            return holder.getCategory();
        }
        return null;
    }

    public String getCategoryNameByKey(String categoryKey) {
        ConfigurationSection settings = this.plugin.getConfig().getConfigurationSection("category-settings." + categoryKey);
        if (settings != null) {
            return this.plugin.getConfigManager().colorize(settings.getString("name", categoryKey));
        }
        return categoryKey;
    }

    public String findItemKeyByMaterial(String category, Material material, String displayName) {
        ConfigurationSection items = this.plugin.getConfigManager().getCategoryItems(category);
        if (items == null) {
            return null;
        }
        for (String key : items.getKeys(false)) {
            ConfigurationSection itemSection = items.getConfigurationSection(key);
            if (itemSection == null) continue;
            String materialName = itemSection.getString("material", "STONE");
            String name = this.plugin.getConfigManager().colorize(itemSection.getString("name", key));
            Material configMaterial = Material.getMaterial((String)materialName);
            if (configMaterial == null || configMaterial != material || !displayName.equals(name)) continue;
            return key;
        }
        return null;
    }

    public void refreshInventories() {
        this.categoryInventories.clear();
        this.createMainInventory();
        ConfigurationSection categorySettings = this.plugin.getConfig().getConfigurationSection("category-settings");
        if (categorySettings != null) {
            for (String key : categorySettings.getKeys(false)) {
                this.createCategoryInventory(key);
            }
        }
    }

    private int findNextFreeSlot(String category, Inventory inventory) {
        for (int slot = 10; slot <= 16; ++slot) {
            if (inventory.getItem(slot) != null) continue;
            return slot;
        }
        this.plugin.getLogger().warning("All slots 10-16 in category " + category + " are occupied. Overwriting slot 10.");
        return 10;
    }

    public static class ShopInventoryHolder
    implements InventoryHolder {
        private final String type;
        private final String category;

        public ShopInventoryHolder(String type) {
            this(type, null);
        }

        public ShopInventoryHolder(String type, String category) {
            this.type = type;
            this.category = category;
        }

        public String getType() {
            return this.type;
        }

        public String getCategory() {
            return this.category;
        }

        public Inventory getInventory() {
            return null;
        }
    }

    public static class PurchaseSession {
        private final String category;
        private final String itemKey;
        private final double unitPrice;
        private final ItemStack itemStack;
        private int amount;

        public PurchaseSession(String category, String itemKey, double unitPrice, ItemStack itemStack, int amount) {
            this.category = category;
            this.itemKey = itemKey;
            this.unitPrice = unitPrice;
            this.itemStack = itemStack;
            this.amount = amount;
        }

        public String getCategory() {
            return this.category;
        }

        public String getItemKey() {
            return this.itemKey;
        }

        public double getUnitPrice() {
            return this.unitPrice;
        }

        public double getTotalPrice() {
            return this.unitPrice * (double)this.amount;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public Material getMaterial() {
            return this.itemStack.getType();
        }

        public int getAmount() {
            return this.amount;
        }

        public void addAmount(int amountToAdd) {
            this.amount += amountToAdd;
            if (this.amount < 1) {
                this.amount = 1;
            }
            if (this.amount > 128) {
                this.amount = 128;
            }
        }

        public void resetAmount() {
        }
    }
}

