/*
 * Decompiled with CFR 0.152.
 */
package me.dev.zShop.listeners;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.dev.zShop.Main;
import me.dev.zShop.gui.GUIManager;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.banner.Pattern;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public class GUIListener
implements Listener {
    private final Main plugin;
    private final Map<UUID, Long> lastPurchase = new HashMap<UUID, Long>();
    private static final long PURCHASE_COOLDOWN = 250L;
    private final NamespacedKey commandKey;

    public GUIListener(Main plugin) {
        this.plugin = plugin;
        this.commandKey = new NamespacedKey((Plugin)plugin, "shop_command");
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        InventoryHolder inventoryHolder = event.getView().getTopInventory().getHolder();
        if (inventoryHolder instanceof GUIManager.ShopInventoryHolder) {
            GUIManager.ShopInventoryHolder holder = (GUIManager.ShopInventoryHolder)inventoryHolder;
            event.setCancelled(true);
            if (event.getClickedInventory() == null || event.getClickedInventory() != event.getView().getTopInventory()) {
                return;
            }
            ItemStack clickedItem = event.getCurrentItem();
            if (clickedItem == null || clickedItem.getType() == Material.AIR) {
                return;
            }
            this.plugin.getConfigManager().playSound(player, "item_click");
            switch (holder.getType()) {
                case "main": {
                    this.handleMainMenuClick(player, clickedItem);
                    break;
                }
                case "category": {
                    this.handleCategoryItemClick(player, clickedItem, holder.getCategory());
                    break;
                }
                case "purchase": {
                    this.handlePurchaseMenuClick(player, event.getSlot(), clickedItem);
                }
            }
        }
    }

    private void handleMainMenuClick(Player player, ItemStack clickedItem) {
        if (clickedItem == null) {
            return;
        }
        this.plugin.getConfigManager().playSound(player, "category_click");
        this.plugin.getLogger().info("Main menu click on: " + clickedItem.getType().name());
        ConfigurationSection categorySettings = this.plugin.getConfig().getConfigurationSection("category-settings");
        if (categorySettings == null) {
            this.plugin.getLogger().warning("No category settings found in configuration!");
            return;
        }
        for (String category : categorySettings.getKeys(false)) {
            String configMaterial = categorySettings.getString(category + ".material", "STONE");
            this.plugin.getLogger().info("Checking category: " + category + ", Material: " + configMaterial + " vs. " + clickedItem.getType().name());
            if (!configMaterial.equalsIgnoreCase(clickedItem.getType().name())) continue;
            this.plugin.getLogger().info("Category found: " + category + ", opening menu.");
            this.plugin.getGuiManager().openCategoryMenu(player, category);
            return;
        }
        this.plugin.getLogger().warning("No matching category found for item " + clickedItem.getType().name() + "!");
    }

    private void handleCategoryItemClick(Player player, ItemStack clickedItem, String category) {
        if (this.isButton(clickedItem, "back-button")) {
            this.plugin.getLogger().info("Back button clicked in category " + category);
            this.plugin.getConfigManager().playSound(player, "menu_close");
            this.plugin.getGuiManager().openMainMenu(player);
            return;
        }
        ConfigurationSection categoryItems = this.plugin.getConfig().getConfigurationSection(category + ".items");
        if (categoryItems == null) {
            this.plugin.getLogger().warning("No items found in category '" + category + "'!");
            return;
        }
        int clickedSlot = player.getOpenInventory().getTopInventory().first(clickedItem);
        for (String itemKey : categoryItems.getKeys(false)) {
            int configSlot = categoryItems.getInt(itemKey + ".slot", -1);
            if (configSlot != clickedSlot) continue;
            this.plugin.getGuiManager().openPurchaseMenu(player, category, itemKey, clickedItem);
            return;
        }
    }

    private void handlePurchaseMenuClick(Player player, int slot, ItemStack clickedItem) {
        GUIManager.PurchaseSession session = this.plugin.getGuiManager().getPurchaseSession(player.getUniqueId());
        if (session == null) {
            return;
        }
        if (this.isButton(clickedItem, "buy-button") || slot == 26) {
            this.handlePurchase(player, session);
            return;
        }
        if (this.isButton(clickedItem, "cancel-button") || slot == 18) {
            this.plugin.getConfigManager().playSound(player, "menu_close");
            this.plugin.getGuiManager().openCategoryMenu(player, session.getCategory());
            return;
        }
        switch (slot) {
            case 10: {
                this.changeAmount(player, session, -16);
                this.plugin.getConfigManager().playSound(player, "amount_change");
                break;
            }
            case 11: {
                this.changeAmount(player, session, -32);
                this.plugin.getConfigManager().playSound(player, "amount_change");
                break;
            }
            case 12: {
                this.changeAmount(player, session, -64);
                this.plugin.getConfigManager().playSound(player, "amount_change");
                break;
            }
            case 14: {
                this.changeAmount(player, session, 16);
                this.plugin.getConfigManager().playSound(player, "amount_change");
                break;
            }
            case 15: {
                this.changeAmount(player, session, 32);
                this.plugin.getConfigManager().playSound(player, "amount_change");
                break;
            }
            case 16: {
                this.changeAmount(player, session, 64);
                this.plugin.getConfigManager().playSound(player, "amount_change");
            }
        }
    }

    private boolean isButton(ItemStack item, String buttonKey) {
        if (item == null) {
            return false;
        }
        ItemStack buttonItem = this.plugin.getConfigManager().getShopHead(buttonKey);
        if (buttonItem == null) {
            return false;
        }
        if (item.getType() != buttonItem.getType()) {
            return false;
        }
        if (item.hasItemMeta() && buttonItem.hasItemMeta()) {
            ItemMeta itemMeta = item.getItemMeta();
            ItemMeta buttonMeta = buttonItem.getItemMeta();
            if (itemMeta.hasDisplayName() && buttonMeta.hasDisplayName()) {
                return itemMeta.getDisplayName().equals(buttonMeta.getDisplayName());
            }
        }
        return true;
    }

    private void changeAmount(Player player, GUIManager.PurchaseSession session, int change) {
        int currentAmount = session.getAmount();
        int newAmount = Math.max(1, Math.min(currentAmount + change, 2304));
        session.addAmount(change);
        this.plugin.getGuiManager().updatePurchaseMenu(player);
    }

    private void handlePurchase(Player player, GUIManager.PurchaseSession session) {
        String itemName;
        int neededSlots;
        if (this.lastPurchase.containsKey(player.getUniqueId())) {
            long lastTime = this.lastPurchase.get(player.getUniqueId());
            if (System.currentTimeMillis() - lastTime < 250L) {
                return;
            }
        }
        this.lastPurchase.put(player.getUniqueId(), System.currentTimeMillis());
        Economy economy = this.plugin.getEconomy();
        double totalPrice = session.getTotalPrice();
        if (economy.getBalance((OfflinePlayer)player) < totalPrice) {
            player.sendMessage(this.plugin.getConfigManager().getMessage("not-enough-money", "price", this.plugin.getConfigManager().formatPrice(totalPrice)));
            this.plugin.getConfigManager().playSound(player, "purchase_failed");
            return;
        }
        ConfigurationSection itemSection = this.plugin.getConfig().getConfigurationSection(session.getCategory() + ".items." + session.getItemKey());
        boolean hasCommand = itemSection != null && itemSection.contains("command") && !itemSection.getString("command", "").isEmpty();
        int freeSlots = 0;
        for (ItemStack item : player.getInventory().getStorageContents()) {
            if (item == null || item.getType() == Material.AIR) {
                ++freeSlots;
                continue;
            }
            if (hasCommand || !item.isSimilar(session.getItemStack()) || item.getAmount() >= item.getMaxStackSize()) continue;
            ++freeSlots;
        }
        if (hasCommand) {
            neededSlots = 1;
        } else {
            int stackSize = session.getItemStack().getMaxStackSize();
            neededSlots = (int)Math.ceil((double)session.getAmount() / (double)stackSize);
        }
        if (freeSlots < neededSlots) {
            player.sendMessage(this.plugin.getConfigManager().getMessage("inventory-full", new String[0]));
            this.plugin.getConfigManager().playSound(player, "inventory_full");
            return;
        }
        EconomyResponse response = economy.withdrawPlayer((OfflinePlayer)player, totalPrice);
        if (!response.transactionSuccess()) {
            player.sendMessage(this.plugin.getConfigManager().getMessage("transaction-error", "%error%", response.errorMessage));
            this.plugin.getConfigManager().playSound(player, "transaction_error");
            return;
        }
        String string = itemName = itemSection != null ? this.plugin.getConfigManager().colorize(itemSection.getString("name", "Item")) : session.getItemStack().getType().name();
        if (hasCommand) {
            String command = itemSection.getString("command");
            for (int i = 0; i < session.getAmount(); ++i) {
                this.executeCommand(player, command);
            }
            player.sendMessage(this.plugin.getConfigManager().getMessage("purchase-successful", "amount", String.valueOf(session.getAmount()), "item", itemName, "price", this.plugin.getConfigManager().formatPrice(totalPrice)));
            this.plugin.getConfigManager().playSound(player, "purchase_success");
        } else {
            int currentAmount;
            ItemStack originalItem;
            ItemStack itemToGive = itemSection != null && itemSection.getBoolean("has-meta", false) ? ((originalItem = this.plugin.getItemManager().getCustomItem(session.getItemKey())) != null ? originalItem.clone() : this.createCleanItem(session.getItemStack())) : this.createCleanItem(session.getItemStack());
            for (int remainingAmount = session.getAmount(); remainingAmount > 0; remainingAmount -= currentAmount) {
                currentAmount = Math.min(remainingAmount, itemToGive.getMaxStackSize());
                ItemStack currentItem = itemToGive.clone();
                currentItem.setAmount(currentAmount);
                player.getInventory().addItem(new ItemStack[]{currentItem});
            }
            player.sendMessage(this.plugin.getConfigManager().getMessage("purchase-successful", "amount", String.valueOf(session.getAmount()), "item", itemName, "price", this.plugin.getConfigManager().formatPrice(totalPrice)));
            this.plugin.getConfigManager().playSound(player, "purchase_success");
        }
        this.plugin.getTransactionLogger().logPurchase(player, session.getItemStack(), session.getAmount(), totalPrice, session.getCategory());
        this.plugin.getGuiManager().updatePurchaseMenu(player);
    }

    private void executeCommand(Player player, String command) {
        if (command == null || command.isEmpty()) {
            return;
        }
        command = command.replace("%player%", player.getName());
        try {
            this.plugin.getLogger().info("Executing command for player " + player.getName() + ": " + command);
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
            this.plugin.getConfigManager().playSound(player, "command_execute");
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error executing command: " + e.getMessage());
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (inventoryHolder instanceof GUIManager.ShopInventoryHolder) {
            GUIManager.ShopInventoryHolder holder = (GUIManager.ShopInventoryHolder)inventoryHolder;
            this.plugin.getConfigManager().playSound(player, "menu_close");
            if (holder.getType().equals("purchase")) {
                this.plugin.getGuiManager().removePurchaseSession(player.getUniqueId());
            }
        }
    }

    private ItemStack createCleanItem(ItemStack shopItem) {
        ItemStack cleanItem = new ItemStack(shopItem.getType(), 1);
        if (!shopItem.hasItemMeta()) {
            return cleanItem;
        }
        ItemMeta shopMeta = shopItem.getItemMeta();
        ItemMeta cleanMeta = cleanItem.getItemMeta();
        if (cleanMeta != null) {
            if (shopMeta.hasEnchants()) {
                shopMeta.getEnchants().forEach((enchant, level) -> cleanMeta.addEnchant(enchant, level.intValue(), true));
            }
            for (ItemFlag flag : shopMeta.getItemFlags()) {
                cleanMeta.addItemFlags(new ItemFlag[]{flag});
            }
            if (shopMeta.isUnbreakable()) {
                cleanMeta.setUnbreakable(true);
            }
            if (shopMeta instanceof Repairable) {
                Repairable repairable = (Repairable)shopMeta;
                if (shopMeta instanceof Repairable) {
                    Repairable shopRepairable = (Repairable)shopMeta;
                    repairable.setRepairCost(shopRepairable.getRepairCost());
                }
            }
            if (shopMeta.hasAttributeModifiers()) {
                cleanMeta.setAttributeModifiers(shopMeta.getAttributeModifiers());
            }
            this.transferSpecificMeta(shopMeta, cleanMeta);
            cleanItem.setItemMeta(cleanMeta);
        }
        return cleanItem;
    }

    private void transferSpecificMeta(ItemMeta sourceMeta, ItemMeta targetMeta) {
        if (sourceMeta instanceof PotionMeta) {
            PotionMeta sourcePotionMeta = (PotionMeta)sourceMeta;
            if (targetMeta instanceof PotionMeta) {
                PotionMeta targetPotionMeta = (PotionMeta)targetMeta;
                targetPotionMeta.setBasePotionData(sourcePotionMeta.getBasePotionData());
                if (sourcePotionMeta.hasCustomEffects()) {
                    for (PotionEffect effect : sourcePotionMeta.getCustomEffects()) {
                        targetPotionMeta.addCustomEffect(effect, true);
                    }
                }
            }
        }
        if (sourceMeta instanceof BookMeta) {
            BookMeta sourceBookMeta = (BookMeta)sourceMeta;
            if (targetMeta instanceof BookMeta) {
                BookMeta targetBookMeta = (BookMeta)targetMeta;
                if (sourceBookMeta.hasTitle()) {
                    targetBookMeta.setTitle(sourceBookMeta.getTitle());
                }
                if (sourceBookMeta.hasAuthor()) {
                    targetBookMeta.setAuthor(sourceBookMeta.getAuthor());
                }
                if (sourceBookMeta.hasPages()) {
                    targetBookMeta.setPages(sourceBookMeta.getPages());
                }
            }
        }
        if (sourceMeta instanceof LeatherArmorMeta) {
            LeatherArmorMeta sourceArmorMeta = (LeatherArmorMeta)sourceMeta;
            if (targetMeta instanceof LeatherArmorMeta) {
                LeatherArmorMeta targetArmorMeta = (LeatherArmorMeta)targetMeta;
                targetArmorMeta.setColor(sourceArmorMeta.getColor());
            }
        }
        if (sourceMeta instanceof SkullMeta) {
            SkullMeta sourceSkullMeta = (SkullMeta)sourceMeta;
            if (targetMeta instanceof SkullMeta) {
                SkullMeta targetSkullMeta = (SkullMeta)targetMeta;
                if (sourceSkullMeta.hasOwner()) {
                    targetSkullMeta.setOwningPlayer(sourceSkullMeta.getOwningPlayer());
                }
            }
        }
        if (sourceMeta instanceof BannerMeta) {
            BannerMeta sourceBannerMeta = (BannerMeta)sourceMeta;
            if (targetMeta instanceof BannerMeta) {
                BannerMeta targetBannerMeta = (BannerMeta)targetMeta;
                for (Pattern pattern : sourceBannerMeta.getPatterns()) {
                    targetBannerMeta.addPattern(pattern);
                }
            }
        }
        if (sourceMeta instanceof FireworkMeta) {
            FireworkMeta sourceFireworkMeta = (FireworkMeta)sourceMeta;
            if (targetMeta instanceof FireworkMeta) {
                FireworkMeta targetFireworkMeta = (FireworkMeta)targetMeta;
                targetFireworkMeta.setPower(sourceFireworkMeta.getPower());
                for (PotionEffect effect : sourceFireworkMeta.getEffects()) {
                    targetFireworkMeta.addEffect((FireworkEffect)effect);
                }
            }
        }
        if (sourceMeta instanceof MapMeta) {
            MapMeta sourceMapMeta = (MapMeta)sourceMeta;
            if (targetMeta instanceof MapMeta) {
                MapMeta targetMapMeta = (MapMeta)targetMeta;
                if (sourceMapMeta.hasMapView()) {
                    targetMapMeta.setMapView(sourceMapMeta.getMapView());
                }
                targetMapMeta.setScaling(sourceMapMeta.isScaling());
            }
        }
        if (sourceMeta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta sourceEnchantMeta = (EnchantmentStorageMeta)sourceMeta;
            if (targetMeta instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta targetEnchantMeta = (EnchantmentStorageMeta)targetMeta;
                for (Enchantment enchant : sourceEnchantMeta.getStoredEnchants().keySet()) {
                    targetEnchantMeta.addStoredEnchant(enchant, sourceEnchantMeta.getStoredEnchantLevel(enchant), true);
                }
            }
        }
    }
}

