/*
 * Decompiled with CFR 0.152.
 */
package me.dev.zShop.listeners;

import me.dev.zShop.Main;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemInteractionListener
implements Listener {
    private final Main plugin;
    private final NamespacedKey commandKey;

    public ItemInteractionListener(Main plugin) {
        this.plugin = plugin;
        this.commandKey = new NamespacedKey((Plugin)plugin, "shop_command");
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        String command;
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (container.has(this.commandKey, PersistentDataType.STRING) && (command = (String)container.get(this.commandKey, PersistentDataType.STRING)) != null && !command.isEmpty()) {
            this.executeCommand(player, command);
            this.plugin.getConfigManager().playSound(player, "command_execute");
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
            } else {
                player.getInventory().removeItem(new ItemStack[]{item});
            }
            event.setCancelled(true);
        }
    }

    private void executeCommand(Player player, String command) {
        if (command == null || command.isEmpty()) {
            return;
        }
        command = command.replace("%player%", player.getName());
        try {
            this.plugin.getLogger().info("Executing command for player " + player.getName() + ": " + command);
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error executing command: " + e.getMessage());
        }
    }
}

