/*
 * Decompiled with CFR 0.152.
 */
package me.dev.zShop.utils;

import java.text.DecimalFormat;
import java.util.List;
import me.dev.zShop.Main;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ConfigManager {
    private final Main plugin;

    public ConfigManager(Main plugin) {
        this.plugin = plugin;
    }

    public String getPrefix() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("settings.prefix", "&8[&bz&3Shop&8] &7"));
    }

    public String formatPrice(double price) {
        if ((price = Math.max(0.0, price)) >= 1.0E9) {
            return new DecimalFormat("#.##").format(price / 1.0E9) + this.plugin.getConfig().getString("price-format.billion", "b");
        }
        if (price >= 1000000.0) {
            return new DecimalFormat("#.##").format(price / 1000000.0) + this.plugin.getConfig().getString("price-format.million", "m");
        }
        if (price >= 1000.0) {
            return new DecimalFormat("#.##").format(price / 1000.0) + this.plugin.getConfig().getString("price-format.thousand", "k");
        }
        return new DecimalFormat("#.##").format(price);
    }

    public String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public ConfigurationSection getMainMenuConfig() {
        return this.plugin.getConfig().getConfigurationSection("main-menu");
    }

    public ConfigurationSection getCategoryConfig(String category) {
        ConfigurationSection categorySection = this.plugin.getConfig().getConfigurationSection(category);
        if (categorySection == null) {
            this.plugin.getLogger().warning("Kategorie '" + category + "' nicht in der Konfiguration gefunden!");
            return null;
        }
        if (!categorySection.contains("items")) {
            this.plugin.getLogger().warning("Kategorie '" + category + "' hat keine Items-Sektion!");
            return null;
        }
        return categorySection;
    }

    public ConfigurationSection getCategoryItems(String category) {
        ConfigurationSection categorySection = this.getCategoryConfig(category);
        return categorySection != null ? categorySection.getConfigurationSection("items") : null;
    }

    public ConfigurationSection getCategorySettings() {
        return this.plugin.getConfig().getConfigurationSection("category-settings");
    }

    public String getCategoryTitle(String category) {
        ConfigurationSection settings = this.plugin.getConfig().getConfigurationSection("category-settings." + category);
        if (settings != null) {
            return this.colorize(settings.getString("title", "Shop: " + category));
        }
        return this.colorize("&8\u00bb &7Shop: " + category);
    }

    public String getCategoryName(String category) {
        ConfigurationSection settings = this.plugin.getConfig().getConfigurationSection("category-settings." + category);
        if (settings != null) {
            return this.colorize(settings.getString("name", category));
        }
        return category;
    }

    public String getMessage(String key, String ... replacements) {
        String message = this.plugin.getConfig().getString("messages." + key, "");
        if (message.isEmpty()) {
            return this.getPrefix() + "Message not found: " + key;
        }
        if (replacements != null && replacements.length >= 2) {
            for (int i = 0; i < replacements.length; i += 2) {
                if (i + 1 >= replacements.length) continue;
                Object placeholder = replacements[i];
                if (!((String)placeholder).startsWith("%")) {
                    placeholder = "%" + (String)placeholder;
                }
                if (!((String)placeholder).endsWith("%")) {
                    placeholder = (String)placeholder + "%";
                }
                message = message.replace((CharSequence)placeholder, replacements[i + 1]);
            }
        }
        return this.getPrefix() + this.colorize(message);
    }

    public String stripColor(String text) {
        if (text == null) {
            return "";
        }
        return ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)text));
    }

    public String formatMaterialName(String materialName) {
        if (materialName == null) {
            return "Unknown";
        }
        if (materialName.startsWith("LEGACY_")) {
            materialName = materialName.substring(7);
        }
        String[] words = materialName.toLowerCase().split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.length() <= 0) continue;
            result.append(word.substring(0, 1).toUpperCase()).append(word.substring(1)).append(" ");
        }
        return result.toString().trim();
    }

    public String getItemCommand(String category, String itemKey) {
        String path = category + ".items." + itemKey + ".command";
        return this.plugin.getConfig().getString(path);
    }

    public boolean hasItemCommand(String category, String itemKey) {
        String path = category + ".items." + itemKey + ".command";
        return this.plugin.getConfig().contains(path) && this.plugin.getConfig().getString(path) != null && !this.plugin.getConfig().getString(path).isEmpty();
    }

    public String getSound(String action) {
        return this.plugin.getConfig().getString("sounds." + action + ".sound");
    }

    public float getSoundVolume(String action) {
        return (float)this.plugin.getConfig().getDouble("sounds." + action + ".volume", 1.0);
    }

    public float getSoundPitch(String action) {
        return (float)this.plugin.getConfig().getDouble("sounds." + action + ".pitch", 1.0);
    }

    public void playSound(Player player, String action) {
        String soundName = this.getSound(action);
        if (soundName != null && !soundName.isEmpty()) {
            try {
                Sound sound = Sound.valueOf((String)soundName.toUpperCase());
                player.playSound(player.getLocation(), sound, this.getSoundVolume(action), this.getSoundPitch(action));
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid sound configured for action '" + action + "': " + soundName);
            }
        }
    }

    public ItemStack getShopHead(String key) {
        Material material;
        String path = key;
        if (!this.plugin.getConfig().contains(path)) {
            this.plugin.getLogger().warning("Button configuration not found: " + key + ". Creating fallback button.");
            if (key.equals("back-button")) {
                ItemStack fallbackButton = new ItemStack(Material.RED_DYE);
                ItemMeta meta = fallbackButton.getItemMeta();
                if (meta != null) {
                    meta.setDisplayName(this.colorize("&c\u00ab Back"));
                    fallbackButton.setItemMeta(meta);
                }
                return fallbackButton;
            }
            if (key.equals("buy-button")) {
                ItemStack fallbackButton = new ItemStack(Material.LIME_DYE);
                ItemMeta meta = fallbackButton.getItemMeta();
                if (meta != null) {
                    meta.setDisplayName(this.colorize("&a\u2713 Buy"));
                    fallbackButton.setItemMeta(meta);
                }
                return fallbackButton;
            }
            if (key.equals("cancel-button")) {
                ItemStack fallbackButton = new ItemStack(Material.RED_DYE);
                ItemMeta meta = fallbackButton.getItemMeta();
                if (meta != null) {
                    meta.setDisplayName(this.colorize("&c\u2717 Cancel"));
                    fallbackButton.setItemMeta(meta);
                }
                return fallbackButton;
            }
            return new ItemStack(Material.STONE);
        }
        String name = this.plugin.getConfig().getString(path + ".name", "&7Button");
        String materialName = this.plugin.getConfig().getString(path + ".material", "STONE");
        List lore = this.plugin.getConfig().getStringList(path + ".lore");
        try {
            material = Material.valueOf((String)materialName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid material in button config: " + materialName + ". Using STONE instead.");
            material = Material.STONE;
        }
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.colorize(name));
            if (lore != null && !lore.isEmpty()) {
                meta.setLore(lore.stream().map(this::colorize).toList());
            }
            item.setItemMeta(meta);
        }
        return item;
    }
}

