/*
 * Decompiled with CFR 0.152.
 */
package me.dev.zShop.utils;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBuilder {
    private final ItemStack itemStack;
    private ItemMeta itemMeta;

    public ItemBuilder(Material material) {
        this.itemStack = new ItemStack(material);
        this.itemMeta = this.itemStack.getItemMeta();
    }

    public ItemBuilder(Material material, int amount) {
        this.itemStack = new ItemStack(material, amount);
        this.itemMeta = this.itemStack.getItemMeta();
    }

    public ItemBuilder(ItemStack itemStack) {
        this.itemStack = itemStack.clone();
        this.itemMeta = this.itemStack.hasItemMeta() ? this.itemStack.getItemMeta() : this.itemStack.getItemMeta();
    }

    public ItemBuilder setName(String name) {
        if (this.itemMeta != null) {
            this.itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
        }
        return this;
    }

    public ItemBuilder setLore(List<String> lore) {
        if (this.itemMeta != null && lore != null) {
            ArrayList<String> coloredLore = new ArrayList<String>();
            for (String line : lore) {
                coloredLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
            }
            this.itemMeta.setLore(coloredLore);
        }
        return this;
    }

    public ItemBuilder addEnchant(Enchantment enchantment, int level, boolean ignoreLevelRestriction) {
        if (this.itemMeta != null && enchantment != null) {
            this.itemMeta.addEnchant(enchantment, level, ignoreLevelRestriction);
        }
        return this;
    }

    public ItemBuilder addItemFlags(ItemFlag ... flags) {
        if (this.itemMeta != null && flags != null && flags.length > 0) {
            this.itemMeta.addItemFlags(flags);
        }
        return this;
    }

    public ItemBuilder glow() {
        if (this.itemMeta != null) {
            this.addEnchant(Enchantment.MENDING, 1, true);
            this.addItemFlags(ItemFlag.HIDE_ENCHANTS);
        }
        return this;
    }

    public ItemStack build() {
        if (this.itemMeta != null) {
            this.itemStack.setItemMeta(this.itemMeta);
        }
        return this.itemStack;
    }
}

