/*
 * Decompiled with CFR 0.152.
 */
package me.dev.zShop.utils;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import me.dev.zShop.Main;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class ItemManager {
    private final Main plugin;
    private final Map<String, ItemStack> customItems = new HashMap<String, ItemStack>();
    private final File itemsFile;
    private FileConfiguration itemsConfig;

    public ItemManager(Main plugin) {
        this.plugin = plugin;
        this.itemsFile = new File(plugin.getDataFolder(), "items.yml");
        this.setup();
        this.loadItems();
    }

    private void setup() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdir();
        }
        if (!this.itemsFile.exists()) {
            try {
                this.itemsFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Error creating items.yml: " + e.getMessage());
            }
        }
        this.itemsConfig = YamlConfiguration.loadConfiguration((File)this.itemsFile);
    }

    private void loadItems() {
        if (!this.itemsConfig.contains("items")) {
            this.itemsConfig.createSection("items");
            this.save();
            return;
        }
        for (String key : this.itemsConfig.getConfigurationSection("items").getKeys(false)) {
            try {
                ItemStack item = this.itemsConfig.getItemStack("items." + key);
                if (item == null) continue;
                this.customItems.put(key, item);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error loading item " + key + ": " + e.getMessage());
            }
        }
    }

    public void saveAll() {
        for (Map.Entry<String, ItemStack> entry : this.customItems.entrySet()) {
            this.itemsConfig.set("items." + entry.getKey(), (Object)entry.getValue());
        }
        this.save();
    }

    public void saveCustomItem(String key, ItemStack item) {
        ItemStack originalItem = item.clone();
        this.customItems.put(key, originalItem);
        this.itemsConfig.set("items." + key, (Object)originalItem);
        this.save();
        this.plugin.getLogger().info("Custom item saved with key: " + key);
    }

    public ItemStack getCustomItem(String key) {
        ItemStack item = this.customItems.get(key);
        return item != null ? item.clone() : null;
    }

    private void save() {
        try {
            this.itemsConfig.save(this.itemsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Error saving items.yml: " + e.getMessage());
        }
    }
}

