/*
 * Decompiled with CFR 0.152.
 */
package me.dev.zShop.utils;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import me.dev.zShop.Main;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class TransactionLogger {
    private final Main plugin;
    private File logFile;
    private FileConfiguration logConfig;

    public TransactionLogger(Main plugin) {
        this.plugin = plugin;
        this.setup();
    }

    private void setup() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdir();
        }
        this.logFile = new File(this.plugin.getDataFolder(), "translog.yml");
        if (!this.logFile.exists()) {
            try {
                this.logFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Error creating translog.yml: " + e.getMessage());
            }
        }
        this.logConfig = YamlConfiguration.loadConfiguration((File)this.logFile);
        if (!this.logConfig.contains("transactions")) {
            this.logConfig.createSection("transactions");
            this.save();
        }
    }

    private void save() {
        try {
            this.logConfig.save(this.logFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Error saving translog.yml: " + e.getMessage());
        }
    }

    public void logPurchase(Player player, ItemStack item, int amount, double price, String category) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = dateFormat.format(new Date());
        String transactionId = System.currentTimeMillis() + "_" + String.valueOf(player.getUniqueId());
        String path = "transactions." + transactionId + ".";
        this.logConfig.set(path + "player", (Object)player.getName());
        this.logConfig.set(path + "uuid", (Object)player.getUniqueId().toString());
        this.logConfig.set(path + "item", (Object)item.getType().name());
        this.logConfig.set(path + "amount", (Object)amount);
        this.logConfig.set(path + "price", (Object)price);
        this.logConfig.set(path + "category", (Object)category);
        this.logConfig.set(path + "timestamp", (Object)timestamp);
        if (this.plugin.getEconomy() != null) {
            this.logConfig.set(path + "balance_after", (Object)this.plugin.getEconomy().getBalance((OfflinePlayer)player));
        }
        this.save();
    }

    public List<String> getPlayerTransactions(String playerName, int limit) {
        ArrayList<String> transactions = new ArrayList<String>();
        if (this.logConfig.contains("transactions")) {
            for (String key : this.logConfig.getConfigurationSection("transactions").getKeys(false)) {
                String path = "transactions." + key + ".";
                if (!this.logConfig.getString(path + "player").equalsIgnoreCase(playerName)) continue;
                String item = this.logConfig.getString(path + "item", "Unknown");
                int amount = this.logConfig.getInt(path + "amount", 0);
                double price = this.logConfig.getDouble(path + "price", 0.0);
                String timestamp = this.logConfig.getString(path + "timestamp", "Unknown");
                String transaction = String.format("%s: %dx %s for %.2f", timestamp, amount, item, price);
                transactions.add(transaction);
                if (transactions.size() < limit) continue;
                break;
            }
        }
        return transactions;
    }

    public double getTotalRevenue() {
        double total = 0.0;
        if (this.logConfig.contains("transactions")) {
            for (String key : this.logConfig.getConfigurationSection("transactions").getKeys(false)) {
                String path = "transactions." + key + ".";
                total += this.logConfig.getDouble(path + "price", 0.0);
            }
        }
        return total;
    }
}

