/*
 * Decompiled with CFR 0.152.
 */
package de.doetchen.projects.commands;

import de.doetchen.projects.Flys;
import de.doetchen.projects.libs.kotlin.Metadata;
import de.doetchen.projects.libs.kotlin.Pair;
import de.doetchen.projects.libs.kotlin.TuplesKt;
import de.doetchen.projects.libs.kotlin.collections.CollectionsKt;
import de.doetchen.projects.libs.kotlin.jvm.internal.Intrinsics;
import de.doetchen.projects.libs.kotlin.jvm.internal.SourceDebugExtension;
import de.doetchen.projects.libs.kotlin.text.StringsKt;
import de.doetchen.projects.managers.FlightManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J5\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J%\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0013H\u0002\u00a2\u0006\u0002\u0010\u0018J%\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0013H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J;\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001c2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\b2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0013H\u0016\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lde/doetchen/projects/commands/FlysCommand;", "Lorg/bukkit/command/CommandExecutor;", "Lorg/bukkit/command/TabCompleter;", "plugin", "Lde/doetchen/projects/Flys;", "<init>", "(Lde/doetchen/projects/Flys;)V", "getPermission", "", "key", "default", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "sendUsageMessage", "", "handleAddWorld", "(Lorg/bukkit/command/CommandSender;[Ljava/lang/String;)Z", "handleRemoveWorld", "handleListWorlds", "onTabComplete", "", "alias", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "Flys"})
@SourceDebugExtension(value={"SMAP\nFlysCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlysCommand.kt\nde/doetchen/projects/commands/FlysCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n1#2:201\n1869#3,2:202\n1869#3,2:204\n1869#3,2:206\n774#3:208\n865#3,2:209\n1563#3:211\n1634#3,3:212\n774#3:215\n865#3,2:216\n774#3:218\n865#3,2:219\n*S KotlinDebug\n*F\n+ 1 FlysCommand.kt\nde/doetchen/projects/commands/FlysCommand\n*L\n99#1:202,2\n151#1:204,2\n158#1:206,2\n174#1:208\n174#1:209,2\n180#1:211\n180#1:212,3\n181#1:215\n181#1:216,2\n190#1:218\n190#1:219,2\n*E\n"})
public final class FlysCommand
implements CommandExecutor,
TabCompleter {
    @NotNull
    private final Flys plugin;

    public FlysCommand(@NotNull Flys plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    private final String getPermission(String key, String string) {
        String string2;
        String it = string2 = this.plugin.getConfigManager().getString(key);
        boolean bl = false;
        String string3 = ((CharSequence)it).length() > 0 ? string2 : null;
        if (string3 == null) {
            string3 = string;
        }
        return string3;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!sender.hasPermission(this.getPermission("permissions.admin", "flys.admin"))) {
            this.plugin.getMessageUtils().sendMessage(sender, "errors.no-permission", new Pair[0]);
            if (sender instanceof Player && this.plugin.getConfigManager().getBoolean("general.enable-sounds")) {
                ((Player)sender).playSound(((Player)sender).getLocation(), "block.note_block.bass", 1.0f, 1.0f);
            }
            return true;
        }
        if (args.length == 0) {
            this.sendUsageMessage(sender);
            return true;
        }
        String string = args[0].toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        switch (string) {
            case "addworld": {
                return this.handleAddWorld(sender, args);
            }
            case "removeworld": {
                return this.handleRemoveWorld(sender, args);
            }
            case "listworlds": {
                return this.handleListWorlds(sender);
            }
        }
        this.sendUsageMessage(sender);
        return true;
    }

    private final void sendUsageMessage(CommandSender sender) {
        this.plugin.getMessageUtils().sendMessage(sender, "world-management.usage-main", new Pair[0]);
        this.plugin.getMessageUtils().sendMessage(sender, "world-management.usage-main-line1", new Pair[0]);
        this.plugin.getMessageUtils().sendMessage(sender, "world-management.usage-main-line2", new Pair[0]);
        this.plugin.getMessageUtils().sendMessage(sender, "world-management.usage-main-line3", new Pair[0]);
    }

    private final boolean handleAddWorld(CommandSender sender, String[] args) {
        if (args.length < 3) {
            this.plugin.getMessageUtils().sendMessage(sender, "world-management.usage-add", new Pair[0]);
            return true;
        }
        String worldName = args[1];
        String string = args[2].toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String type2 = string;
        if (!Intrinsics.areEqual(type2, "allowed") && !Intrinsics.areEqual(type2, "disallowed")) {
            this.plugin.getMessageUtils().sendMessage(sender, "world-management.usage-add", new Pair[0]);
            return true;
        }
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("WORLD", worldName)};
            this.plugin.getMessageUtils().sendMessage(sender, "world-management.world-not-found", pairArray);
            return true;
        }
        List<String> allowedWorlds = CollectionsKt.toMutableList((Collection)this.plugin.getConfigManager().getStringList("worlds.allowed-worlds"));
        List<String> disabledWorlds = CollectionsKt.toMutableList((Collection)this.plugin.getConfigManager().getStringList("worlds.disabled-worlds"));
        if (Intrinsics.areEqual(type2, "allowed") && allowedWorlds.contains(worldName)) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("WORLD", worldName)};
            this.plugin.getMessageUtils().sendMessage(sender, "world-management.already-in-allowed", pairArray);
            return true;
        }
        if (Intrinsics.areEqual(type2, "disallowed") && disabledWorlds.contains(worldName)) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("WORLD", worldName)};
            this.plugin.getMessageUtils().sendMessage(sender, "world-management.already-in-disabled", pairArray);
            return true;
        }
        allowedWorlds.remove(worldName);
        disabledWorlds.remove(worldName);
        if (Intrinsics.areEqual(type2, "allowed")) {
            allowedWorlds.add(worldName);
            Pair[] pairArray = new Pair[]{TuplesKt.to("WORLD", worldName)};
            this.plugin.getMessageUtils().sendMessage(sender, "world-management.world-added-allowed", pairArray);
        } else {
            disabledWorlds.add(worldName);
            Pair[] pairArray = new Pair[]{TuplesKt.to("WORLD", worldName)};
            this.plugin.getMessageUtils().sendMessage(sender, "world-management.world-added-disallowed", pairArray);
            List list = world.getPlayers();
            Intrinsics.checkNotNullExpressionValue(list, "getPlayers(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player player = (Player)element$iv;
                boolean bl = false;
                FlightManager flightManager = this.plugin.getFlightManager();
                Intrinsics.checkNotNull(player);
                if (!flightManager.hasFlightEnabled(player)) continue;
                this.plugin.getFlightManager().disableFlight(player);
                this.plugin.getMessageUtils().sendMessage(player, "errors.world-not-allowed", new Pair[0]);
            }
        }
        this.plugin.getConfigManager().setStringList("worlds.allowed-worlds", allowedWorlds);
        this.plugin.getConfigManager().setStringList("worlds.disabled-worlds", disabledWorlds);
        this.plugin.getConfigManager().saveConfig();
        return true;
    }

    private final boolean handleRemoveWorld(CommandSender sender, String[] args) {
        if (args.length < 2) {
            this.plugin.getMessageUtils().sendMessage(sender, "world-management.usage-remove", new Pair[0]);
            return true;
        }
        String worldName = args[1];
        List<String> allowedWorlds = CollectionsKt.toMutableList((Collection)this.plugin.getConfigManager().getStringList("worlds.allowed-worlds"));
        List<String> disabledWorlds = CollectionsKt.toMutableList((Collection)this.plugin.getConfigManager().getStringList("worlds.disabled-worlds"));
        if (!allowedWorlds.contains(worldName) && !disabledWorlds.contains(worldName)) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("WORLD", worldName)};
            this.plugin.getMessageUtils().sendMessage(sender, "world-management.world-not-in-list", pairArray);
            return true;
        }
        allowedWorlds.remove(worldName);
        disabledWorlds.remove(worldName);
        this.plugin.getConfigManager().setStringList("worlds.allowed-worlds", allowedWorlds);
        this.plugin.getConfigManager().setStringList("worlds.disabled-worlds", disabledWorlds);
        this.plugin.getConfigManager().saveConfig();
        Pair[] pairArray = new Pair[]{TuplesKt.to("WORLD", worldName)};
        this.plugin.getMessageUtils().sendMessage(sender, "world-management.world-removed", pairArray);
        return true;
    }

    private final boolean handleListWorlds(CommandSender sender) {
        Pair[] pairArray;
        String world;
        Object element$iv;
        Iterator iterator2;
        boolean $i$f$forEach;
        Object $this$forEach$iv;
        List<String> allowedWorlds = this.plugin.getConfigManager().getStringList("worlds.allowed-worlds");
        List<String> disabledWorlds = this.plugin.getConfigManager().getStringList("worlds.disabled-worlds");
        this.plugin.getMessageUtils().sendMessage(sender, "world-management.list-header", new Pair[0]);
        if (allowedWorlds.isEmpty()) {
            this.plugin.getMessageUtils().sendMessage(sender, "world-management.all-worlds-allowed", new Pair[0]);
        } else {
            Pair[] pairArray2 = new Pair[]{TuplesKt.to("COUNT", String.valueOf(allowedWorlds.size()))};
            this.plugin.getMessageUtils().sendMessage(sender, "world-management.allowed-worlds", pairArray2);
            $this$forEach$iv = (Pair[])allowedWorlds;
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                world = (String)element$iv;
                boolean bl = false;
                pairArray = new Pair[]{TuplesKt.to("WORLD", world)};
                this.plugin.getMessageUtils().sendMessage(sender, "world-management.world-entry", pairArray);
            }
        }
        if (!((Collection)disabledWorlds).isEmpty()) {
            $this$forEach$iv = new Pair[]{TuplesKt.to("COUNT", String.valueOf(disabledWorlds.size()))};
            this.plugin.getMessageUtils().sendMessage(sender, "world-management.disabled-worlds", (Pair<String, String>)$this$forEach$iv);
            $this$forEach$iv = disabledWorlds;
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                world = (String)element$iv;
                boolean bl = false;
                pairArray = new Pair[]{TuplesKt.to("WORLD", world)};
                this.plugin.getMessageUtils().sendMessage(sender, "world-management.world-entry", pairArray);
            }
        }
        return true;
    }

    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(alias, "alias");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!sender.hasPermission(this.getPermission("permissions.admin", "flys.admin"))) {
            return CollectionsKt.emptyList();
        }
        return switch (args.length) {
            case 1 -> {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Object var5_5 = new String[]{"addworld", "removeworld", "listworlds"};
                var5_5 = CollectionsKt.listOf(var5_5);
                boolean $i$f$filter = false;
                void var7_11 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object var11_23 : $this$filterTo$iv$iv) {
                    String it = (String)var11_23;
                    boolean $i$a$-filter-FlysCommand$onTabComplete$1 = false;
                    String v0 = it.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(v0, "toLowerCase(...)");
                    String v1 = args[0].toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(v1, "toLowerCase(...)");
                    if (!StringsKt.startsWith$default(v0, v1, false, 2, null)) continue;
                    destination$iv$iv.add(var11_23);
                }
                yield CollectionsKt.sorted((List)destination$iv$iv);
            }
            case 2 -> {
                Object $this$filter$iv = new String[]{"addworld", "removeworld"};
                List<String> v3 = CollectionsKt.listOf($this$filter$iv);
                String v4 = args[0].toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(v4, "toLowerCase(...)");
                if (v3.contains(v4)) {
                    Object it;
                    Object $this$mapTo$iv$iv;
                    Iterable $this$map$iv;
                    List v5 = Bukkit.getWorlds();
                    Intrinsics.checkNotNullExpressionValue(v5, "getWorlds(...)");
                    $this$filter$iv = v5;
                    boolean $i$f$map = false;
                    void $this$filterTo$iv$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object var11_24 : $this$mapTo$iv$iv) {
                        it = (World)var11_24;
                        Collection var14_34 = destination$iv$iv;
                        boolean $i$a$-map-FlysCommand$onTabComplete$2 = false;
                        var14_34.add(it.getName());
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$filter = false;
                    $this$mapTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object var11_26 : $this$filterTo$iv$iv) {
                        it = (String)var11_26;
                        boolean $i$a$-filter-FlysCommand$onTabComplete$3 = false;
                        Intrinsics.checkNotNull(it);
                        String v6 = ((String)it).toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(v6, "toLowerCase(...)");
                        String v7 = args[1].toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(v7, "toLowerCase(...)");
                        if (!StringsKt.startsWith$default(v6, v7, false, 2, null)) continue;
                        destination$iv$iv.add(var11_26);
                    }
                    yield CollectionsKt.sorted((List)destination$iv$iv);
                }
                yield CollectionsKt.emptyList();
            }
            case 3 -> {
                String v8 = args[0].toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(v8, "toLowerCase(...)");
                if (Intrinsics.areEqual(v8, "addworld")) {
                    Object $this$filter$iv = new String[]{"allowed", "disallowed"};
                    $this$filter$iv = CollectionsKt.listOf($this$filter$iv);
                    boolean $i$f$filter = false;
                    Object $this$filterTo$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    Iterator var10_22 = $this$filterTo$iv$iv.iterator();
                    while (var10_22.hasNext()) {
                        Object var11_27 = var10_22.next();
                        String it = (String)var11_27;
                        boolean $i$a$-filter-FlysCommand$onTabComplete$4 = false;
                        String v9 = it.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(v9, "toLowerCase(...)");
                        String v10 = args[2].toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(v10, "toLowerCase(...)");
                        if (!StringsKt.startsWith$default(v9, v10, false, 2, null)) continue;
                        destination$iv$iv.add(var11_27);
                    }
                    yield (List)destination$iv$iv;
                }
                yield CollectionsKt.emptyList();
            }
            default -> CollectionsKt.emptyList();
        };
    }
}

