/*
 * Decompiled with CFR 0.152.
 */
package de.doetchen.projects.hooks;

import de.doetchen.projects.Flys;
import de.doetchen.projects.libs.kotlin.Metadata;
import de.doetchen.projects.libs.kotlin.jvm.internal.Intrinsics;
import de.doetchen.projects.managers.FlightManager;
import java.util.Locale;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u001c\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/doetchen/projects/hooks/PlaceholderAPIHook;", "Lme/clip/placeholderapi/expansion/PlaceholderExpansion;", "plugin", "Lde/doetchen/projects/Flys;", "<init>", "(Lde/doetchen/projects/Flys;)V", "getIdentifier", "", "getAuthor", "getVersion", "persist", "", "canRegister", "onPlaceholderRequest", "player", "Lorg/bukkit/entity/Player;", "params", "Flys"})
public final class PlaceholderAPIHook
extends PlaceholderExpansion {
    @NotNull
    private final Flys plugin;

    public PlaceholderAPIHook(@NotNull Flys plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "flys";
    }

    @NotNull
    public String getAuthor() {
        return "Doetchen";
    }

    @NotNull
    public String getVersion() {
        String string = this.plugin.getDescription().getVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getVersion(...)");
        return string;
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    @Nullable
    public String onPlaceholderRequest(@Nullable Player player, @NotNull String params) {
        Intrinsics.checkNotNullParameter(params, "params");
        if (player == null) {
            return null;
        }
        String string = params.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        return switch (string) {
            case "flying" -> {
                if (this.plugin.getFlightManager().hasFlightEnabled(player)) {
                    yield "true";
                }
                yield "false";
            }
            case "flying_status" -> {
                if (this.plugin.getFlightManager().hasFlightEnabled(player)) {
                    yield "Enabled";
                }
                yield "Disabled";
            }
            case "flying_symbol" -> {
                if (this.plugin.getFlightManager().hasFlightEnabled(player)) {
                    yield "\u2714";
                }
                yield "\u2718";
            }
            case "speed" -> {
                if (this.plugin.getFlightManager().hasFlightEnabled(player)) {
                    yield String.valueOf((int)(player.getFlySpeed() * (float)10));
                }
                yield "0";
            }
            case "speed_percent" -> {
                if (this.plugin.getFlightManager().hasFlightEnabled(player)) {
                    yield (int)(player.getFlySpeed() * (float)100) + "%";
                }
                yield "0%";
            }
            case "world_allowed" -> {
                FlightManager v2 = this.plugin.getFlightManager();
                String v3 = player.getWorld().getName();
                Intrinsics.checkNotNullExpressionValue(v3, "getName(...)");
                if (v2.isFlightAllowedInWorldPublic(v3)) {
                    yield "true";
                }
                yield "false";
            }
            case "world_status" -> {
                FlightManager v4 = this.plugin.getFlightManager();
                String v5 = player.getWorld().getName();
                Intrinsics.checkNotNullExpressionValue(v5, "getName(...)");
                if (v4.isFlightAllowedInWorldPublic(v5)) {
                    yield "Allowed";
                }
                yield "Disabled";
            }
            case "total_flying" -> String.valueOf(this.plugin.getFlightManager().getFlyingPlayers().size());
            default -> null;
        };
    }
}

