/*
 * Decompiled with CFR 0.152.
 */
package de.doetchen.projects.utils;

import de.doetchen.projects.Flys;
import de.doetchen.projects.libs.kotlin.Metadata;
import de.doetchen.projects.libs.kotlin.jvm.internal.Intrinsics;
import de.doetchen.projects.libs.kotlin.random.Random;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0019H\u0002J\u0016\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0016\u0010\"\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0016\u0010#\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lde/doetchen/projects/utils/EffectUtils;", "", "<init>", "()V", "WING_PARTICLES", "", "SPARKLE_PARTICLES", "FALLING_PARTICLES", "DRAGON_FLAP_VOLUME", "", "DRAGON_FLAP_PITCH", "ENCHANT_VOLUME", "ENCHANT_PITCH", "BAT_VOLUME", "BAT_PITCH", "FIRE_VOLUME", "FIRE_PITCH", "spawnParticle", "", "location", "Lorg/bukkit/Location;", "particle", "Lorg/bukkit/Particle;", "count", "offsetX", "", "offsetY", "offsetZ", "speed", "playFlightEnabledEffects", "player", "Lorg/bukkit/entity/Player;", "plugin", "Lde/doetchen/projects/Flys;", "playFlightDisabledEffects", "playSpeedChangeEffect", "spawnWingParticles", "spawnSparkleParticles", "spawnFallingParticles", "Flys"})
public final class EffectUtils {
    @NotNull
    public static final EffectUtils INSTANCE = new EffectUtils();
    private static final int WING_PARTICLES = 15;
    private static final int SPARKLE_PARTICLES = 10;
    private static final int FALLING_PARTICLES = 12;
    private static final float DRAGON_FLAP_VOLUME = 0.5f;
    private static final float DRAGON_FLAP_PITCH = 1.2f;
    private static final float ENCHANT_VOLUME = 0.8f;
    private static final float ENCHANT_PITCH = 1.5f;
    private static final float BAT_VOLUME = 0.6f;
    private static final float BAT_PITCH = 0.8f;
    private static final float FIRE_VOLUME = 0.4f;
    private static final float FIRE_PITCH = 1.0f;

    private EffectUtils() {
    }

    private final void spawnParticle(Location location, Particle particle, int count, double offsetX, double offsetY, double offsetZ, double speed) {
        World world;
        World world2 = world = location.getWorld();
        if (world2 == null) {
            return;
        }
        World world3 = world2;
        try {
            world3.spawnParticle(particle, location, count, offsetX, offsetY, offsetZ, speed);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void playFlightEnabledEffects(@NotNull Player player, @NotNull Flys plugin) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location location2 = location;
        if (plugin.getConfigManager().getBoolean("general.enable-particles")) {
            this.spawnWingParticles(location2);
            this.spawnSparkleParticles(location2);
        }
        if (plugin.getConfigManager().getBoolean("general.enable-sounds")) {
            player.playSound(location2, Sound.ENTITY_ENDER_DRAGON_FLAP, 0.5f, 1.2f);
            player.playSound(location2, Sound.BLOCK_ENCHANTMENT_TABLE_USE, 0.8f, 1.5f);
        }
    }

    public final void playFlightDisabledEffects(@NotNull Player player, @NotNull Flys plugin) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location location2 = location;
        if (plugin.getConfigManager().getBoolean("general.enable-particles")) {
            this.spawnFallingParticles(location2);
        }
        if (plugin.getConfigManager().getBoolean("general.enable-sounds")) {
            player.playSound(location2, Sound.ENTITY_BAT_TAKEOFF, 0.6f, 0.8f);
            player.playSound(location2, Sound.BLOCK_FIRE_EXTINGUISH, 0.4f, 1.0f);
        }
    }

    public final void playSpeedChangeEffect(@NotNull Player player, @NotNull Flys plugin) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location location2 = location;
        if (plugin.getConfigManager().getBoolean("general.enable-particles")) {
            int n = 8;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                double angle = (double)it * 45.0 * Math.PI / 180.0;
                double radius = 1.5;
                double x = location2.getX() + Math.cos(angle) * radius;
                double y = location2.getY() + 1.0;
                double z = location2.getZ() + Math.sin(angle) * radius;
                Location particleLocation = new Location(location2.getWorld(), x, y, z);
                INSTANCE.spawnParticle(particleLocation, Particle.ENCHANT, 3, 0.1, 0.1, 0.1, 0.0);
            }
        }
        if (plugin.getConfigManager().getBoolean("general.enable-sounds")) {
            player.playSound(location2, Sound.BLOCK_NOTE_BLOCK_CHIME, 0.7f, 1.3f);
        }
    }

    private final void spawnWingParticles(Location location) {
        int n = 15;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            double angle = Random.Default.nextDouble(0.0, Math.PI * 2);
            double radius = Random.Default.nextDouble(0.5, 2.0);
            double height = Random.Default.nextDouble(-0.5, 1.5);
            double x = location.getX() + Math.cos(angle) * radius;
            double y = location.getY() + height;
            double z = location.getZ() + Math.sin(angle) * radius;
            Location particleLocation = new Location(location.getWorld(), x, y, z);
            INSTANCE.spawnParticle(particleLocation, Particle.CLOUD, 1, 0.1, 0.1, 0.1, 0.02);
            INSTANCE.spawnParticle(particleLocation, Particle.FIREWORK, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private final void spawnSparkleParticles(Location location) {
        int n = 10;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            double x = location.getX() + Random.Default.nextDouble(-1.5, 1.5);
            double y = location.getY() + Random.Default.nextDouble(0.0, 2.0);
            double z = location.getZ() + Random.Default.nextDouble(-1.5, 1.5);
            Location particleLocation = new Location(location.getWorld(), x, y, z);
            INSTANCE.spawnParticle(particleLocation, Particle.ENCHANT, 2, 0.2, 0.2, 0.2, 0.0);
            INSTANCE.spawnParticle(particleLocation, Particle.CRIT, 3, 0.3, 0.3, 0.3, 0.5);
        }
    }

    private final void spawnFallingParticles(Location location) {
        int n = 12;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            double x = location.getX() + Random.Default.nextDouble(-1.0, 1.0);
            double y = location.getY() + Random.Default.nextDouble(1.0, 2.5);
            double z = location.getZ() + Random.Default.nextDouble(-1.0, 1.0);
            Location particleLocation = new Location(location.getWorld(), x, y, z);
            INSTANCE.spawnParticle(particleLocation, Particle.SMOKE, 2, 0.1, 0.1, 0.1, 0.02);
            INSTANCE.spawnParticle(particleLocation, Particle.CLOUD, 1, 0.2, 0.2, 0.2, 0.0);
        }
    }
}

