/*
 * Decompiled with CFR 0.152.
 */
package de.doetchen.projects.managers;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.doetchen.projects.Flys;
import de.doetchen.projects.libs.kotlin.Metadata;
import de.doetchen.projects.libs.kotlin.Pair;
import de.doetchen.projects.libs.kotlin.TuplesKt;
import de.doetchen.projects.libs.kotlin.collections.MapsKt;
import de.doetchen.projects.libs.kotlin.jvm.functions.Function0;
import de.doetchen.projects.libs.kotlin.jvm.internal.Intrinsics;
import de.doetchen.projects.libs.kotlin.jvm.internal.SourceDebugExtension;
import de.doetchen.projects.libs.kotlin.reflect.KFunction;
import de.doetchen.projects.libs.kotlin.text.StringsKt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0002J$\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u000bH\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0002J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u000bH\u0002J\u0014\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u000bH\u0002J\u0014\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u000bH\u0002J\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u000bH\u0002J\u0014\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u000bH\u0002J\u0014\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u000bH\u0002J\u0006\u0010\u001b\u001a\u00020\u000fJ?\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\f2*\u0010\u001e\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0 0\u001f\"\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0 \u00a2\u0006\u0002\u0010!J\u0012\u0010\"\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001d\u001a\u00020\fH\u0002J\u000e\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\fJ\u000e\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\fJ\u0018\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\f2\b\b\u0002\u0010'\u001a\u00020&J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\f0)2\u0006\u0010\u001d\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lde/doetchen/projects/managers/ConfigManager;", "", "plugin", "Lde/doetchen/projects/Flys;", "<init>", "(Lde/doetchen/projects/Flys;)V", "config", "Lorg/bukkit/configuration/file/FileConfiguration;", "configFile", "Ljava/io/File;", "messages", "", "", "currentLanguage", "initialize", "", "loadConfigWithUTF8", "ensureAllLanguageFilesExist", "createMessagesFile", "file", "loadLanguageMessages", "getEnglishMessages", "getGermanMessages", "getSpanishMessages", "getFrenchMessages", "getRussianMessages", "getPolishMessages", "reloadConfig", "getString", "path", "placeholders", "", "Lde/doetchen/projects/libs/kotlin/Pair;", "(Ljava/lang/String;[Lde/doetchen/projects/libs/kotlin/Pair;)Ljava/lang/String;", "getMessageFromPath", "getBoolean", "", "getDouble", "", "defaultValue", "getStringList", "", "Flys"})
@SourceDebugExtension(value={"SMAP\nConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigManager.kt\nde/doetchen/projects/managers/ConfigManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,389:1\n216#2,2:390\n13805#3,2:392\n*S KotlinDebug\n*F\n+ 1 ConfigManager.kt\nde/doetchen/projects/managers/ConfigManager\n*L\n64#1:390,2\n358#1:392,2\n*E\n"})
public final class ConfigManager {
    @NotNull
    private final Flys plugin;
    private FileConfiguration config;
    private File configFile;
    private Map<String, ? extends Object> messages;
    @NotNull
    private String currentLanguage;

    public ConfigManager(@NotNull Flys plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.currentLanguage = "en";
    }

    public final void initialize() {
        this.configFile = new File(this.plugin.getDataFolder(), "config.yml");
        File file = this.configFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException("configFile");
            file = null;
        }
        if (!file.exists()) {
            this.plugin.saveDefaultConfig();
        }
        this.loadConfigWithUTF8();
        this.ensureAllLanguageFilesExist();
        this.loadLanguageMessages();
        this.plugin.getLogger().info("Config loaded!");
    }

    private final void loadConfigWithUTF8() {
        try {
            File file = this.configFile;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException("configFile");
                file = null;
            }
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)reader);
            Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
            this.config = (FileConfiguration)yamlConfiguration;
            reader.close();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to load config with UTF-8: " + e.getMessage());
            FileConfiguration fileConfiguration = this.plugin.getConfig();
            Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
            this.config = fileConfiguration;
        }
    }

    private final void ensureAllLanguageFilesExist() {
        Map languages2;
        File messagesDir = new File(this.plugin.getDataFolder(), "messages");
        if (!messagesDir.exists()) {
            messagesDir.mkdirs();
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to("en", TuplesKt.to("English", new Function0<Map<String, ? extends Object>>((Object)this){

            public final Map<String, Object> invoke() {
                return ConfigManager.access$getEnglishMessages((ConfigManager)this.receiver);
            }
        })), TuplesKt.to("de", TuplesKt.to("German", new Function0<Map<String, ? extends Object>>((Object)this){

            public final Map<String, Object> invoke() {
                return ConfigManager.access$getGermanMessages((ConfigManager)this.receiver);
            }
        })), TuplesKt.to("es", TuplesKt.to("Spanish", new Function0<Map<String, ? extends Object>>((Object)this){

            public final Map<String, Object> invoke() {
                return ConfigManager.access$getSpanishMessages((ConfigManager)this.receiver);
            }
        })), TuplesKt.to("fr", TuplesKt.to("French", new Function0<Map<String, ? extends Object>>((Object)this){

            public final Map<String, Object> invoke() {
                return ConfigManager.access$getFrenchMessages((ConfigManager)this.receiver);
            }
        })), TuplesKt.to("ru", TuplesKt.to("Russian", new Function0<Map<String, ? extends Object>>((Object)this){

            public final Map<String, Object> invoke() {
                return ConfigManager.access$getRussianMessages((ConfigManager)this.receiver);
            }
        })), TuplesKt.to("pl", TuplesKt.to("Polish", new Function0<Map<String, ? extends Object>>((Object)this){

            public final Map<String, Object> invoke() {
                return ConfigManager.access$getPolishMessages((ConfigManager)this.receiver);
            }
        }))};
        Map $this$forEach$iv = languages2 = MapsKt.mapOf(pairArray);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            String code = (String)entry.getKey();
            Pair pair = (Pair)entry.getValue();
            String name = (String)pair.component1();
            KFunction messageGetter = (KFunction)pair.component2();
            File file = new File(messagesDir, "messages_" + code + ".json");
            if (file.exists()) continue;
            this.plugin.getLogger().info("Creating " + name + " messages file...");
            this.createMessagesFile(file, (Map)((Function0)((Object)messageGetter)).invoke());
        }
    }

    private final void createMessagesFile(File file, Map<String, ? extends Object> messages) {
        try {
            Gson gson = new Gson().newBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            String json = gson.toJson(messages);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
            writer.write(json);
            writer.close();
            this.plugin.getLogger().info("Created messages file: " + file.getName());
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to create messages file " + file.getName() + ": " + e.getMessage());
        }
    }

    private final void loadLanguageMessages() {
        String string;
        FileConfiguration fileConfiguration = this.config;
        if (fileConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException("config");
            fileConfiguration = null;
        }
        if ((string = fileConfiguration.getString("language.language", "en")) == null) {
            string = "en";
        }
        this.currentLanguage = string;
        File messagesDir = new File(this.plugin.getDataFolder(), "messages");
        File messagesFile = new File(messagesDir, "messages_" + this.currentLanguage + ".json");
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(messagesFile), StandardCharsets.UTF_8);
            Gson gson = new Gson();
            Type type2 = new TypeToken<Map<String, ? extends Object>>(){}.getType();
            Object t = gson.fromJson((Reader)reader, type2);
            Intrinsics.checkNotNullExpressionValue(t, "fromJson(...)");
            this.messages = (Map)t;
            reader.close();
            this.plugin.getLogger().info("Language messages loaded: " + this.currentLanguage);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to load language messages: " + e.getMessage());
            this.plugin.getLogger().info("Using fallback messages...");
            this.messages = switch (this.currentLanguage) {
                case "de" -> this.getGermanMessages();
                case "ru" -> this.getRussianMessages();
                case "pl" -> this.getPolishMessages();
                case "es" -> this.getSpanishMessages();
                case "fr" -> this.getFrenchMessages();
                default -> this.getEnglishMessages();
            };
        }
    }

    private final Map<String, Object> getEnglishMessages() {
        Pair[] pairArray = new Pair[4];
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("enabled-self", "&a&l\u2714 Flight enabled"), TuplesKt.to("disabled-self", "&c&l\u2718 Flight disabled"), TuplesKt.to("enabled-other", "&a&l\u2714 &aFlight enabled for &e{PLAYER}&a!"), TuplesKt.to("disabled-other", "&c&l\u2718 &cFlight disabled for &e{PLAYER}&4!"), TuplesKt.to("enabled-by-other", "&b&lFlight was enabled by &e{SENDER}"), TuplesKt.to("disabled-by-other", "&e&lFlight was disabled by &e{SENDER}")};
        pairArray[0] = TuplesKt.to("flight", MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to("player-only", "&c\u2718 Only players can use this command!"), TuplesKt.to("no-permission", "&c\u2718 You don't have permission for this command!"), TuplesKt.to("player-not-found", "&c\u2718 Player &e{PLAYER} &cwas not found!"), TuplesKt.to("usage", "&e&l\u2139 &eUsage: &f/fly [player]"), TuplesKt.to("world-not-allowed", "&c\u2718 Flying is not allowed in this world!")};
        pairArray[1] = TuplesKt.to("errors", MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to("current", "&e&l\u2139 &eCurrent flight speed: &b{SPEED}&e/10"), TuplesKt.to("set", "&a&l+ &aFlight speed set to &b{SPEED}&a/10!"), TuplesKt.to("set-other", "&a&l+ &aFlight speed for &e{PLAYER} &aset to &b{SPEED}&a/10!"), TuplesKt.to("set-by-other", "&e&l\u2139 &eYour flight speed was set to &b{SPEED}&e/10 by &b{SENDER}&e!"), TuplesKt.to("invalid-range", "&c\u2718 Invalid speed! Use values from 1-10."), TuplesKt.to("flight-not-enabled", "&c\u2718 You must enable flight first!"), TuplesKt.to("target-flight-not-enabled", "&c\u2718 Player &e{PLAYER} &cdoesn't have flight enabled!"), TuplesKt.to("usage", "&e&l\u2139 &eUsage: &f/flyspeed [1-10] &eor &f/flyspeed [player] [1-10]")};
        pairArray[2] = TuplesKt.to("flyspeed", MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to("success", "&a&l+ &aConfiguration successfully reloaded!"), TuplesKt.to("error", "&c\u2718 Error while reloading configuration!")};
        pairArray[3] = TuplesKt.to("reload", MapsKt.mapOf(pairArray2));
        return MapsKt.mapOf(pairArray);
    }

    private final Map<String, Object> getGermanMessages() {
        Pair[] pairArray = new Pair[4];
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("enabled-self", "&a&l\u2714 Fliegen aktiviert"), TuplesKt.to("disabled-self", "&c&l\u2718 Fliegen deaktiviert"), TuplesKt.to("enabled-other", "&a&l\u2714 &aFliegen f\u00fcr &e{PLAYER} &aaktiviert!"), TuplesKt.to("disabled-other", "&c&l\u2718 &cFliegen f\u00fcr &e{PLAYER} &4deaktiviert!"), TuplesKt.to("enabled-by-other", "&b&lFliegen wurde von &e{SENDER} &b&laktiviert"), TuplesKt.to("disabled-by-other", "&e&lFliegen wurde von &e{SENDER} &e&ldeaktiviert")};
        pairArray[0] = TuplesKt.to("flight", MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to("player-only", "&c\u2718 Nur Spieler k\u00f6nnen diesen Befehl verwenden!"), TuplesKt.to("no-permission", "&c\u2718 Du hast keine Berechtigung f\u00fcr diesen Befehl!"), TuplesKt.to("player-not-found", "&c\u2718 Spieler &e{PLAYER} &cwurde nicht gefunden!"), TuplesKt.to("usage", "&e&l\u2139 &eVerwendung: &f/fly [spieler]"), TuplesKt.to("world-not-allowed", "&c\u2718 Fliegen ist in dieser Welt nicht erlaubt!")};
        pairArray[1] = TuplesKt.to("errors", MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to("current", "&e&l\u2139 &eAktuelle Fluggeschwindigkeit: &b{SPEED}&e/10"), TuplesKt.to("set", "&a&l+ &aFluggeschwindigkeit auf &b{SPEED}&a/10 gesetzt!"), TuplesKt.to("set-other", "&a&l+ &aFluggeschwindigkeit f\u00fcr &e{PLAYER} &aauf &b{SPEED}&a/10 gesetzt!"), TuplesKt.to("set-by-other", "&e&l\u2139 &eDeine Fluggeschwindigkeit wurde von &b{SENDER} &eauf &b{SPEED}&e/10 gesetzt!"), TuplesKt.to("invalid-range", "&c\u2718 Ung\u00fcltige Geschwindigkeit! Verwende Werte von 1-10."), TuplesKt.to("flight-not-enabled", "&c\u2718 Du musst zuerst das Fliegen aktivieren!"), TuplesKt.to("target-flight-not-enabled", "&c\u2718 Spieler &e{PLAYER} &chat das Fliegen nicht aktiviert!"), TuplesKt.to("usage", "&e&l\u2139 &eVerwendung: &f/flyspeed [1-10] &eoder &f/flyspeed [spieler] [1-10]")};
        pairArray[2] = TuplesKt.to("flyspeed", MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to("success", "&a&l+ &aKonfiguration erfolgreich neu geladen!"), TuplesKt.to("error", "&c\u2718 Fehler beim Neuladen der Konfiguration!")};
        pairArray[3] = TuplesKt.to("reload", MapsKt.mapOf(pairArray2));
        return MapsKt.mapOf(pairArray);
    }

    private final Map<String, Object> getSpanishMessages() {
        Pair[] pairArray = new Pair[4];
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("enabled-self", "&a&l\u2714 Vuelo activado"), TuplesKt.to("disabled-self", "&c&l\u2718 Vuelo desactivado"), TuplesKt.to("enabled-other", "&a&l\u2714 &a\u00a1Vuelo activado para &e{PLAYER}&a!"), TuplesKt.to("disabled-other", "&c&l\u2718 &c\u00a1Vuelo desactivado para &e{PLAYER}&4!"), TuplesKt.to("enabled-by-other", "&b&lEl vuelo fue activado por &e{SENDER}"), TuplesKt.to("disabled-by-other", "&e&lEl vuelo fue desactivado por &e{SENDER}")};
        pairArray[0] = TuplesKt.to("flight", MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to("player-only", "&c\u2718 \u00a1Solo los jugadores pueden usar este comando!"), TuplesKt.to("no-permission", "&c\u2718 \u00a1No tienes permiso para este comando!"), TuplesKt.to("player-not-found", "&c\u2718 \u00a1Jugador &e{PLAYER} &cno encontrado!"), TuplesKt.to("usage", "&e&l\u2139 &eUso: &f/fly [jugador]"), TuplesKt.to("world-not-allowed", "&c\u2718 \u00a1No est\u00e1 permitido volar en este mundo!")};
        pairArray[1] = TuplesKt.to("errors", MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to("current", "&e&l\u2139 &eVelocidad de vuelo actual: &b{SPEED}&e/10"), TuplesKt.to("set", "&a&l+ &a\u00a1Velocidad de vuelo establecida en &b{SPEED}&a/10!"), TuplesKt.to("set-other", "&a&l+ &a\u00a1Velocidad de vuelo para &e{PLAYER} &aestablecida en &b{SPEED}&a/10!"), TuplesKt.to("set-by-other", "&e&l\u2139 &e\u00a1Tu velocidad de vuelo fue establecida en &b{SPEED}&e/10 por &b{SENDER}&e!"), TuplesKt.to("invalid-range", "&c\u2718 \u00a1Velocidad inv\u00e1lida! Usa valores de 1-10."), TuplesKt.to("flight-not-enabled", "&c\u2718 \u00a1Primero debes activar el vuelo!"), TuplesKt.to("target-flight-not-enabled", "&c\u2718 \u00a1El jugador &e{PLAYER} &cno tiene el vuelo activado!"), TuplesKt.to("usage", "&e&l\u2139 &eUso: &f/flyspeed [1-10] &eo &f/flyspeed [jugador] [1-10]")};
        pairArray[2] = TuplesKt.to("flyspeed", MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to("success", "&a&l+ &a\u00a1Configuraci\u00f3n recargada exitosamente!"), TuplesKt.to("error", "&c\u2718 \u00a1Error al recargar la configuraci\u00f3n!")};
        pairArray[3] = TuplesKt.to("reload", MapsKt.mapOf(pairArray2));
        return MapsKt.mapOf(pairArray);
    }

    private final Map<String, Object> getFrenchMessages() {
        Pair[] pairArray = new Pair[4];
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("enabled-self", "&a&l\u2714 Vol activ\u00e9"), TuplesKt.to("disabled-self", "&c&l\u2718 Vol d\u00e9sactiv\u00e9"), TuplesKt.to("enabled-other", "&a&l\u2714 &aVol activ\u00e9 pour &e{PLAYER}&a !"), TuplesKt.to("disabled-other", "&c&l\u2718 &cVol d\u00e9sactiv\u00e9 pour &e{PLAYER}&4 !"), TuplesKt.to("enabled-by-other", "&b&lLe vol a \u00e9t\u00e9 activ\u00e9 par &e{SENDER}"), TuplesKt.to("disabled-by-other", "&e&lLe vol a \u00e9t\u00e9 d\u00e9sactiv\u00e9 par &e{SENDER}")};
        pairArray[0] = TuplesKt.to("flight", MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to("player-only", "&c\u2718 Seuls les joueurs peuvent utiliser cette commande !"), TuplesKt.to("no-permission", "&c\u2718 Vous n'avez pas la permission pour cette commande !"), TuplesKt.to("player-not-found", "&c\u2718 Joueur &e{PLAYER} &cintrouvable !"), TuplesKt.to("usage", "&e&l\u2139 &eUtilisation : &f/fly [joueur]"), TuplesKt.to("world-not-allowed", "&c\u2718 Le vol n'est pas autoris\u00e9 dans ce monde !")};
        pairArray[1] = TuplesKt.to("errors", MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to("current", "&e&l\u2139 &eVitesse de vol actuelle : &b{SPEED}&e/10"), TuplesKt.to("set", "&a&l+ &aVitesse de vol d\u00e9finie \u00e0 &b{SPEED}&a/10 !"), TuplesKt.to("set-other", "&a&l+ &aVitesse de vol pour &e{PLAYER} &ad\u00e9finie \u00e0 &b{SPEED}&a/10 !"), TuplesKt.to("set-by-other", "&e&l\u2139 &eVotre vitesse de vol a \u00e9t\u00e9 d\u00e9finie \u00e0 &b{SPEED}&e/10 par &b{SENDER}&e !"), TuplesKt.to("invalid-range", "&c\u2718 Vitesse invalide ! Utilisez des valeurs de 1 \u00e0 10."), TuplesKt.to("flight-not-enabled", "&c\u2718 Vous devez d'abord activer le vol !"), TuplesKt.to("target-flight-not-enabled", "&c\u2718 Le joueur &e{PLAYER} &cn'a pas le vol activ\u00e9 !"), TuplesKt.to("usage", "&e&l\u2139 &eUtilisation : &f/flyspeed [1-10] &eou &f/flyspeed [joueur] [1-10]")};
        pairArray[2] = TuplesKt.to("flyspeed", MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to("success", "&a&l+ &aConfiguration recharg\u00e9e avec succ\u00e8s !"), TuplesKt.to("error", "&c\u2718 Erreur lors du rechargement de la configuration !")};
        pairArray[3] = TuplesKt.to("reload", MapsKt.mapOf(pairArray2));
        return MapsKt.mapOf(pairArray);
    }

    private final Map<String, Object> getRussianMessages() {
        Pair[] pairArray = new Pair[4];
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("enabled-self", "&a&l\u2714 \u041f\u043e\u043b\u0451\u0442 \u0432\u043a\u043b\u044e\u0447\u0435\u043d"), TuplesKt.to("disabled-self", "&c&l\u2718 \u041f\u043e\u043b\u0451\u0442 \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d"), TuplesKt.to("enabled-other", "&a&l\u2714 &a\u041f\u043e\u043b\u0451\u0442 \u0432\u043a\u043b\u044e\u0447\u0435\u043d \u0434\u043b\u044f &e{PLAYER}&a!"), TuplesKt.to("disabled-other", "&c&l\u2718 &c\u041f\u043e\u043b\u0451\u0442 \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d \u0434\u043b\u044f &e{PLAYER}&4!"), TuplesKt.to("enabled-by-other", "&b&l\u041f\u043e\u043b\u0451\u0442 \u0431\u044b\u043b \u0432\u043a\u043b\u044e\u0447\u0435\u043d \u0438\u0433\u0440\u043e\u043a\u043e\u043c &e{SENDER}"), TuplesKt.to("disabled-by-other", "&e&l\u041f\u043e\u043b\u0451\u0442 \u0431\u044b\u043b \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d \u0438\u0433\u0440\u043e\u043a\u043e\u043c &e{SENDER}")};
        pairArray[0] = TuplesKt.to("flight", MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to("player-only", "&c\u2718 \u0422\u043e\u043b\u044c\u043a\u043e \u0438\u0433\u0440\u043e\u043a\u0438 \u043c\u043e\u0433\u0443\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u044d\u0442\u0443 \u043a\u043e\u043c\u0430\u043d\u0434\u0443!"), TuplesKt.to("no-permission", "&c\u2718 \u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u044d\u0442\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b!"), TuplesKt.to("player-not-found", "&c\u2718 \u0418\u0433\u0440\u043e\u043a &e{PLAYER} &c\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!"), TuplesKt.to("usage", "&e&l\u2139 &e\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: &f/fly [\u0438\u0433\u0440\u043e\u043a]"), TuplesKt.to("world-not-allowed", "&c\u2718 \u041f\u043e\u043b\u0451\u0442 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d \u0432 \u044d\u0442\u043e\u043c \u043c\u0438\u0440\u0435!")};
        pairArray[1] = TuplesKt.to("errors", MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to("current", "&e&l\u2139 &e\u0422\u0435\u043a\u0443\u0449\u0430\u044f \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u043f\u043e\u043b\u0451\u0442\u0430: &b{SPEED}&e/10"), TuplesKt.to("set", "&a&l+ &a\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u043f\u043e\u043b\u0451\u0442\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u043d\u0430 &b{SPEED}&a/10!"), TuplesKt.to("set-other", "&a&l+ &a\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u043f\u043e\u043b\u0451\u0442\u0430 \u0434\u043b\u044f &e{PLAYER} &a\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u043d\u0430 &b{SPEED}&a/10!"), TuplesKt.to("set-by-other", "&e&l\u2139 &e\u0412\u0430\u0448\u0430 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u043f\u043e\u043b\u0451\u0442\u0430 \u0431\u044b\u043b\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u043d\u0430 &b{SPEED}&e/10 \u0438\u0433\u0440\u043e\u043a\u043e\u043c &b{SENDER}&e!"), TuplesKt.to("invalid-range", "&c\u2718 \u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u044c! \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043e\u0442 1 \u0434\u043e 10."), TuplesKt.to("flight-not-enabled", "&c\u2718 \u0421\u043d\u0430\u0447\u0430\u043b\u0430 \u043d\u0443\u0436\u043d\u043e \u0432\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043f\u043e\u043b\u0451\u0442!"), TuplesKt.to("target-flight-not-enabled", "&c\u2718 \u0423 \u0438\u0433\u0440\u043e\u043a\u0430 &e{PLAYER} &c\u043f\u043e\u043b\u0451\u0442 \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d!"), TuplesKt.to("usage", "&e&l\u2139 &e\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: &f/flyspeed [1-10] &e\u0438\u043b\u0438 &f/flyspeed [\u0438\u0433\u0440\u043e\u043a] [1-10]")};
        pairArray[2] = TuplesKt.to("flyspeed", MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to("success", "&a&l+ &a\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430!"), TuplesKt.to("error", "&c\u2718 \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438!")};
        pairArray[3] = TuplesKt.to("reload", MapsKt.mapOf(pairArray2));
        return MapsKt.mapOf(pairArray);
    }

    private final Map<String, Object> getPolishMessages() {
        Pair[] pairArray = new Pair[4];
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("enabled-self", "&a&l\u2714 Latanie w\u0142\u0105czone"), TuplesKt.to("disabled-self", "&c&l\u2718 Latanie wy\u0142\u0105czone"), TuplesKt.to("enabled-other", "&a&l\u2714 &aLatanie w\u0142\u0105czone dla &e{PLAYER}&a!"), TuplesKt.to("disabled-other", "&c&l\u2718 &cLatanie wy\u0142\u0105czone dla &e{PLAYER}&4!"), TuplesKt.to("enabled-by-other", "&b&lLatanie zosta\u0142o w\u0142\u0105czone przez &e{SENDER}"), TuplesKt.to("disabled-by-other", "&e&lLatanie zosta\u0142o wy\u0142\u0105czone przez &e{SENDER}")};
        pairArray[0] = TuplesKt.to("flight", MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to("player-only", "&c\u2718 Tylko gracze mog\u0105 u\u017cywa\u0107 tej komendy!"), TuplesKt.to("no-permission", "&c\u2718 Nie masz uprawnie\u0144 do tej komendy!"), TuplesKt.to("player-not-found", "&c\u2718 Gracz &e{PLAYER} &cnie zosta\u0142 znaleziony!"), TuplesKt.to("usage", "&e&l\u2139 &eU\u017cycie: &f/fly [gracz]"), TuplesKt.to("world-not-allowed", "&c\u2718 Latanie nie jest dozwolone w tym \u015bwiecie!")};
        pairArray[1] = TuplesKt.to("errors", MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to("current", "&e&l\u2139 &eObecna pr\u0119dko\u015b\u0107 lotu: &b{SPEED}&e/10"), TuplesKt.to("set", "&a&l+ &aPr\u0119dko\u015b\u0107 lotu ustawiona na &b{SPEED}&a/10!"), TuplesKt.to("set-other", "&a&l+ &aPr\u0119dko\u015b\u0107 lotu dla &e{PLAYER} &austawiona na &b{SPEED}&a/10!"), TuplesKt.to("set-by-other", "&e&l\u2139 &eTwoja pr\u0119dko\u015b\u0107 lotu zosta\u0142a ustawiona na &b{SPEED}&e/10 przez &b{SENDER}&e!"), TuplesKt.to("invalid-range", "&c\u2718 Nieprawid\u0142owa pr\u0119dko\u015b\u0107! U\u017cyj warto\u015bci od 1 do 10."), TuplesKt.to("flight-not-enabled", "&c\u2718 Najpierw musisz w\u0142\u0105czy\u0107 latanie!"), TuplesKt.to("target-flight-not-enabled", "&c\u2718 Gracz &e{PLAYER} &cnie ma w\u0142\u0105czonego latania!"), TuplesKt.to("usage", "&e&l\u2139 &eU\u017cycie: &f/flyspeed [1-10] &elub &f/flyspeed [gracz] [1-10]")};
        pairArray[2] = TuplesKt.to("flyspeed", MapsKt.mapOf(pairArray2));
        pairArray2 = new Pair[]{TuplesKt.to("success", "&a&l+ &aKonfiguracja pomy\u015blnie prze\u0142adowana!"), TuplesKt.to("error", "&c\u2718 B\u0142\u0105d podczas prze\u0142adowania konfiguracji!")};
        pairArray[3] = TuplesKt.to("reload", MapsKt.mapOf(pairArray2));
        return MapsKt.mapOf(pairArray);
    }

    public final void reloadConfig() {
        this.loadConfigWithUTF8();
        this.ensureAllLanguageFilesExist();
        this.loadLanguageMessages();
        this.plugin.getLogger().info("Config reloaded!");
    }

    @NotNull
    public final String getString(@NotNull String path, Pair<String, String> ... placeholders) {
        Object object;
        Object object2;
        block33: {
            Intrinsics.checkNotNullParameter(path, "path");
            Intrinsics.checkNotNullParameter(placeholders, "placeholders");
            object2 = this.getMessageFromPath(path);
            if (object2 != null) break block33;
            ConfigManager $this$getString_u24lambda_u240 = this;
            boolean bl = false;
            $this$getString_u24lambda_u240.plugin.getLogger().warning("Message path '" + path + "' not found!");
            switch (path) {
                case "flight.enabled-self": {
                    object2 = "&a&l\u2714 Flight enabled";
                    break;
                }
                case "flight.disabled-self": {
                    object2 = "&c&l\u2718 Flight disabled";
                    break;
                }
                case "flight.enabled-by-other": {
                    object2 = "&b&lFlight was enabled by &e{SENDER}";
                    break;
                }
                case "flight.disabled-by-other": {
                    object2 = "&e&lFlight was disabled by &e{SENDER}";
                    break;
                }
                case "errors.player-only": {
                    object2 = "&cOnly players can use this command!";
                    break;
                }
                case "errors.no-permission": {
                    object2 = "&cYou don't have permission for this command!";
                    break;
                }
                case "errors.player-not-found": {
                    object2 = "&cPlayer {PLAYER} was not found!";
                    break;
                }
                case "errors.usage": {
                    object2 = "&eUsage: /fly [player]";
                    break;
                }
                default: {
                    object2 = "&cMessage Error: " + path;
                }
            }
        }
        String message = object2;
        boolean needsPrefix = !StringsKt.startsWith$default(path, "flight.enabled-self", false, 2, null) && !StringsKt.startsWith$default(path, "flight.disabled-self", false, 2, null) && !StringsKt.startsWith$default(path, "flight.enabled-by-other", false, 2, null) && !StringsKt.startsWith$default(path, "flight.disabled-by-other", false, 2, null);
        String finalMessage = null;
        if (needsPrefix) {
            String string;
            FileConfiguration fileConfiguration = this.config;
            if (fileConfiguration == null) {
                Intrinsics.throwUninitializedPropertyAccessException("config");
                fileConfiguration = null;
            }
            if ((string = fileConfiguration.getString("messages.prefix")) == null) {
                string = "&8[&b&lFlys&8] ";
            }
            String prefix = string;
            object = prefix + message;
        } else {
            object = message;
        }
        finalMessage = object;
        Pair<String, String>[] $this$forEach$iv = placeholders;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Pair<String, String> element$iv;
            Pair<String, String> pair = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            String placeholder = pair.component1();
            String value = pair.component2();
            finalMessage = StringsKt.replace$default(finalMessage, "{" + placeholder + "}", value, false, 4, null);
        }
        return finalMessage;
    }

    private final String getMessageFromPath(String path) {
        String[] stringArray = new String[]{"."};
        List parts = StringsKt.split$default((CharSequence)path, stringArray, false, 0, 6, null);
        Map<String, ? extends Object> map = this.messages;
        if (map == null) {
            Intrinsics.throwUninitializedPropertyAccessException("messages");
            map = null;
        }
        Map<String, ? extends Object> current = map;
        Object object = parts.iterator();
        while (object.hasNext()) {
            String part = (String)object.next();
            if ((current = current instanceof Map ? current.get(part) : null) != null) continue;
        }
        return (object = current) instanceof String ? (String)object : null;
    }

    @NotNull
    public final String getString(@NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter(path, "path");
        FileConfiguration fileConfiguration = this.config;
        if (fileConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException("config");
            fileConfiguration = null;
        }
        if ((string = fileConfiguration.getString(path)) == null) {
            string = "";
        }
        return string;
    }

    public final boolean getBoolean(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        FileConfiguration fileConfiguration = this.config;
        if (fileConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException("config");
            fileConfiguration = null;
        }
        return fileConfiguration.getBoolean(path);
    }

    public final double getDouble(@NotNull String path, double defaultValue) {
        Intrinsics.checkNotNullParameter(path, "path");
        FileConfiguration fileConfiguration = this.config;
        if (fileConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException("config");
            fileConfiguration = null;
        }
        return fileConfiguration.getDouble(path, defaultValue);
    }

    public static /* synthetic */ double getDouble$default(ConfigManager configManager, String string, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        return configManager.getDouble(string, d);
    }

    @NotNull
    public final List<String> getStringList(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        FileConfiguration fileConfiguration = this.config;
        if (fileConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException("config");
            fileConfiguration = null;
        }
        List list = fileConfiguration.getStringList(path);
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        return list;
    }

    public static final /* synthetic */ Map access$getEnglishMessages(ConfigManager $this) {
        return $this.getEnglishMessages();
    }

    public static final /* synthetic */ Map access$getGermanMessages(ConfigManager $this) {
        return $this.getGermanMessages();
    }

    public static final /* synthetic */ Map access$getSpanishMessages(ConfigManager $this) {
        return $this.getSpanishMessages();
    }

    public static final /* synthetic */ Map access$getFrenchMessages(ConfigManager $this) {
        return $this.getFrenchMessages();
    }

    public static final /* synthetic */ Map access$getRussianMessages(ConfigManager $this) {
        return $this.getRussianMessages();
    }

    public static final /* synthetic */ Map access$getPolishMessages(ConfigManager $this) {
        return $this.getPolishMessages();
    }
}

