/*
 * Decompiled with CFR 0.152.
 */
package de.doetchen.projects.managers;

import de.doetchen.projects.Flys;
import de.doetchen.projects.libs.kotlin.Metadata;
import de.doetchen.projects.libs.kotlin.NoWhenBranchMatchedException;
import de.doetchen.projects.libs.kotlin.Pair;
import de.doetchen.projects.libs.kotlin.jvm.internal.Intrinsics;
import de.doetchen.projects.libs.kotlin.ranges.RangesKt;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0016\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/doetchen/projects/managers/FlightManager;", "Lorg/bukkit/event/Listener;", "plugin", "Lde/doetchen/projects/Flys;", "<init>", "(Lde/doetchen/projects/Flys;)V", "flyingPlayers", "", "Ljava/util/UUID;", "enableFlight", "", "player", "Lorg/bukkit/entity/Player;", "disableFlight", "", "hasFlightEnabled", "toggleFlight", "onPlayerQuit", "event", "Lorg/bukkit/event/player/PlayerQuitEvent;", "onGameModeChange", "Lorg/bukkit/event/player/PlayerGameModeChangeEvent;", "onWorldChange", "Lorg/bukkit/event/player/PlayerChangedWorldEvent;", "isFlightAllowedInWorld", "worldName", "", "setFlightSpeed", "speed", "", "Flys"})
public final class FlightManager
implements Listener {
    @NotNull
    private final Flys plugin;
    @NotNull
    private final Set<UUID> flyingPlayers;

    public FlightManager(@NotNull Flys plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.flyingPlayers = new LinkedHashSet();
    }

    public final boolean enableFlight(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        String string = player.getWorld().getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        if (!this.isFlightAllowedInWorld(string)) {
            this.plugin.getMessageUtils().sendMessage(player, "errors.world-not-allowed", new Pair[0]);
            return false;
        }
        player.setAllowFlight(true);
        player.setFlying(true);
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        this.flyingPlayers.add(uUID);
        float speed = (float)this.plugin.getConfigManager().getDouble("general.flight-speed.default-speed", 0.1);
        player.setFlySpeed(RangesKt.coerceIn(speed, 0.0f, 1.0f));
        return true;
    }

    public final void disableFlight(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        player.setAllowFlight(false);
        player.setFlying(false);
        this.flyingPlayers.remove(player.getUniqueId());
    }

    public final boolean hasFlightEnabled(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return this.flyingPlayers.contains(player.getUniqueId());
    }

    public final boolean toggleFlight(@NotNull Player player) {
        boolean bl;
        Intrinsics.checkNotNullParameter(player, "player");
        if (this.hasFlightEnabled(player)) {
            this.disableFlight(player);
            bl = false;
        } else {
            bl = this.enableFlight(player);
        }
        return bl;
    }

    @EventHandler
    public final void onPlayerQuit(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.flyingPlayers.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public final void onGameModeChange(@NotNull PlayerGameModeChangeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        switch (WhenMappings.$EnumSwitchMapping$0[event.getNewGameMode().ordinal()]) {
            case 1: 
            case 2: {
                this.flyingPlayers.remove(player2.getUniqueId());
                break;
            }
            case 3: 
            case 4: {
                if (!this.hasFlightEnabled(player2)) break;
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> FlightManager.onGameModeChange$lambda$0(player2, this), 1L);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @EventHandler
    public final void onWorldChange(@NotNull PlayerChangedWorldEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        if (this.hasFlightEnabled(player2)) {
            String string = player2.getWorld().getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            if (!this.isFlightAllowedInWorld(string)) {
                this.disableFlight(player2);
                this.plugin.getMessageUtils().sendMessage(player2, "errors.world-not-allowed", new Pair[0]);
            } else {
                BukkitTask bukkitTask = this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> FlightManager.onWorldChange$lambda$0(player2, this), 1L);
                Intrinsics.checkNotNull(bukkitTask);
            }
        }
    }

    private final boolean isFlightAllowedInWorld(String worldName) {
        List<String> allowedWorlds = this.plugin.getConfigManager().getStringList("worlds.allowed-worlds");
        List<String> disabledWorlds = this.plugin.getConfigManager().getStringList("worlds.disabled-worlds");
        if (disabledWorlds.contains(worldName)) {
            return false;
        }
        return allowedWorlds.isEmpty() || allowedWorlds.contains(worldName);
    }

    public final boolean setFlightSpeed(@NotNull Player player, float speed) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (!this.hasFlightEnabled(player)) {
            return false;
        }
        float maxSpeed = (float)this.plugin.getConfigManager().getDouble("general.flight-speed.max-speed", 1.0);
        float clampedSpeed = RangesKt.coerceIn(speed, 0.0f, maxSpeed);
        player.setFlySpeed(clampedSpeed);
        return true;
    }

    private static final void onGameModeChange$lambda$0(Player $player, FlightManager this$0) {
        if ($player.isOnline() && this$0.hasFlightEnabled($player)) {
            $player.setAllowFlight(true);
        }
    }

    private static final void onWorldChange$lambda$0(Player $player, FlightManager this$0) {
        if ($player.isOnline() && this$0.hasFlightEnabled($player)) {
            $player.setAllowFlight(true);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GameMode.values().length];
            try {
                nArray[GameMode.CREATIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameMode.SPECTATOR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameMode.SURVIVAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameMode.ADVENTURE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

