/*
 * Decompiled with CFR 0.152.
 */
package de.doetchen.projects.utils;

import de.doetchen.projects.Flys;
import de.doetchen.projects.libs.kotlin.Metadata;
import de.doetchen.projects.libs.kotlin.Pair;
import de.doetchen.projects.libs.kotlin.jvm.internal.Intrinsics;
import java.util.Arrays;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007JG\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072*\u0010\u000e\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00100\u000f\"\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0010\u00a2\u0006\u0002\u0010\u0011JG\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u00072*\u0010\u000e\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00100\u000f\"\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0010\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u0007JG\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072*\u0010\u000e\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00100\u000f\"\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0010\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/doetchen/projects/utils/MessageUtils;", "", "plugin", "Lde/doetchen/projects/Flys;", "<init>", "(Lde/doetchen/projects/Flys;)V", "parse", "", "message", "sendMessage", "", "player", "Lorg/bukkit/entity/Player;", "configPath", "placeholders", "", "Lde/doetchen/projects/libs/kotlin/Pair;", "(Lorg/bukkit/entity/Player;Ljava/lang/String;[Lde/doetchen/projects/libs/kotlin/Pair;)V", "sender", "Lorg/bukkit/command/CommandSender;", "(Lorg/bukkit/command/CommandSender;Ljava/lang/String;[Lde/doetchen/projects/libs/kotlin/Pair;)V", "sendActionBar", "sendActionBarMessage", "Flys"})
public final class MessageUtils {
    @NotNull
    private final Flys plugin;

    public MessageUtils(@NotNull Flys plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    @NotNull
    public final String parse(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        String string = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        Intrinsics.checkNotNullExpressionValue(string, "translateAlternateColorCodes(...)");
        return string;
    }

    public final void sendMessage(@NotNull Player player, @NotNull String configPath, Pair<String, String> ... placeholders) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(configPath, "configPath");
        Intrinsics.checkNotNullParameter(placeholders, "placeholders");
        String message = this.plugin.getConfigManager().getString(configPath, Arrays.copyOf(placeholders, placeholders.length));
        player.sendMessage(this.parse(message));
    }

    public final void sendMessage(@NotNull CommandSender sender, @NotNull String configPath, Pair<String, String> ... placeholders) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(configPath, "configPath");
        Intrinsics.checkNotNullParameter(placeholders, "placeholders");
        String message = this.plugin.getConfigManager().getString(configPath, Arrays.copyOf(placeholders, placeholders.length));
        sender.sendMessage(this.parse(message));
    }

    public final void sendMessage(@NotNull CommandSender sender, @NotNull String message) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(message, "message");
        sender.sendMessage(this.parse(message));
    }

    public final void sendActionBar(@NotNull Player player, @NotNull String configPath, Pair<String, String> ... placeholders) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(configPath, "configPath");
        Intrinsics.checkNotNullParameter(placeholders, "placeholders");
        String message = this.plugin.getConfigManager().getString(configPath, Arrays.copyOf(placeholders, placeholders.length));
        this.sendActionBarMessage(player, message);
    }

    public final void sendActionBarMessage(@NotNull Player player, @NotNull String message) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(message, "message");
        String parsedMessage = this.parse(message);
        try {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(parsedMessage));
        }
        catch (Exception e) {
            try {
                player.sendTitle("", parsedMessage, 0, 60, 10);
            }
            catch (Exception e2) {
                player.sendMessage("&7[ActionBar] " + parsedMessage);
            }
        }
    }
}

