/*
 * Decompiled with CFR 0.152.
 */
package de.doetchen.projects.utils;

import de.doetchen.projects.Flys;
import de.doetchen.projects.libs.kotlin.Metadata;
import de.doetchen.projects.libs.kotlin.Unit;
import de.doetchen.projects.libs.kotlin.collections.CollectionsKt;
import de.doetchen.projects.libs.kotlin.io.TextStreamsKt;
import de.doetchen.projects.libs.kotlin.jvm.functions.Function1;
import de.doetchen.projects.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import de.doetchen.projects.libs.kotlin.jvm.internal.Intrinsics;
import de.doetchen.projects.libs.kotlin.text.StringsKt;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rJ\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/doetchen/projects/utils/UpdateChecker;", "Lorg/bukkit/event/Listener;", "plugin", "Lde/doetchen/projects/Flys;", "<init>", "(Lde/doetchen/projects/Flys;)V", "latestVersion", "", "updateAvailable", "", "lastCheck", "", "checkForUpdates", "Ljava/util/concurrent/CompletableFuture;", "isNewerVersion", "latest", "current", "onPlayerJoin", "", "event", "Lorg/bukkit/event/player/PlayerJoinEvent;", "sendUpdateNotification", "player", "Lorg/bukkit/entity/Player;", "performInitialCheck", "Companion", "Flys"})
public final class UpdateChecker
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Flys plugin;
    @Nullable
    private String latestVersion;
    private boolean updateAvailable;
    private long lastCheck;
    @NotNull
    private static final String GITHUB_API_URL = "https://api.github.com/repos/Dotta4You/Flys/releases/latest";
    private static final long CHECK_INTERVAL = 3600000L;
    @NotNull
    private static final String UPDATE_PERMISSION = "flys.updatenotify";

    public UpdateChecker(@NotNull Flys plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    @NotNull
    public final CompletableFuture<Boolean> checkForUpdates() {
        CompletableFuture<Boolean> completableFuture = CompletableFuture.supplyAsync(() -> UpdateChecker.checkForUpdates$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue(completableFuture, "supplyAsync(...)");
        return completableFuture;
    }

    private final boolean isNewerVersion(String latest, String current) {
        try {
            String[] stringArray = new String[]{"."};
            List latestParts = StringsKt.split$default((CharSequence)StringsKt.replace$default(latest, "v", "", false, 4, null), stringArray, false, 0, 6, null);
            String[] stringArray2 = new String[]{"."};
            List currentParts = StringsKt.split$default((CharSequence)StringsKt.replace$default(current, "v", "", false, 4, null), stringArray2, false, 0, 6, null);
            int n = Math.max(latestParts.size(), currentParts.size());
            for (int i = 0; i < n; ++i) {
                Object object = (String)CollectionsKt.getOrNull(latestParts, i);
                int latestPart = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
                Object object2 = (String)CollectionsKt.getOrNull(currentParts, i);
                int currentPart = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 0;
                if (latestPart > currentPart) {
                    return true;
                }
                if (latestPart >= currentPart) continue;
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    @EventHandler
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        if (player2.isOp() || player2.hasPermission(UPDATE_PERMISSION) || player2.hasPermission("*")) {
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, () -> UpdateChecker.onPlayerJoin$lambda$0(this, player2), 40L);
        }
    }

    private final void sendUpdateNotification(Player player) {
        String prefix = this.plugin.getConfigManager().getString("messages.prefix");
        String string = this.plugin.getDescription().getVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getVersion(...)");
        String currentVersion = string;
        player.sendMessage("");
        player.sendMessage(this.plugin.getMessageUtils().parse(prefix + "&e&l\u26a1 UPDATE AVAILABLE!"));
        player.sendMessage(this.plugin.getMessageUtils().parse(prefix + "&7Current Version: &c" + currentVersion));
        player.sendMessage(this.plugin.getMessageUtils().parse(prefix + "&7Latest Version: &a" + this.latestVersion));
        player.sendMessage(this.plugin.getMessageUtils().parse(prefix + "&7Download: &bhttps://modrinth.com/plugin/flys/changelog"));
        player.sendMessage("");
        player.playSound(player.getLocation(), "block.note_block.pling", 1.0f, 1.5f);
    }

    public final void performInitialCheck() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> UpdateChecker.performInitialCheck$lambda$0(this));
    }

    private static final Boolean checkForUpdates$lambda$0(UpdateChecker this$0) {
        try {
            if (System.currentTimeMillis() - this$0.lastCheck < 3600000L) {
                return this$0.updateAvailable;
            }
            URL url = new URL(GITHUB_API_URL);
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setRequestProperty("User-Agent", "Flys-Plugin-UpdateChecker");
            if (connection.getResponseCode() == 200) {
                int tagNameEnd;
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String response = TextStreamsKt.readText(reader);
                reader.close();
                int tagNameStart = StringsKt.indexOf$default((CharSequence)response, "\"tag_name\":\"", 0, false, 6, null) + 12;
                if (tagNameStart > 11 && (tagNameEnd = StringsKt.indexOf$default((CharSequence)response, "\"", tagNameStart, false, 4, null)) != -1) {
                    String string = response.substring(tagNameStart, tagNameEnd);
                    Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                    this$0.latestVersion = string;
                    String string2 = this$0.plugin.getDescription().getVersion();
                    Intrinsics.checkNotNullExpressionValue(string2, "getVersion(...)");
                    String currentVersion = string2;
                    String string3 = this$0.latestVersion;
                    Intrinsics.checkNotNull(string3);
                    this$0.updateAvailable = this$0.isNewerVersion(string3, currentVersion);
                    this$0.lastCheck = System.currentTimeMillis();
                    if (this$0.updateAvailable) {
                        this$0.plugin.getLogger().info("Update available! Current: v" + currentVersion + ", Latest: v" + this$0.latestVersion);
                    }
                    return this$0.updateAvailable;
                }
            }
        }
        catch (Exception e) {
            this$0.plugin.getLogger().warning("Could not check for updates: " + e.getMessage());
        }
        return false;
    }

    private static final void onPlayerJoin$lambda$0(UpdateChecker this$0, Player $player) {
        this$0.checkForUpdates().thenAccept(arg_0 -> UpdateChecker.onPlayerJoin$lambda$0$1(arg_0 -> UpdateChecker.onPlayerJoin$lambda$0$0(this$0, $player, arg_0), arg_0));
    }

    private static final Unit onPlayerJoin$lambda$0$0(UpdateChecker this$0, Player $player, Boolean hasUpdate) {
        if (hasUpdate.booleanValue()) {
            Bukkit.getScheduler().runTask((Plugin)this$0.plugin, () -> UpdateChecker.onPlayerJoin$lambda$0$0$0(this$0, $player));
        }
        return Unit.INSTANCE;
    }

    private static final void onPlayerJoin$lambda$0$0$0(UpdateChecker this$0, Player $player) {
        this$0.sendUpdateNotification($player);
    }

    private static final void onPlayerJoin$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void performInitialCheck$lambda$0(UpdateChecker this$0) {
        this$0.checkForUpdates();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lde/doetchen/projects/utils/UpdateChecker$Companion;", "", "<init>", "()V", "GITHUB_API_URL", "", "CHECK_INTERVAL", "", "UPDATE_PERMISSION", "Flys"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

