/*
 * Decompiled with CFR 0.152.
 */
package cc.dvitski.collage;

import cc.dvitski.collage.Collage;
import cc.dvitski.collage.packet.ServerboundScreenshotPayload;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Base64;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ!\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001d\u001a\u00020\u001c8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u00118\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lcc/dvitski/collage/ServerScreenshotHandler;", "", "<init>", "()V", "Lnet/minecraft/class_3222;", "player", "Lnet/minecraft/server/MinecraftServer;", "server", "Lcc/dvitski/collage/packet/ServerboundScreenshotPayload;", "payload", "", "handleScreenshot", "(Lnet/minecraft/class_3222;Lnet/minecraft/server/MinecraftServer;Lcc/dvitski/collage/packet/ServerboundScreenshotPayload;)V", "Ljava/nio/file/Path;", "path", "", "bytes", "", "saveScreenshot", "(Ljava/nio/file/Path;[B)Ljava/lang/String;", "", "validatePng", "([B)Z", "expectedHash", "validateHash", "([BLjava/lang/String;)Z", "hashBytes", "([B)Ljava/lang/String;", "Lnet/minecraft/class_5218;", "LEVEL_RESOURCE", "Lnet/minecraft/class_5218;", "getLEVEL_RESOURCE", "()Lnet/minecraft/class_5218;", "PERMISSION", "Ljava/lang/String;", "collage"})
@SourceDebugExtension(value={"SMAP\nServerScreenshotHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerScreenshotHandler.kt\ncc/dvitski/collage/ServerScreenshotHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
public final class ServerScreenshotHandler {
    @NotNull
    public static final ServerScreenshotHandler INSTANCE = new ServerScreenshotHandler();
    @NotNull
    private static final class_5218 LEVEL_RESOURCE = new class_5218("collage/screenshots");
    @NotNull
    public static final String PERMISSION = "collage.screenshot";

    private ServerScreenshotHandler() {
    }

    @NotNull
    public final class_5218 getLEVEL_RESOURCE() {
        return LEVEL_RESOURCE;
    }

    public final void handleScreenshot(@NotNull class_3222 player, @NotNull MinecraftServer server, @NotNull ServerboundScreenshotPayload payload) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        if (!Permissions.check((class_1297)((class_1297)player), (String)PERMISSION, (int)0)) {
            return;
        }
        Path path = server.method_27050(LEVEL_RESOURCE).resolve(player.method_5845());
        ServerScreenshotHandler serverScreenshotHandler = this;
        try {
            ServerScreenshotHandler $this$handleScreenshot_u24lambda_u240 = serverScreenshotHandler;
            boolean bl = false;
            byte[] bytes = payload.getBytes();
            Intrinsics.checkNotNull((Object)path);
            String filename = $this$handleScreenshot_u24lambda_u240.saveScreenshot(path, bytes);
            String logMessage = "Saved screenshot of " + player.method_7334().name() + " (" + player.method_5667() + "): " + filename;
            if (!server.method_19466(player.method_72498())) {
                Collage.INSTANCE.getLogger().info(logMessage);
                player.method_43502((class_2561)class_2561.method_43470((String)("Server saved screenshot (" + filename + ")")), true);
            } else {
                Collage.INSTANCE.getLogger().debug(logMessage);
            }
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    private final String saveScreenshot(Path path, byte[] bytes) throws IOException {
        String datetime = class_156.method_44893();
        File file = path.toFile();
        file.mkdirs();
        Intrinsics.checkNotNull((Object)file);
        File pngFile = FilesKt.resolve((File)file, (String)(datetime + ".png"));
        FilesKt.writeBytes((File)pngFile, (byte[])bytes);
        return datetime;
    }

    public final boolean validatePng(@NotNull byte[] bytes) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Object object2 = this;
        try {
            ServerScreenshotHandler $this$validatePng_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)ImageIO.read(new ByteArrayInputStream(bytes)));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (Result.isFailure-impl((Object)object2) ? null : object2) != null;
    }

    public final boolean validateHash(@NotNull byte[] bytes, @NotNull String expectedHash) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)expectedHash, (String)"expectedHash");
        String hash = this.hashBytes(bytes);
        return Intrinsics.areEqual((Object)hash, (Object)expectedHash);
    }

    @NotNull
    public final String hashBytes(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        byte[] byArray = MessageDigest.getInstance("SHA-256").digest(bytes);
        Base64.Encoder encoder = Base64.getEncoder();
        Intrinsics.checkNotNullExpressionValue((Object)encoder, (String)"getEncoder(...)");
        Base64.Encoder encoder2 = encoder;
        byte[] p0 = byArray;
        boolean bl = false;
        String string = encoder2.encodeToString(p0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"let(...)");
        return string;
    }
}

