/*
 * Decompiled with CFR 0.152.
 */
package pigcart.cosycritters.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import pigcart.cosycritters.CosyCritters;
import pigcart.cosycritters.config.ConfigData;
import pigcart.cosycritters.config.ConfigScreen;
import pigcart.cosycritters.mixin.access.ParticleEngineAccessor;

public class ConfigManager {
    static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    static final String CONFIG_PATH = "config/cosycritters.json";
    public static ConfigData config;
    public static ConfigData defaultConfig;

    public static void load() {
        File file = new File(CONFIG_PATH);
        try (FileReader reader = new FileReader(file);){
            config = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
        }
        catch (IOException e) {
            CosyCritters.LOGGER.error(e.getMessage());
        }
        if (config == null || ConfigManager.config.configVersion < ConfigManager.defaultConfig.configVersion) {
            config = new ConfigData();
            ConfigManager.save();
        }
    }

    public static void save() {
        CosyCritters.LOGGER.info("Saving: config/cosycritters.json");
        try (FileWriter writer = new FileWriter(CONFIG_PATH);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (Exception e) {
            CosyCritters.LOGGER.error(e.getMessage());
        }
    }

    public static Screen screenPlease(Screen lastScreen) {
        return new ConfigScreen(lastScreen, config, (Component)Component.translatable((String)"cosycritters.title"));
    }

    static {
        defaultConfig = new ConfigData();
    }

    public static class resetParticles
    implements Runnable {
        @Override
        public void run() {
            ((ParticleEngineAccessor)Minecraft.getInstance().particleEngine).callClearParticles();
        }
    }
}

