/*
 * Decompiled with CFR 0.152.
 */
package pigcart.cosycritters.config;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import pigcart.cosycritters.CosyCritters;
import pigcart.cosycritters.config.Annotations;
import pigcart.cosycritters.config.ConfigData;
import pigcart.cosycritters.config.ConfigManager;
import pigcart.cosycritters.config.widget.LabelWidget;
import pigcart.cosycritters.config.widget.Widgets;

public class ConfigScreen
extends OptionsSubScreen {
    Object config;

    public ConfigScreen(Screen lastScreen, Object config, Component title) {
        super(lastScreen, Minecraft.getInstance().options, title);
        this.config = config;
    }

    protected void addFooter() {
        LinearLayout footerLayout = new LinearLayout(0, 0, LinearLayout.Orientation.HORIZONTAL).spacing(8);
        footerLayout.addChild((LayoutElement)this.resetButton());
        footerLayout.addChild((LayoutElement)this.doneButton());
        this.layout.addToFooter((LayoutElement)footerLayout);
    }

    private Button resetButton() {
        return Button.builder((Component)Component.translatable((String)"controls.reset"), button -> {
            CosyCritters.LOGGER.info("Reset config");
            ConfigManager.config = new ConfigData();
            this.minecraft.setScreen(ConfigManager.screenPlease(this.lastScreen));
        }).bounds(this.width / 2 - 155, this.height - 28, 150, 20).build();
    }

    private Button doneButton() {
        return Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).bounds(this.width / 2 - 155 + 160, this.height - 28, 150, 20).build();
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
        ConfigManager.save();
    }

    protected void addOptions() {
        Field[] fields;
        for (Field field : fields = this.config.getClass().getFields()) {
            if (field.isAnnotationPresent(Annotations.NoGUI.class)) continue;
            if (field.isAnnotationPresent(Annotations.OnlyVisibleIf.class)) {
                Annotations.OnlyVisibleIf annotation = field.getAnnotation(Annotations.OnlyVisibleIf.class);
                try {
                    Function function = (Function)annotation.value().getConstructors()[0].newInstance(new Object[0]);
                    boolean optionIsVisible = (Boolean)function.apply(this.config);
                    if (!optionIsVisible) {
                        continue;
                    }
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (field.isAnnotationPresent(Annotations.Label.class)) {
                this.addOption((AbstractWidget)Widgets.getLabel((Component)Component.translatable((String)field.getDeclaredAnnotation(Annotations.Label.class).key())));
            }
            String name = "cosycritters." + field.getName();
            field.setAccessible(true);
            Class<?> type = field.getType();
            Consumer<Object> onValueChange = value -> {
                try {
                    Annotations.OnChange onChange;
                    field.set(this.config, value);
                    if (field.isAnnotationPresent(Annotations.OnChange.class) && (onChange = field.getDeclaredAnnotation(Annotations.OnChange.class)) != null) {
                        ((Runnable)onChange.value().getConstructors()[0].newInstance(new Object[0])).run();
                    }
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
            try {
                AbstractWidget editBox;
                LabelWidget label;
                if (type.equals(Boolean.TYPE)) {
                    this.addOption(Widgets.getBool(name, (Boolean)field.get(this.config), onValueChange));
                    continue;
                }
                if (type.equals(Float.TYPE)) {
                    label = Widgets.getOptionLabel((Component)Component.translatable((String)name).append(":"));
                    editBox = Widgets.getFloat("", ((Float)field.get(this.config)).floatValue(), onValueChange);
                    this.addOption((AbstractWidget)label, editBox);
                    continue;
                }
                if (type.equals(Integer.TYPE)) {
                    label = Widgets.getOptionLabel((Component)Component.translatable((String)name).append(":"));
                    editBox = Widgets.getInt(name, (Integer)field.get(this.config), onValueChange);
                    this.addOption((AbstractWidget)label, editBox);
                    continue;
                }
                if (type.getFields().length > 0) {
                    this.addOption(Widgets.getButton(name, bttn -> {
                        try {
                            Minecraft.getInstance().setScreen((Screen)new ConfigScreen((Screen)this, field.get(this.config), (Component)Component.translatable((String)name)));
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    }));
                    continue;
                }
                CosyCritters.LOGGER.error("Unable to create option for field {}", (Object)field.getName());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void addOption(AbstractWidget widget) {
        DummyOptionInstance option = new DummyOptionInstance(this, widget);
        this.list.addBig((OptionInstance)option);
    }

    public void addOption(AbstractWidget leftWidget, AbstractWidget rightWidget) {
        DummyOptionInstance leftOption = new DummyOptionInstance(this, leftWidget);
        DummyOptionInstance rightOption = new DummyOptionInstance(this, rightWidget);
        this.list.addSmall(new OptionInstance[]{leftOption, rightOption});
    }

    public class DummyOptionInstance
    extends OptionInstance {
        public AbstractWidget widget;

        public DummyOptionInstance(ConfigScreen this$0, AbstractWidget widget) {
            super(null, null, null, null, null, null, null);
            this.widget = widget;
        }

        public AbstractWidget createButton(Options ignored, int x, int y, int width, Consumer ignored2) {
            this.widget.setX(x);
            this.widget.setY(y);
            this.widget.setWidth(width);
            return this.widget;
        }
    }
}

