/*
 * Decompiled with CFR 0.152.
 */
package pigcart.cosycritters.config.widget;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public class InputWidget
extends EditBox {
    Pattern filteredChars;
    public static final Pattern NON_INTEGER = Pattern.compile("[^0-9]");
    public static final Pattern NON_FLOAT = Pattern.compile("[^0-9.]");
    public static final Pattern NON_PATH = Pattern.compile("[^a-z0-9/._-]");

    public InputWidget(int x, int y, int width, int height, Supplier<String> getter, Consumer<String> setter) {
        super(Minecraft.getInstance().font, x, y, width, height, (Component)Component.empty());
        this.setMaxLength(8);
        this.setValue(getter.get());
        this.setResponder(value -> {
            try {
                setter.accept((String)value);
                this.setTextColor(0xE0E0E0);
            }
            catch (NumberFormatException ignored) {
                this.setTextColor(-43691);
            }
        });
    }

    public void setFilter(Pattern pattern) {
        this.filteredChars = pattern;
        if (this.filteredChars != null) {
            this.setFilter(string -> !this.filteredChars.matcher((CharSequence)string).find());
        } else {
            this.setFilter(Objects::nonNull);
        }
    }
}

