/*
 * Decompiled with CFR 0.152.
 */
package pigcart.cosycritters.config.widget;

import java.text.DecimalFormat;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import pigcart.cosycritters.config.widget.InputWidget;
import pigcart.cosycritters.config.widget.LabelWidget;

public class Widgets {
    public static LabelWidget getLabel(Component message) {
        return new LabelWidget(20, message);
    }

    public static LabelWidget getOptionLabel(Component message) {
        return new LabelWidget(20, message).alignRight();
    }

    public static AbstractWidget getBool(String name, boolean initialValue, Consumer<Boolean> onValueChange) {
        return new CycleButton.Builder(value -> value != false ? CommonComponents.OPTION_ON.copy().withStyle(ChatFormatting.GREEN) : CommonComponents.OPTION_OFF.copy().withStyle(ChatFormatting.RED)).withInitialValue((Object)initialValue).withValues((Object[])new Boolean[]{true, false}).create(40, 100, 200, 20, (Component)Component.translatable((String)name), (widget, value) -> onValueChange.accept((Boolean)value));
    }

    public static AbstractWidget getFloat(String name, float initialValue, Consumer<Float> onValueChange) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(6);
        InputWidget inputWidget = new InputWidget(10, 10, 200, 20, () -> df.format(initialValue), string -> onValueChange.accept(Float.valueOf(string)));
        inputWidget.setFilter(InputWidget.NON_FLOAT);
        inputWidget.setMessage((Component)Component.translatable((String)name));
        return inputWidget;
    }

    public static AbstractWidget getInt(String name, int initialValue, Consumer<Integer> onValueChange) {
        InputWidget inputWidget = new InputWidget(10, 10, 200, 20, () -> String.valueOf(initialValue), string -> onValueChange.accept(Integer.valueOf(string)));
        inputWidget.setFilter(InputWidget.NON_INTEGER);
        inputWidget.setMessage((Component)Component.translatable((String)name));
        return inputWidget;
    }

    public static AbstractWidget getButton(String name, Button.OnPress onPress) {
        return Button.builder((Component)Component.translatable((String)name), (Button.OnPress)onPress).bounds(40, 40, 120, 20).build();
    }

    public static AbstractWidget getSlider(final String name, double initialValue, final Consumer<Double> onValueChange, final Function<Double, String> valueFormatter) {
        return new AbstractSliderButton(0, 0, 0, 0, (Component)Component.translatable((String)name), initialValue){

            protected void updateMessage() {
                this.setMessage((Component)Component.translatable((String)name, (Object[])new Object[]{valueFormatter.apply(this.value)}));
            }

            protected void applyValue() {
                onValueChange.accept(this.value);
            }
        };
    }
}

