/*
 * Decompiled with CFR 0.152.
 */
package pigcart.cosycritters.particle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import pigcart.cosycritters.Util;
import pigcart.cosycritters.config.ConfigData;
import pigcart.cosycritters.config.ConfigManager;
import pigcart.cosycritters.particle.CritterParticle;

public class BirdParticle
extends CritterParticle {
    public static final ConfigData.BirdOptions CONFIG = ConfigManager.config.bird;
    Vector3f target;
    Behaviour behaviour;
    BlockState perch;
    public static final Collection<BirdParticle> birds = new ArrayList<BirdParticle>();
    int behaviourTime;

    private BirdParticle(ClientLevel level, double x, double y, double z, double landAtX, double landAtY, double landAtZ) {
        super(level, x, y, z, Util.getSprite("crow_left"));
        if (this.entitiesNearby(new Vec3(landAtX, landAtY, landAtZ))) {
            this.remove();
        }
        this.quadSize = 0.5f;
        this.setSize(0.5f, 0.5f);
        this.lifetime = 6000;
        this.target = new Vector3f(this.random.nextFloat() - 0.5f, this.random.nextFloat(), this.random.nextFloat() - 0.5f).normalize().mul(0.5f);
        this.setBehaviour(Behaviour.FLYING);
        birds.add(this);
        this.xd = this.target.x;
        this.yd = this.target.y;
        this.zd = this.target.z;
    }

    private void setBehaviour(Behaviour behaviour) {
        this.setBehaviour(behaviour, true);
    }

    private void setBehaviour(Behaviour behaviour, boolean resetBehaviourTime) {
        this.behaviour = behaviour;
        if (resetBehaviourTime) {
            this.behaviourTime = 0;
        }
        switch (behaviour.ordinal()) {
            case 1: {
                BlockPos.MutableBlockPos highest = new BlockPos.MutableBlockPos(this.x, -2.147483648E9, this.z);
                for (int i = 0; i < 3; ++i) {
                    int z;
                    int x = this.random.nextIntBetweenInclusive((int)this.x - 16, (int)this.x + 16);
                    int y = this.level.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z = this.random.nextIntBetweenInclusive((int)this.z - 16, (int)this.z + 16)) - 1;
                    if (y <= highest.getY()) continue;
                    highest.set(x, y, z);
                }
                if (this.level.getFluidState((BlockPos)highest).isEmpty()) {
                    this.target = highest.getCenter().toVector3f();
                    break;
                }
                this.setBehaviour(Behaviour.FLYING);
                break;
            }
            case 2: {
                this.setParticleSpeed(0.0, 0.0, 0.0);
                this.perch = this.level.getBlockState(BlockPos.containing((double)this.x, (double)(this.y - 0.5), (double)this.z));
            }
        }
    }

    private String getRelativeDirection(float facingX, float facingZ) {
        float b;
        Vector2f facing = new Vector2f(facingX, facingZ).normalize();
        Vec3 camPos = Util.getCameraPos();
        Vector2f relativeDirection = new Vector2f((float)(this.x - camPos.x()), (float)(this.z - camPos.z())).normalize();
        float a = (float)Math.atan2(relativeDirection.y, relativeDirection.x);
        float c = a - (b = (float)Math.atan2(facing.y, facing.x));
        if (c > (float)Math.PI) {
            c -= (float)Math.PI * 2;
        } else if (c < (float)(-Math.PI)) {
            c += (float)Math.PI * 2;
        }
        if (c < 0.0f) {
            return "right";
        }
        return "left";
    }

    private void reactToDisturbances() {
        Vec3 birdPos;
        if (this.perch != null && !this.perch.equals(this.level.getBlockState(BlockPos.containing((double)this.x, (double)(this.y - 0.5), (double)this.z)))) {
            this.setBehaviour(Behaviour.FLYING);
        } else if (this.age % BirdParticle.CONFIG.reactionSpeed == 0 && this.entitiesNearby(birdPos = new Vec3(this.x, this.y, this.z))) {
            this.setBehaviour(Behaviour.FLYING);
        }
    }

    private boolean entitiesNearby(Vec3 pos) {
        List nearbyEntities = this.level.getEntitiesOfClass(Entity.class, AABB.ofSize((Vec3)pos, (double)BirdParticle.CONFIG.reactionDistance, (double)BirdParticle.CONFIG.reactionDistance, (double)BirdParticle.CONFIG.reactionDistance));
        return !nearbyEntities.isEmpty();
    }

    private void setFlyingSprite(double speed, double oldSpeed) {
        if (speed < oldSpeed & this.y < this.yo) {
            this.setSprite(Util.getSprite("crow_flying_%s_1".formatted(this.getRelativeDirection((float)this.xd, (float)this.zd))));
        } else {
            this.setSprite(Util.getSprite("crow_flying_%s_%d".formatted(this.getRelativeDirection((float)this.xd, (float)this.zd), this.age / 2 % 2)));
        }
    }

    public void remove() {
        birds.remove((Object)this);
        super.remove();
    }

    public void tick() {
        super.tick();
        if (Double.isNaN(this.y)) {
            this.remove();
        }
        if (Util.getCameraPos().distanceToSqr(this.x, this.y, this.z) > (double)Mth.square((int)BirdParticle.CONFIG.despawnDistance)) {
            this.remove();
        }
        ++this.behaviourTime;
        switch (this.behaviour.ordinal()) {
            case 0: {
                double speed;
                double oldSpeed = Vector3d.length((double)this.xd, (double)this.yd, (double)this.zd);
                double avgVelX = 0.0;
                double avgVelY = 0.0;
                double avgVelZ = 0.0;
                double avgPosX = 0.0;
                double avgPosY = 0.0;
                double avgPosZ = 0.0;
                double closeXd = 0.0;
                double closeYd = 0.0;
                double closeZd = 0.0;
                int neighbors = 0;
                for (BirdParticle other : birds) {
                    double distance;
                    if (other == this || !((distance = Vector3d.distance((double)this.x, (double)this.y, (double)this.z, (double)other.x, (double)other.y, (double)other.z)) < (double)BirdParticle.CONFIG.flockRange)) continue;
                    avgVelX += other.xd;
                    avgVelY += other.yd;
                    avgVelZ += other.zd;
                    avgPosX += other.x;
                    avgPosY += other.y;
                    avgPosZ += other.z;
                    ++neighbors;
                    if (!(distance < (double)BirdParticle.CONFIG.separationDistance)) continue;
                    closeXd += this.x - other.x;
                    closeYd += this.y - other.y;
                    closeZd += this.z - other.z;
                }
                if (neighbors > 0) {
                    this.xd += ((avgVelX /= (double)neighbors) - this.xd) * (double)BirdParticle.CONFIG.alignment + ((avgPosX /= (double)neighbors) - this.x) * (double)BirdParticle.CONFIG.cohesion + closeXd * (double)BirdParticle.CONFIG.separation + (double)this.random.triangle(0.0f, BirdParticle.CONFIG.flightRandomness);
                    this.yd += ((avgVelY /= (double)neighbors) - this.yd) * (double)BirdParticle.CONFIG.alignment + ((avgPosY /= (double)neighbors) - this.y) * (double)BirdParticle.CONFIG.cohesion + closeYd * (double)BirdParticle.CONFIG.separation + (double)this.random.triangle(0.0f, BirdParticle.CONFIG.flightRandomness);
                    this.zd += ((avgVelZ /= (double)neighbors) - this.zd) * (double)BirdParticle.CONFIG.alignment + ((avgPosZ /= (double)neighbors) - this.z) * (double)BirdParticle.CONFIG.cohesion + closeZd * (double)BirdParticle.CONFIG.separation + (double)this.random.triangle(0.0f, BirdParticle.CONFIG.flightRandomness);
                }
                if (this.y - (double)this.level.getHeight(Heightmap.Types.MOTION_BLOCKING, (int)this.x, (int)this.z) > (double)BirdParticle.CONFIG.flightHeightLimit) {
                    this.yd -= (double)BirdParticle.CONFIG.flightHeightLimitFactor;
                }
                int avoidDistance = BirdParticle.CONFIG.blockAvoidanceDistance;
                Vec3 start = new Vec3(this.x, this.y, this.z);
                Vec3 lineToCast = new Vec3(this.xd, this.yd, this.zd).normalize().multiply((double)avoidDistance, (double)avoidDistance, (double)avoidDistance);
                Vec3 end = new Vec3(this.x, this.y, this.z).add(lineToCast);
                BlockHitResult hitResult = this.level.clip(Util.getClipContext(start, end));
                if (hitResult.getType() != HitResult.Type.MISS) {
                    float factor = BirdParticle.CONFIG.blockAvoidanceFactor;
                    if (hitResult.getLocation().closerThan((Position)start, 1.0)) {
                        if (hitResult.getDirection() == Direction.UP && this.behaviourTime > 60 && this.level.getFluidState(hitResult.getBlockPos()).isEmpty()) {
                            Vec3 loc = hitResult.getLocation();
                            this.setPos(loc.x, loc.y + 0.5, loc.z);
                            this.setBehaviour(Behaviour.PERCHED);
                            return;
                        }
                        factor = 0.4f;
                    }
                    this.xd -= Math.signum(this.xd) * (double)factor;
                    this.yd -= Math.signum(this.yd) * (double)factor;
                    this.zd -= Math.signum(this.zd) * (double)factor;
                }
                if ((speed = Vector3d.length((double)this.xd, (double)this.yd, (double)this.zd)) > (double)BirdParticle.CONFIG.maxSpeed) {
                    this.xd = this.xd / speed * (double)BirdParticle.CONFIG.maxSpeed;
                    this.yd = this.yd / speed * (double)BirdParticle.CONFIG.maxSpeed;
                    this.zd = this.zd / speed * (double)BirdParticle.CONFIG.maxSpeed;
                } else if (speed < (double)BirdParticle.CONFIG.minSpeed) {
                    this.xd = this.xd / speed * (double)BirdParticle.CONFIG.minSpeed;
                    this.yd = this.yd / speed * (double)BirdParticle.CONFIG.minSpeed;
                    this.zd = this.zd / speed * (double)BirdParticle.CONFIG.minSpeed;
                }
                if (this.behaviourTime > BirdParticle.CONFIG.maxBehaviourTime) {
                    this.setBehaviour(Behaviour.LANDING);
                }
                this.setFlyingSprite(speed, oldSpeed);
                break;
            }
            case 1: {
                BlockPos pos;
                BlockState state;
                double oldSpeed = Vector3d.length((double)this.xd, (double)this.yd, (double)this.zd);
                Vec3 targetOffset = new Vec3(this.x - (double)this.target.x, this.y - (double)this.target.y, this.z - (double)this.target.z);
                float responsiveness = (float)Math.min((double)BirdParticle.CONFIG.landingResponsiveness, targetOffset.length());
                if (this.x > (double)this.target.x) {
                    this.xd -= (double)responsiveness;
                }
                if (this.x < (double)this.target.x) {
                    this.xd += (double)responsiveness;
                }
                if (this.y > (double)this.target.y) {
                    this.yd -= (double)responsiveness;
                }
                if (this.y < (double)this.target.y) {
                    this.yd += (double)responsiveness;
                }
                if (this.z > (double)this.target.z) {
                    this.zd -= (double)responsiveness;
                }
                if (this.z < (double)this.target.z) {
                    this.zd += (double)responsiveness;
                }
                if (!(state = this.level.getBlockState(pos = BlockPos.containing((double)this.x, (double)(this.y - 0.7), (double)this.z))).getCollisionShape((BlockGetter)this.level, pos).isEmpty()) {
                    this.setBehaviour(Behaviour.PERCHED);
                }
                double speed = Vector3d.length((double)this.xd, (double)this.yd, (double)this.zd);
                this.setFlyingSprite(speed, oldSpeed);
                break;
            }
            case 2: {
                if ((double)this.random.nextFloat() < 0.01) {
                    this.setBehaviour(Behaviour.CHECKING, false);
                }
                this.setSprite(Util.getSprite("crow_" + this.getRelativeDirection(this.target.x, this.target.z)));
                this.reactToDisturbances();
                if (this.behaviourTime <= BirdParticle.CONFIG.maxBehaviourTime) break;
                this.setBehaviour(Behaviour.FLYING);
                break;
            }
            case 3: {
                if ((double)this.random.nextFloat() < 0.02) {
                    this.setBehaviour(Behaviour.PERCHED, false);
                }
                this.setSprite(Util.getSprite("crow_checking_" + this.getRelativeDirection(this.target.x, this.target.z)));
                this.reactToDisturbances();
            }
        }
    }

    private static enum Behaviour {
        FLYING,
        LANDING,
        PERCHED,
        CHECKING;

    }

    public static class Provider
    extends CritterParticle.CritterProvider {
        public Provider(SpriteSet spriteSet) {
            super(spriteSet);
        }

        @Override
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new BirdParticle(level, x, y, z, velocityX, velocityY, velocityZ);
        }
    }
}

