/*
 * Decompiled with CFR 0.152.
 */
package pigcart.cosycritters.particle;

import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import pigcart.cosycritters.CosyCritters;
import pigcart.cosycritters.Util;
import pigcart.cosycritters.particle.ComplexCritterParticle;
import pigcart.cosycritters.particle.CritterParticle;

public class MothParticle
extends ComplexCritterParticle {
    private final Vec3 targetLamp;

    private MothParticle(ClientLevel level, double x, double y, double z, SpriteSet spriteSet) {
        super(level, x, y, z, spriteSet.get(level.random));
        this.quadSize = 0.1f;
        this.lifetime = 500;
        this.targetLamp = BlockPos.containing((double)x, (double)y, (double)z).getCenter();
        this.xd = 0.5;
        ++CosyCritters.moths;
    }

    public void remove() {
        if (this.isAlive()) {
            --CosyCritters.moths;
        }
        super.remove();
    }

    public void tick() {
        super.tick();
        if (this.x == this.xo && this.y == this.yo && this.z == this.zo) {
            this.remove();
        }
        float centeringFactor = 5.0E-5f;
        Vec3 vec3 = new Vec3(this.x, this.y, this.z);
        if (this.targetLamp.distanceTo(vec3) > 1.0) {
            this.xd = (this.targetLamp.x - this.x) * (double)centeringFactor;
            this.yd = (this.targetLamp.y - this.y) * (double)centeringFactor;
            this.zd = (this.targetLamp.z - this.z) * (double)centeringFactor;
        } else {
            Vec3 vec32 = new Vec3(this.x, this.y, this.z);
            if (this.targetLamp.distanceTo(vec32) < 0.5) {
                this.xd = -(this.targetLamp.x - this.x) * (double)centeringFactor;
                this.yd = -(this.targetLamp.y - this.y) * (double)centeringFactor;
                this.zd = -(this.targetLamp.z - this.z) * (double)centeringFactor;
            }
        }
        float speed = Mth.sqrt((float)((float)(this.xd * this.xd + this.yd * this.yd + this.zd * this.zd)));
        float maxSpeed = 0.1f;
        float minSpeed = 0.05f;
        if (speed > maxSpeed) {
            this.xd = this.xd / (double)speed * (double)maxSpeed;
            this.yd = this.yd / (double)speed * (double)maxSpeed;
            this.zd = this.zd / (double)speed * (double)maxSpeed;
        } else if (speed < minSpeed) {
            this.xd = this.xd / (double)speed * (double)minSpeed;
            this.yd = this.yd / (double)speed * (double)minSpeed;
            this.zd = this.zd / (double)speed * (double)minSpeed;
        }
        this.xd *= (double)this.random.nextFloat() + 0.5;
        this.yd *= (double)this.random.nextFloat() + 0.5;
        this.zd *= (double)this.random.nextFloat() + 0.5;
    }

    @Override
    public <T> void renderCustom(T renderInfo, Camera camera, float partialTick) {
        Vec3 vec3 = Util.getCameraPos(camera);
        float x = (float)(Mth.lerp((double)partialTick, (double)this.xo, (double)this.x) - vec3.x());
        float y = (float)(Mth.lerp((double)partialTick, (double)this.yo, (double)this.y) - vec3.y());
        float z = (float)(Mth.lerp((double)partialTick, (double)this.zo, (double)this.z) - vec3.z());
        Vector3f cameraOffset = new Vector3f(x, y, z);
        float lerpedAge = Mth.lerp((float)partialTick, (float)(this.age - 1), (float)this.age);
        float wingsPos = Mth.sin((float)(lerpedAge * 1.5f)) * 0.7f;
        Quaternionf leftWing = new Quaternionf(new AxisAngle4d((double)(wingsPos * 1.5707964f - 1.5707964f), 1.0, 0.0, 0.0));
        Quaternionf rightWing = new Quaternionf(new AxisAngle4d((double)(wingsPos * 1.5707964f - 1.5707964f), -1.0, 0.0, 0.0));
        Vector3f leftWingOffset = new Vector3f(0.0f, -this.quadSize * wingsPos, this.quadSize - this.quadSize * Mth.abs((float)wingsPos));
        Vector3f rightWingOffset = new Vector3f(0.0f, -this.quadSize * wingsPos, this.quadSize * Mth.abs((float)wingsPos) - this.quadSize);
        Vector3f delta = new Vector3f((float)this.xd, (float)this.yd, (float)this.zd);
        float angle = (float)Math.acos(new Vector3f((Vector3fc)delta).normalize().y);
        Vector3f axis = new Vector3f(-delta.z(), 0.0f, delta.x()).normalize();
        Quaternionf quaternion = new Quaternionf(new AxisAngle4f(-angle, (Vector3fc)axis));
        leftWing.mul((Quaternionfc)quaternion);
        rightWing.mul((Quaternionfc)quaternion);
        leftWingOffset.rotate((Quaternionfc)quaternion);
        rightWingOffset.rotate((Quaternionfc)quaternion);
        leftWingOffset.add((Vector3fc)cameraOffset);
        rightWingOffset.add((Vector3fc)cameraOffset);
        this.flipItTurnwaysIfBackfaced(leftWing, leftWingOffset);
        this.flipItTurnwaysIfBackfaced(rightWing, rightWingOffset);
        this.renderCustomQuad(renderInfo, leftWing, leftWingOffset.x, leftWingOffset.y, leftWingOffset.z, partialTick);
        this.renderCustomQuad(renderInfo, rightWing, rightWingOffset.x, rightWingOffset.y, rightWingOffset.z, partialTick);
    }

    protected void flipItTurnwaysIfBackfaced(Quaternionf quaternion, Vector3f toCamera) {
        Vector3f normal = new Vector3f(0.0f, 0.0f, 1.0f);
        normal.rotate((Quaternionfc)quaternion).normalize();
        float dot = normal.dot((Vector3fc)toCamera);
        if (dot > 0.0f) {
            quaternion.rotateY((float)Math.PI);
        }
    }

    public static class Provider
    extends CritterParticle.CritterProvider {
        public Provider(SpriteSet spriteSet) {
            super(spriteSet);
        }

        @Override
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new MothParticle(level, x, y, z, this.spriteSet);
        }
    }
}

