/*
 * Decompiled with CFR 0.152.
 */
package pigcart.cosycritters.particle;

import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import pigcart.cosycritters.CosyCritters;
import pigcart.cosycritters.Util;
import pigcart.cosycritters.particle.ComplexCritterParticle;
import pigcart.cosycritters.particle.CritterParticle;

public class SpiderParticle
extends ComplexCritterParticle {
    boolean clockwise;
    BlockPos blockPos;
    Direction direction;
    float speed;
    Vec3 oldPosition;

    private SpiderParticle(ClientLevel level, double x, double y, double z, int direction3DDataValue) {
        super(level, x, y, z, Util.getSprite("spider_crawling_0"));
        this.quadSize = this.random.nextFloat() * 0.1f + 0.05f;
        this.speed = this.quadSize / 2.0f;
        this.roll = (float)Math.PI * 2 * this.random.nextFloat();
        this.lifetime = 500 + this.random.nextInt(50);
        this.clockwise = this.random.nextBoolean();
        this.blockPos = BlockPos.containing((double)x, (double)y, (double)z);
        this.direction = Direction.from3DDataValue((int)direction3DDataValue);
        this.oldPosition = new Vec3(x, y, z);
        ++CosyCritters.spiders;
    }

    public void remove() {
        if (this.isAlive()) {
            --CosyCritters.spiders;
        }
        super.remove();
    }

    public void tick() {
        Vec3 to;
        BlockHitResult hitResult;
        super.tick();
        this.setSprite(Util.getSprite("spider_crawling_" + this.age % 2));
        if (!Util.getCameraPos().closerThan((Position)new Vec3(this.x, this.y, this.z), 32.0)) {
            this.remove();
        }
        Vec3 from = new Vec3(this.x, this.y, this.z);
        if (this.age % 20 == 0) {
            if (this.oldPosition.closerThan((Position)from, 0.05)) {
                this.remove();
            } else {
                this.oldPosition = from;
            }
        }
        this.oRoll = this.roll;
        this.roll += this.clockwise ? this.speed : -this.speed;
        if (!this.blockPos.equals((Object)BlockPos.containing((double)this.x, (double)this.y, (double)this.z))) {
            if (!this.level.getFluidState(BlockPos.containing((Position)from)).isEmpty()) {
                this.remove();
            }
            this.blockPos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
            this.clockwise = this.random.nextBoolean();
        }
        if ((hitResult = this.level.clip(new ClipContext(from, to = from.add(new Vec3(this.xd, this.yd, this.zd).normalize().multiply((double)(this.quadSize / 2.0f), (double)(this.quadSize / 2.0f), (double)(this.quadSize / 2.0f))), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, Util.getCollisionContext()))).getType().equals((Object)HitResult.Type.BLOCK)) {
            Direction oldDirection = this.direction;
            this.direction = hitResult.getDirection().getOpposite();
            if (oldDirection.getAxis() == Direction.Axis.Y) {
                if (this.direction.equals((Object)Direction.SOUTH)) {
                    this.roll = 4.712389f;
                } else if (this.direction.equals((Object)Direction.EAST)) {
                    this.roll = (float)Math.PI;
                } else if (this.direction.equals((Object)Direction.NORTH)) {
                    this.roll = (float)Math.PI * 2;
                } else if (this.direction.equals((Object)Direction.WEST)) {
                    this.roll = 1.5707964f;
                }
                if (oldDirection.equals((Object)Direction.UP)) {
                    this.roll += (float)Math.PI;
                }
            } else if (oldDirection.getAxis() == Direction.Axis.X) {
                if (this.direction.equals((Object)Direction.SOUTH)) {
                    this.roll = (float)Math.PI;
                } else if (this.direction.equals((Object)Direction.UP)) {
                    this.roll = 4.712389f;
                } else if (this.direction.equals((Object)Direction.NORTH)) {
                    this.roll = 1.5707964f;
                } else if (this.direction.equals((Object)Direction.DOWN)) {
                    this.roll = (float)Math.PI * 2;
                }
                if (oldDirection.equals((Object)Direction.WEST)) {
                    this.roll += (float)Math.PI;
                }
            } else if (oldDirection.getAxis() == Direction.Axis.Z) {
                if (this.direction.equals((Object)Direction.EAST)) {
                    this.roll = 1.5707964f;
                } else if (this.direction.equals((Object)Direction.UP)) {
                    this.roll = (float)Math.PI;
                } else if (this.direction.equals((Object)Direction.WEST)) {
                    this.roll = (float)Math.PI;
                } else if (this.direction.equals((Object)Direction.DOWN)) {
                    this.roll = 1.5707964f;
                }
                if (oldDirection.equals((Object)Direction.SOUTH)) {
                    this.roll += (float)Math.PI;
                }
            }
        } else {
            to = from.add(new Vec3(this.direction.step()).multiply(0.2, 0.2, 0.2));
            hitResult = this.level.clip(new ClipContext(from, to, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, Util.getCollisionContext()));
            if (hitResult.getType().equals((Object)HitResult.Type.MISS)) {
                to = from.add(new Vec3(this.direction.step()).multiply(0.5, 0.5, 0.5)).add(new Vec3(-this.xd, -this.yd, -this.zd).normalize().multiply(0.5, 0.5, 0.5));
                hitResult = this.level.clip(new ClipContext(from, to, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, Util.getCollisionContext()));
                if (hitResult.getType().equals((Object)HitResult.Type.BLOCK)) {
                    if (this.direction != hitResult.getDirection().getOpposite()) {
                        Direction oldDirection = this.direction;
                        this.direction = hitResult.getDirection().getOpposite();
                        if (oldDirection.getAxis() == Direction.Axis.Y) {
                            if (this.direction.equals((Object)Direction.SOUTH)) {
                                this.roll = 4.712389f;
                            } else if (this.direction.equals((Object)Direction.EAST)) {
                                this.roll = (float)Math.PI;
                            } else if (this.direction.equals((Object)Direction.NORTH)) {
                                this.roll = (float)Math.PI * 2;
                            } else if (this.direction.equals((Object)Direction.WEST)) {
                                this.roll = 1.5707964f;
                            }
                            if (oldDirection.equals((Object)Direction.DOWN)) {
                                this.roll += (float)Math.PI;
                            }
                        } else if (oldDirection.getAxis() == Direction.Axis.X) {
                            if (this.direction.equals((Object)Direction.SOUTH)) {
                                this.roll = (float)Math.PI;
                            } else if (this.direction.equals((Object)Direction.UP)) {
                                this.roll = 4.712389f;
                            } else if (this.direction.equals((Object)Direction.NORTH)) {
                                this.roll = 1.5707964f;
                            } else if (this.direction.equals((Object)Direction.DOWN)) {
                                this.roll = (float)Math.PI * 2;
                            }
                            if (oldDirection.equals((Object)Direction.EAST)) {
                                this.roll += (float)Math.PI;
                            }
                        } else if (oldDirection.getAxis() == Direction.Axis.Z) {
                            if (this.direction.equals((Object)Direction.EAST)) {
                                this.roll = 1.5707964f;
                            } else if (this.direction.equals((Object)Direction.UP)) {
                                this.roll = (float)Math.PI;
                            } else if (this.direction.equals((Object)Direction.WEST)) {
                                this.roll = (float)Math.PI;
                            } else if (this.direction.equals((Object)Direction.DOWN)) {
                                this.roll = 1.5707964f;
                            }
                            if (oldDirection.equals((Object)Direction.NORTH)) {
                                this.roll += (float)Math.PI;
                            }
                        }
                    }
                } else {
                    this.remove();
                }
            }
        }
        switch (this.direction) {
            case DOWN: {
                this.xd = Mth.cos((float)this.roll) * -this.speed;
                this.zd = Mth.sin((float)this.roll) * this.speed;
                this.yd = 0.0;
                break;
            }
            case UP: {
                this.xd = Mth.sin((float)this.roll) * this.speed;
                this.zd = Mth.cos((float)this.roll) * -this.speed;
                this.yd = 0.0;
                break;
            }
            case NORTH: {
                this.xd = Mth.sin((float)this.roll) * -this.speed;
                this.yd = Mth.cos((float)this.roll) * this.speed;
                this.zd = 0.0;
                break;
            }
            case SOUTH: {
                this.xd = Mth.cos((float)this.roll) * this.speed;
                this.yd = Mth.sin((float)this.roll) * -this.speed;
                this.zd = 0.0;
                break;
            }
            case WEST: {
                this.yd = Mth.sin((float)this.roll) * this.speed;
                this.zd = Mth.cos((float)this.roll) * -this.speed;
                this.xd = 0.0;
                break;
            }
            case EAST: {
                this.yd = Mth.cos((float)this.roll) * -this.speed;
                this.zd = Mth.sin((float)this.roll) * this.speed;
                this.xd = 0.0;
            }
        }
    }

    @Override
    public <T> void renderCustom(T renderInfo, Camera camera, float tickPercent) {
        Vec3 camPos = Util.getCameraPos(camera);
        float x = (float)(Mth.lerp((double)tickPercent, (double)this.xo, (double)this.x) - camPos.x());
        float y = (float)(Mth.lerp((double)tickPercent, (double)this.yo, (double)this.y) - camPos.y());
        float z = (float)(Mth.lerp((double)tickPercent, (double)this.zo, (double)this.z) - camPos.z());
        Quaternionf quaternionf = switch (this.direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> new Quaternionf(new AxisAngle4f(1.5707964f, -1.0f, 0.0f, 0.0f));
            case Direction.UP -> new Quaternionf(new AxisAngle4f(1.5707964f, 1.0f, 0.0f, 0.0f)).rotateZ(1.5707964f);
            case Direction.WEST -> new Quaternionf(new AxisAngle4f(1.5707964f, 0.0f, 1.0f, 0.0f)).rotateZ((float)Math.PI);
            case Direction.EAST -> new Quaternionf(new AxisAngle4f(1.5707964f, 0.0f, -1.0f, 0.0f)).rotateZ(1.5707964f);
            case Direction.NORTH -> new Quaternionf(new AxisAngle4f(1.5707964f, 0.0f, 0.0f, -1.0f));
            case Direction.SOUTH -> new Quaternionf(new AxisAngle4f((float)Math.PI, 0.0f, 1.0f, 0.0f));
        };
        quaternionf.rotateZ(Mth.lerp((float)tickPercent, (float)this.oRoll, (float)this.roll));
        this.renderCustomQuad(renderInfo, quaternionf, x, y, z, tickPercent);
    }

    public static class Provider
    extends CritterParticle.CritterProvider {
        public Provider(SpriteSet spriteSet) {
            super(spriteSet);
        }

        @Override
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new SpiderParticle(level, x, y, z, (int)velocityX);
        }
    }
}

