/*
 * Decompiled with CFR 0.152.
 */
package pigcart.cosycritters.particle;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Vector2f;
import org.joml.Vector3f;
import pigcart.cosycritters.Util;
import pigcart.cosycritters.config.ConfigManager;
import pigcart.cosycritters.particle.CritterParticle;

public class BirdParticle
extends CritterParticle {
    int spawnAnimationLength;
    int spawnAnimationTime;
    Vec3 spawnAnimationStart;
    Vec3 spawnAnimationEnd;
    Vector3f facing;
    Behaviour behaviour;
    BlockState perch;

    private BirdParticle(ClientLevel level, double x, double y, double z, double landAtX, double landAtY, double landAtZ) {
        super(level, x, y, z, Util.getSprite("crow_left"));
        this.spawnAnimationTime = this.spawnAnimationLength = 40;
        if (this.entitiesNearby(new Vec3(landAtX, landAtY, landAtZ))) {
            this.remove();
        }
        this.hasPhysics = false;
        this.quadSize = 0.0f;
        this.lifetime = 6000;
        this.facing = new Vector3f(this.random.nextFloat() - 0.5f, this.random.nextFloat(), this.random.nextFloat() - 0.5f).normalize().mul(0.5f);
        this.spawnAnimationStart = new Vec3(x, y, z);
        this.spawnAnimationEnd = new Vec3(landAtX, landAtY, landAtZ);
        this.setBehaviour(Behaviour.SPAWNING);
    }

    public Optional<ParticleGroup> getParticleGroup() {
        return Optional.of(ConfigManager.birdGroup);
    }

    private void setBehaviour(Behaviour behaviour) {
        this.behaviour = behaviour;
        switch (behaviour.ordinal()) {
            case 1: {
                this.perch = this.level.getBlockState(BlockPos.containing((double)this.x, (double)(this.y - 0.5), (double)this.z));
                break;
            }
            case 3: {
                this.lifetime = 100;
                this.age = 0;
                this.setPos(this.spawnAnimationEnd.x, this.spawnAnimationEnd.y, this.spawnAnimationEnd.z);
            }
        }
    }

    private String getRelativeDirection() {
        float b;
        Vector2f birdFacing = new Vector2f(this.facing.x, this.facing.z).normalize();
        Vec3 camPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        Vector2f relativeDirection = new Vector2f((float)(this.x - camPos.x()), (float)(this.z - camPos.z())).normalize();
        float a = Math.atan2((float)relativeDirection.y, (float)relativeDirection.x);
        float c = a - (b = Math.atan2((float)birdFacing.y, (float)birdFacing.x));
        if (c > (float)java.lang.Math.PI) {
            c -= (float)java.lang.Math.PI * 2;
        } else if (c < (float)(-java.lang.Math.PI)) {
            c += (float)java.lang.Math.PI * 2;
        }
        if (c < 0.0f) {
            return "right";
        }
        return "left";
    }

    private void reactToDisturbances() {
        if (!this.perch.equals(this.level.getBlockState(BlockPos.containing((double)this.x, (double)(this.y - 0.5), (double)this.z)))) {
            this.setBehaviour(Behaviour.FLY_UP_AWAY_TO_THE_SUN_LIKE_A_FEATHERY_PIECE_OF_GARGBAGE);
        } else if (this.age % ConfigManager.config.birdReactionSpeed == 0) {
            Vec3 birdPos = new Vec3(this.x, this.y, this.z);
            if (this.entitiesNearby(birdPos)) {
                this.setBehaviour(Behaviour.FLY_UP_AWAY_TO_THE_SUN_LIKE_A_FEATHERY_PIECE_OF_GARGBAGE);
            } else if (!Util.getCameraPos().closerThan((Position)birdPos, (double)ConfigManager.config.birdDespawnDistance)) {
                this.remove();
            }
        }
    }

    private boolean entitiesNearby(Vec3 pos) {
        List nearbyEntities = this.level.getEntitiesOfClass(Entity.class, AABB.ofSize((Vec3)pos, (double)ConfigManager.config.birdReactionDistance, (double)ConfigManager.config.birdReactionDistance, (double)ConfigManager.config.birdReactionDistance));
        return !nearbyEntities.isEmpty();
    }

    public void tick() {
        super.tick();
        switch (this.behaviour.ordinal()) {
            case 0: {
                this.setSprite(Util.getSprite("crow_flying_%s_%d".formatted(this.getRelativeDirection(), this.age / 2 % 2)));
                if (this.spawnAnimationTime != 0) {
                    --this.spawnAnimationTime;
                    this.x = Mth.lerp((double)((double)this.spawnAnimationTime / (double)this.spawnAnimationLength), (double)this.spawnAnimationEnd.x, (double)this.spawnAnimationStart.x);
                    this.y = Mth.lerp((double)((double)this.spawnAnimationTime / (double)this.spawnAnimationLength), (double)this.spawnAnimationEnd.y, (double)this.spawnAnimationStart.y);
                    this.z = Mth.lerp((double)((double)this.spawnAnimationTime / (double)this.spawnAnimationLength), (double)this.spawnAnimationEnd.z, (double)this.spawnAnimationStart.z);
                    this.quadSize = Mth.lerp((float)((float)this.spawnAnimationTime / (float)this.spawnAnimationLength), (float)0.5f, (float)0.0f);
                    break;
                }
                this.setBehaviour(Behaviour.PERCHED);
                break;
            }
            case 1: {
                if ((double)this.random.nextFloat() < 0.01) {
                    this.setBehaviour(Behaviour.CHECKING);
                }
                this.setSprite(Util.getSprite("crow_" + this.getRelativeDirection()));
                this.reactToDisturbances();
                break;
            }
            case 2: {
                if ((double)this.random.nextFloat() < 0.02) {
                    this.setBehaviour(Behaviour.PERCHED);
                }
                this.setSprite(Util.getSprite("crow_checking_" + this.getRelativeDirection()));
                this.reactToDisturbances();
                break;
            }
            case 3: {
                this.setSprite(Util.getSprite("crow_flying_%s_%d".formatted(this.getRelativeDirection(), this.age / 2 % 2)));
                this.quadSize = Mth.lerp((float)((float)this.age / (float)this.lifetime), (float)0.5f, (float)0.0f);
                this.xd = this.facing.x;
                this.yd = this.facing.y;
                this.zd = this.facing.z;
            }
        }
    }

    private static enum Behaviour {
        SPAWNING,
        PERCHED,
        CHECKING,
        FLY_UP_AWAY_TO_THE_SUN_LIKE_A_FEATHERY_PIECE_OF_GARGBAGE;

    }

    public static class Provider
    extends CritterParticle.CritterProvider {
        public Provider(SpriteSet spriteSet) {
            super(spriteSet);
        }

        @Override
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new BirdParticle(level, x, y, z, velocityX, velocityY, velocityZ);
        }
    }
}

