/*
 * Decompiled with CFR 0.152.
 */
package pigcart.cosycritters;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pigcart.cosycritters.Util;
import pigcart.cosycritters.config.ConfigManager;
import pigcart.cosycritters.config.ConfigScreens;
import pigcart.cosycritters.mixin.access.ParticleEngineAccessor;

public class CosyCritters {
    public static final String MOD_ID = "cosycritters";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"cosycritters");
    public static SimpleParticleType BIRD;
    public static SimpleParticleType HAT_MAN;
    public static SimpleParticleType MOTH;
    public static SimpleParticleType SPIDER;
    private static boolean wasSleeping;

    private static List<String> getDebugStrings() {
        return List.of(String.format("Birds: %d/%d", Util.getCount(ConfigManager.birdGroup), Util.getLimit(ConfigManager.birdGroup)), String.format("Moths: %d/%d", Util.getCount(ConfigManager.mothGroup), Util.getLimit(ConfigManager.mothGroup)), String.format("Spiders: %d/%d", Util.getCount(ConfigManager.spiderGroup), Util.getLimit(ConfigManager.spiderGroup)), "Tracked: " + ((ParticleEngineAccessor)Minecraft.getInstance().particleEngine).getTrackedParticleCounts().toString());
    }

    public static void onInitializeClient() {
        ConfigManager.loadConfig();
    }

    public static <S> LiteralArgumentBuilder<S> getCommands() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)MOD_ID).executes(ctx -> {
            Util.schedule(() -> Minecraft.getInstance().setScreen(ConfigScreens.generateMainConfigScreen(null)));
            return 0;
        })).then(LiteralArgumentBuilder.literal((String)"debug").executes(ctx -> {
            CosyCritters.getDebugStrings().forEach(Util::addChatMsg);
            return 0;
        }));
    }

    public static void doAnimateTick(BlockPos blockPos, BlockState state) {
        CosyCritters.trySpawnMoth((Level)Minecraft.getInstance().level, blockPos);
    }

    public static void onTick(Minecraft minecraft) {
        if (minecraft.player != null) {
            CosyCritters.tickHatManSpawnConditions(minecraft);
        }
    }

    private static void tickHatManSpawnConditions(Minecraft minecraft) {
        if (minecraft.level.dimensionType().moonPhase(minecraft.level.dayTime()) == 4) {
            if (minecraft.player.isSleeping()) {
                if (!wasSleeping) {
                    CosyCritters.trySpawnHatman(minecraft);
                    wasSleeping = true;
                }
            } else if (wasSleeping) {
                wasSleeping = false;
            }
        }
    }

    private static void trySpawnHatman(Minecraft minecraft) {
        EnumProperty property;
        BlockState state;
        if (!ConfigManager.config.spawnHatman) {
            return;
        }
        Optional sleepingPos = minecraft.player.getSleepingPos();
        if (sleepingPos.isPresent() && (state = minecraft.level.getBlockState((BlockPos)sleepingPos.get())).hasProperty((Property)(property = BlockStateProperties.HORIZONTAL_FACING))) {
            Direction direction = (Direction)state.getValue((Property)property);
            BlockPos blockPos = BlockPos.containing((Position)minecraft.player.position()).relative(direction.getOpposite(), 2);
            Vec3 pos = blockPos.getCenter();
            RandomSource random = minecraft.player.getRandom();
            Vec3 randomPos = new Vec3(pos.x + (double)random.nextInt(2) - 1.0, pos.y, pos.z + (double)random.nextInt(2) - 1.0);
            if (minecraft.level.getBlockState(BlockPos.containing((Position)randomPos)).isAir()) {
                minecraft.particleEngine.createParticle((ParticleOptions)HAT_MAN, randomPos.x, randomPos.y + 0.5, randomPos.z, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void trySpawnBird(BlockState state, Level level, BlockPos blockPos) {
        if (ConfigManager.config.spawnBird && Util.isDay(level) && Util.hasSpace(ConfigManager.birdGroup) && level.getBlockState(blockPos.above()).isAir() && !Minecraft.getInstance().player.position().closerThan((Position)blockPos.getCenter(), (double)ConfigManager.config.birdReactionDistance)) {
            Vec3 pos = blockPos.getCenter();
            BlockHitResult hitResult = state.getCollisionShape((BlockGetter)level, blockPos).clip(pos.add(0.0, 2.0, 0.0), pos.add(0.0, -0.6, 0.0), blockPos);
            if (hitResult == null) {
                return;
            }
            pos = hitResult.getLocation();
            Vec3 spawnFrom = pos.add((double)(level.random.nextInt(10) - 5), (double)level.random.nextInt(5), (double)(level.random.nextInt(10) - 5));
            if (Util.isExposed(level, (int)spawnFrom.x, (int)spawnFrom.y, (int)spawnFrom.z) && level.clip(Util.getClipContext(spawnFrom, pos)).getType().equals((Object)HitResult.Type.MISS)) {
                level.addParticle((ParticleOptions)BIRD, spawnFrom.x, spawnFrom.y, spawnFrom.z, pos.x, pos.y, pos.z);
            }
        }
    }

    public static void trySpawnMoth(Level level, BlockPos blockPos) {
        if (ConfigManager.config.spawnMoth && Util.hasSpace(ConfigManager.mothGroup) && !Util.isDay(level) && level.getBrightness(LightLayer.BLOCK, blockPos) > 13 && Util.isExposed(level, blockPos.getX(), blockPos.getY(), blockPos.getZ())) {
            level.addParticle((ParticleOptions)MOTH, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), 0.0, 0.0, 0.0);
        }
    }

    public static void trySpawnSpider(Level level, BlockPos blockPos) {
        if (ConfigManager.config.spawnSpider && Util.hasSpace(ConfigManager.spiderGroup) && !Minecraft.getInstance().player.position().closerThan((Position)blockPos.getCenter(), 2.0)) {
            if (Minecraft.getInstance().player.position().closerThan((Position)blockPos.getCenter(), 2.0)) {
                return;
            }
            Direction direction = Direction.getRandom((RandomSource)level.random);
            BlockState state = level.getBlockState(blockPos = blockPos.relative(direction));
            if (state.isFaceSturdy((BlockGetter)level, blockPos, direction.getOpposite())) {
                Vec3 spawnPos = blockPos.getCenter().add(new Vec3(direction.step()).multiply((double)-0.6f, (double)-0.6f, (double)-0.6f));
                level.addParticle((ParticleOptions)SPIDER, spawnPos.x, spawnPos.y, spawnPos.z, (double)direction.get3DDataValue(), 0.0, 0.0);
            }
        }
    }

    static {
        wasSleeping = false;
    }
}

