/*
 * Decompiled with CFR 0.152.
 */
package pigcart.cosycritters;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import pigcart.cosycritters.mixin.access.ParticleEngineAccessor;

public class Util {
    public static ResourceLocation getId(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"cosycritters", (String)path);
    }

    public static ClipContext getClipContext(Vec3 clipStart, Vec3 clipEnd) {
        return new ClipContext(clipStart, clipEnd, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, Util.getCollisionContext());
    }

    public static CollisionContext getCollisionContext() {
        return CollisionContext.empty();
    }

    public static TextureAtlasSprite getSprite(String path) {
        return ((ParticleEngineAccessor)Minecraft.getInstance().particleEngine).getTextureAtlas().getSprite(Util.getId(path));
    }

    public static void schedule(Runnable task) {
        Minecraft.getInstance().schedule(task);
    }

    public static boolean isDay(Level level) {
        return level.dayTime() % 24000L < 13000L;
    }

    public static void addChatMsg(String message) {
        Minecraft.getInstance().gui.getChat().addMessage((Component)Component.literal((String)message));
    }

    public static boolean isExposed(Level level, int x, int y, int z) {
        return level.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z) <= y;
    }

    public static boolean hasSpace(ParticleGroup group) {
        return ((ParticleEngineAccessor)Minecraft.getInstance().particleEngine).callHasSpaceInParticleLimit(group);
    }

    public static int getCount(ParticleGroup group) {
        return ((ParticleEngineAccessor)Minecraft.getInstance().particleEngine).getTrackedParticleCounts().getInt((Object)group);
    }

    public static int getLimit(ParticleGroup group) {
        return group.getLimit();
    }

    public static Vec3 getCameraPos() {
        return Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
    }
}

