/*
 * Decompiled with CFR 0.152.
 */
package pigcart.cosycritters.particle;

import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import pigcart.cosycritters.Util;
import pigcart.cosycritters.config.ConfigManager;
import pigcart.cosycritters.particle.ComplexCritterParticle;
import pigcart.cosycritters.particle.CritterParticle;

public class SpiderParticle
extends ComplexCritterParticle {
    boolean clockwise;
    BlockPos blockPos;
    Direction direction;
    float speed;
    Vec3 oldPosition;

    private SpiderParticle(ClientLevel level, double x, double y, double z, int direction3DDataValue) {
        super(level, x, y, z, Util.getSprite("spider_crawling_0"));
        this.f_107663_ = this.f_107223_.m_188501_() * 0.1f + 0.05f;
        this.speed = this.f_107663_ / 2.0f;
        this.f_107231_ = (float)Math.PI * 2 * this.f_107223_.m_188501_();
        this.f_107225_ = 500 + this.f_107223_.m_188503_(50);
        this.clockwise = this.f_107223_.m_188499_();
        this.blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        this.direction = Direction.m_122376_((int)direction3DDataValue);
        this.oldPosition = new Vec3(x, y, z);
        this.f_107219_ = false;
    }

    public Optional<ParticleGroup> m_142654_() {
        return Optional.of(ConfigManager.spiderGroup);
    }

    public void m_5989_() {
        Vec3 to;
        BlockHitResult hitResult;
        super.m_5989_();
        this.m_108337_(Util.getSprite("spider_crawling_" + this.f_107224_ % 2));
        if (!Util.getCameraPos().m_82509_((Position)new Vec3(this.f_107212_, this.f_107213_, this.f_107214_), 32.0)) {
            this.m_107274_();
        }
        Vec3 from = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        if (this.f_107224_ % 20 == 0) {
            if (this.oldPosition.m_82509_((Position)from, 0.05)) {
                this.m_107274_();
            } else {
                this.oldPosition = from;
            }
        }
        this.f_107204_ = this.f_107231_;
        this.f_107231_ += this.clockwise ? this.speed : -this.speed;
        if (!this.blockPos.equals((Object)BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_))) {
            if (!this.f_107208_.m_6425_(BlockPos.m_274446_((Position)from)).m_76178_()) {
                this.m_107274_();
            }
            this.blockPos = BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
            this.clockwise = this.f_107223_.m_188499_();
        }
        if ((hitResult = this.f_107208_.m_45547_(new ClipContext(from, to = from.m_82549_(new Vec3(this.f_107215_, this.f_107216_, this.f_107217_).m_82541_().m_82542_((double)(this.f_107663_ / 2.0f), (double)(this.f_107663_ / 2.0f), (double)(this.f_107663_ / 2.0f))), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, Util.getCollisionContext()))).m_6662_().equals((Object)HitResult.Type.BLOCK)) {
            Direction oldDirection = this.direction;
            this.direction = hitResult.m_82434_().m_122424_();
            if (oldDirection.m_122434_() == Direction.Axis.Y) {
                if (this.direction.equals((Object)Direction.SOUTH)) {
                    this.f_107231_ = 4.712389f;
                } else if (this.direction.equals((Object)Direction.EAST)) {
                    this.f_107231_ = (float)Math.PI;
                } else if (this.direction.equals((Object)Direction.NORTH)) {
                    this.f_107231_ = (float)Math.PI * 2;
                } else if (this.direction.equals((Object)Direction.WEST)) {
                    this.f_107231_ = 1.5707964f;
                }
                if (oldDirection.equals((Object)Direction.UP)) {
                    this.f_107231_ += (float)Math.PI;
                }
            } else if (oldDirection.m_122434_() == Direction.Axis.X) {
                if (this.direction.equals((Object)Direction.SOUTH)) {
                    this.f_107231_ = (float)Math.PI;
                } else if (this.direction.equals((Object)Direction.UP)) {
                    this.f_107231_ = 4.712389f;
                } else if (this.direction.equals((Object)Direction.NORTH)) {
                    this.f_107231_ = 1.5707964f;
                } else if (this.direction.equals((Object)Direction.DOWN)) {
                    this.f_107231_ = (float)Math.PI * 2;
                }
                if (oldDirection.equals((Object)Direction.WEST)) {
                    this.f_107231_ += (float)Math.PI;
                }
            } else if (oldDirection.m_122434_() == Direction.Axis.Z) {
                if (this.direction.equals((Object)Direction.EAST)) {
                    this.f_107231_ = 1.5707964f;
                } else if (this.direction.equals((Object)Direction.UP)) {
                    this.f_107231_ = (float)Math.PI;
                } else if (this.direction.equals((Object)Direction.WEST)) {
                    this.f_107231_ = (float)Math.PI;
                } else if (this.direction.equals((Object)Direction.DOWN)) {
                    this.f_107231_ = 1.5707964f;
                }
                if (oldDirection.equals((Object)Direction.SOUTH)) {
                    this.f_107231_ += (float)Math.PI;
                }
            }
        } else {
            to = from.m_82549_(new Vec3(this.direction.m_253071_()).m_82542_(0.2, 0.2, 0.2));
            hitResult = this.f_107208_.m_45547_(new ClipContext(from, to, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, Util.getCollisionContext()));
            if (hitResult.m_6662_().equals((Object)HitResult.Type.MISS)) {
                to = from.m_82549_(new Vec3(this.direction.m_253071_()).m_82542_(0.5, 0.5, 0.5)).m_82549_(new Vec3(-this.f_107215_, -this.f_107216_, -this.f_107217_).m_82541_().m_82542_(0.5, 0.5, 0.5));
                hitResult = this.f_107208_.m_45547_(new ClipContext(from, to, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, Util.getCollisionContext()));
                if (hitResult.m_6662_().equals((Object)HitResult.Type.BLOCK)) {
                    if (this.direction != hitResult.m_82434_().m_122424_()) {
                        Direction oldDirection = this.direction;
                        this.direction = hitResult.m_82434_().m_122424_();
                        if (oldDirection.m_122434_() == Direction.Axis.Y) {
                            if (this.direction.equals((Object)Direction.SOUTH)) {
                                this.f_107231_ = 4.712389f;
                            } else if (this.direction.equals((Object)Direction.EAST)) {
                                this.f_107231_ = (float)Math.PI;
                            } else if (this.direction.equals((Object)Direction.NORTH)) {
                                this.f_107231_ = (float)Math.PI * 2;
                            } else if (this.direction.equals((Object)Direction.WEST)) {
                                this.f_107231_ = 1.5707964f;
                            }
                            if (oldDirection.equals((Object)Direction.DOWN)) {
                                this.f_107231_ += (float)Math.PI;
                            }
                        } else if (oldDirection.m_122434_() == Direction.Axis.X) {
                            if (this.direction.equals((Object)Direction.SOUTH)) {
                                this.f_107231_ = (float)Math.PI;
                            } else if (this.direction.equals((Object)Direction.UP)) {
                                this.f_107231_ = 4.712389f;
                            } else if (this.direction.equals((Object)Direction.NORTH)) {
                                this.f_107231_ = 1.5707964f;
                            } else if (this.direction.equals((Object)Direction.DOWN)) {
                                this.f_107231_ = (float)Math.PI * 2;
                            }
                            if (oldDirection.equals((Object)Direction.EAST)) {
                                this.f_107231_ += (float)Math.PI;
                            }
                        } else if (oldDirection.m_122434_() == Direction.Axis.Z) {
                            if (this.direction.equals((Object)Direction.EAST)) {
                                this.f_107231_ = 1.5707964f;
                            } else if (this.direction.equals((Object)Direction.UP)) {
                                this.f_107231_ = (float)Math.PI;
                            } else if (this.direction.equals((Object)Direction.WEST)) {
                                this.f_107231_ = (float)Math.PI;
                            } else if (this.direction.equals((Object)Direction.DOWN)) {
                                this.f_107231_ = 1.5707964f;
                            }
                            if (oldDirection.equals((Object)Direction.NORTH)) {
                                this.f_107231_ += (float)Math.PI;
                            }
                        }
                    }
                } else {
                    this.m_107274_();
                }
            }
        }
        switch (this.direction) {
            case DOWN: {
                this.f_107215_ = Mth.m_14089_((float)this.f_107231_) * -this.speed;
                this.f_107217_ = Mth.m_14031_((float)this.f_107231_) * this.speed;
                this.f_107216_ = 0.0;
                break;
            }
            case UP: {
                this.f_107215_ = Mth.m_14031_((float)this.f_107231_) * this.speed;
                this.f_107217_ = Mth.m_14089_((float)this.f_107231_) * -this.speed;
                this.f_107216_ = 0.0;
                break;
            }
            case NORTH: {
                this.f_107215_ = Mth.m_14031_((float)this.f_107231_) * -this.speed;
                this.f_107216_ = Mth.m_14089_((float)this.f_107231_) * this.speed;
                this.f_107217_ = 0.0;
                break;
            }
            case SOUTH: {
                this.f_107215_ = Mth.m_14089_((float)this.f_107231_) * this.speed;
                this.f_107216_ = Mth.m_14031_((float)this.f_107231_) * -this.speed;
                this.f_107217_ = 0.0;
                break;
            }
            case WEST: {
                this.f_107216_ = Mth.m_14031_((float)this.f_107231_) * this.speed;
                this.f_107217_ = Mth.m_14089_((float)this.f_107231_) * -this.speed;
                this.f_107215_ = 0.0;
                break;
            }
            case EAST: {
                this.f_107216_ = Mth.m_14089_((float)this.f_107231_) * -this.speed;
                this.f_107217_ = Mth.m_14031_((float)this.f_107231_) * this.speed;
                this.f_107215_ = 0.0;
            }
        }
    }

    @Override
    public <T> void renderCustom(T renderInfo, Camera camera, float tickPercent) {
        float x = (float)(Mth.m_14139_((double)tickPercent, (double)this.f_107209_, (double)this.f_107212_) - camera.m_90583_().m_7096_());
        float y = (float)(Mth.m_14139_((double)tickPercent, (double)this.f_107210_, (double)this.f_107213_) - camera.m_90583_().m_7098_());
        float z = (float)(Mth.m_14139_((double)tickPercent, (double)this.f_107211_, (double)this.f_107214_) - camera.m_90583_().m_7094_());
        Quaternionf quaternionf = switch (this.direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> new Quaternionf(new AxisAngle4f(1.5707964f, -1.0f, 0.0f, 0.0f));
            case Direction.UP -> new Quaternionf(new AxisAngle4f(1.5707964f, 1.0f, 0.0f, 0.0f)).rotateZ(1.5707964f);
            case Direction.WEST -> new Quaternionf(new AxisAngle4f(1.5707964f, 0.0f, 1.0f, 0.0f)).rotateZ((float)Math.PI);
            case Direction.EAST -> new Quaternionf(new AxisAngle4f(1.5707964f, 0.0f, -1.0f, 0.0f)).rotateZ(1.5707964f);
            case Direction.NORTH -> new Quaternionf(new AxisAngle4f(1.5707964f, 0.0f, 0.0f, -1.0f));
            case Direction.SOUTH -> new Quaternionf(new AxisAngle4f((float)Math.PI, 0.0f, 1.0f, 0.0f));
        };
        quaternionf.rotateZ(Mth.m_14179_((float)tickPercent, (float)this.f_107204_, (float)this.f_107231_));
        this.renderCustomQuad(renderInfo, quaternionf, x, y, z, tickPercent);
    }

    public static class Provider
    extends CritterParticle.CritterProvider {
        public Provider(SpriteSet spriteSet) {
            super(spriteSet);
        }

        @Override
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new SpiderParticle(level, x, y, z, (int)velocityX);
        }
    }
}

