/*
 * Decompiled with CFR 0.152.
 */
package tomeko.legacyskyblock.dungeons;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import tomeko.legacyskyblock.config.LegacySkyblockConfig;
import tomeko.legacyskyblock.utils.HypixelPackets;

public class AutoRefill {
    private static String lastServerName = "";
    private static boolean shouldScanInventory = false;
    private static int GFSTickDelay = 0;
    private static final Queue<String> GFSQueue = new LinkedList<String>();
    private static int scanTickDelay = 0;
    private static int scanBlockTime = 0;

    public static void register() {
        ClientTickEvents.END_CLIENT_TICK.register(AutoRefill::manageRefill);
        ClientTickEvents.END_CLIENT_TICK.register(AutoRefill::manageGFS);
        ClientTickEvents.END_CLIENT_TICK.register(AutoRefill::scanInventory);
    }

    private static void manageRefill(class_310 client) {
        if (!HypixelPackets.inDungeons || lastServerName.equals(HypixelPackets.currentServerName)) {
            return;
        }
        lastServerName = HypixelPackets.currentServerName;
        shouldScanInventory = true;
        GFSTickDelay = 80;
        scanTickDelay = 20;
    }

    private static void scanInventory(class_310 client) {
        if (!shouldScanInventory || client.field_1724 == null) {
            return;
        }
        if (scanTickDelay > 0) {
            --scanTickDelay;
            return;
        }
        class_1661 inventory = client.field_1724.method_31548();
        if (inventory == null) {
            return;
        }
        if (++scanBlockTime > 1000) {
            scanBlockTime = 0;
            shouldScanInventory = false;
            return;
        }
        int[] refillCounter = new int[LegacySkyblockConfig.refillItems.length];
        Arrays.fill(refillCounter, 0);
        for (class_1799 stack : inventory) {
            if (stack.method_7960()) continue;
            shouldScanInventory = false;
            for (int i = 0; i < LegacySkyblockConfig.refillItems.length; ++i) {
                if (!stack.method_7964().getString().equals(LegacySkyblockConfig.refillItems[i].name)) continue;
                int n = i;
                refillCounter[n] = refillCounter[n] + stack.method_7947();
            }
        }
        if (shouldScanInventory) {
            return;
        }
        if (scanTickDelay > 0) {
            shouldScanInventory = true;
            --scanTickDelay;
            return;
        }
        for (int i = 0; i < LegacySkyblockConfig.refillItems.length; ++i) {
            if (!LegacySkyblockConfig.refillEnabled.get(LegacySkyblockConfig.refillItems[i].id).booleanValue() || LegacySkyblockConfig.refillItems[i].maxStackSize - refillCounter[i] <= 0) continue;
            GFSQueue.add("gfs " + LegacySkyblockConfig.refillItems[i].id + " " + (LegacySkyblockConfig.refillItems[i].maxStackSize - refillCounter[i]));
        }
    }

    private static void manageGFS(class_310 client) {
        if (GFSTickDelay > 0) {
            --GFSTickDelay;
            return;
        }
        if (GFSQueue.isEmpty() || client.field_1724 == null) {
            return;
        }
        client.field_1724.field_3944.method_45730(GFSQueue.peek());
        GFSQueue.poll();
        GFSTickDelay = 40;
    }
}

