/*
 * Decompiled with CFR 0.152.
 */
package tomeko.legacyskyblock.hud.vanillahud;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientSendMessageEvents;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import tomeko.legacyskyblock.config.LegacySkyblockConfig;
import tomeko.legacyskyblock.utils.HypixelPackets;

public class Chat {
    private static boolean guildMOTD = false;
    private static final List<AbstractMap.SimpleEntry<String, String>> EMOTES = new ArrayList<AbstractMap.SimpleEntry<String, String>>();

    public static void register() {
        ClientReceiveMessageEvents.ALLOW_GAME.register((message, fromActionBar) -> {
            if (fromActionBar || message == null) {
                return true;
            }
            String unformattedMessage = Chat.removeFormatting(message.getString());
            if (LegacySkyblockConfig.hideGuildMOTDEnabled) {
                if (unformattedMessage.startsWith("--------------  Guild: Message Of The Day  --------------")) {
                    guildMOTD = true;
                }
                if (guildMOTD) {
                    if (unformattedMessage.endsWith("-----------------------------------------------------")) {
                        guildMOTD = false;
                    }
                    return false;
                }
            }
            for (String messageToHide : LegacySkyblockConfig.customChatMessagesToHide) {
                if (messageToHide.isEmpty() || !unformattedMessage.contains(messageToHide)) continue;
                return false;
            }
            return true;
        });
        ClientReceiveMessageEvents.MODIFY_GAME.register((message, fromActionBar) -> {
            if (fromActionBar || message == null) {
                return message;
            }
            if (LegacySkyblockConfig.whitePrivateMessagesEnabled && HypixelPackets.onHypixel && (message.getString().startsWith("From ") || message.getString().startsWith("To "))) {
                class_5250 newMessage = message.method_27662().method_27692(class_124.field_1076);
                int n = message.method_10855().size();
                if (n < 1) {
                    return message;
                }
                boolean semicolonPassed = false;
                for (int i = 0; i < n - 1; ++i) {
                    if (!semicolonPassed && ((class_2561)message.method_10855().get(i)).getString().contains(":")) {
                        String sibling = ((class_2561)message.method_10855().get(i)).getString();
                        int colonIndex = sibling.indexOf(":");
                        if (colonIndex > 0) {
                            newMessage.method_10852((class_2561)class_2561.method_43470((String)sibling.substring(0, colonIndex)).method_10862(((class_2561)message.method_10855().get(i)).method_10866()));
                        }
                        newMessage.method_10852((class_2561)class_2561.method_43470((String)":").method_27692(class_124.field_1068));
                        if (colonIndex + 1 <= sibling.length() - 1) {
                            newMessage.method_10852((class_2561)class_2561.method_43470((String)sibling.substring(colonIndex + 1)).method_10862(((class_2561)message.method_10855().get(i)).method_10866()));
                        }
                        semicolonPassed = true;
                        continue;
                    }
                    newMessage.method_10852((class_2561)message.method_10855().get(i));
                }
                if (!semicolonPassed) {
                    return message;
                }
                newMessage.method_10852((class_2561)((class_2561)message.method_10855().get(n - 1)).method_27661().method_27692(class_124.field_1068));
                return newMessage;
            }
            if (LegacySkyblockConfig.whiteNoRankMessagesEnabled && HypixelPackets.onHypixel && message.getString().contains("\u00a77: ")) {
                return class_2561.method_30163((String)message.getString().replace("\u00a77: ", "\u00a7f: "));
            }
            return message;
        });
        ClientSendMessageEvents.MODIFY_CHAT.register(message -> {
            if (LegacySkyblockConfig.MVPEmotesEnabled) {
                return Chat.replaceEmotes(message);
            }
            return message;
        });
        ClientSendMessageEvents.MODIFY_COMMAND.register(command -> {
            if (LegacySkyblockConfig.MVPEmotesEnabled) {
                String[] words = command.split(" ");
                StringBuilder newCommand = new StringBuilder(words[0]);
                for (int i = 1; i < words.length; ++i) {
                    newCommand.append(" ").append(Chat.replaceEmotes(words[i]));
                }
                return newCommand.toString();
            }
            return command;
        });
    }

    private static String removeFormatting(String string) {
        return string.replaceAll("\u00a7.", "");
    }

    private static String replaceEmotes(String message) {
        for (AbstractMap.SimpleEntry<String, String> entry : EMOTES) {
            message = message.replace(entry.getKey(), entry.getValue());
        }
        return message;
    }

    static {
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>("<3", "\u2764"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":arrow:", "\u279c"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":bum:", "\u267f"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":cat:", "= \uff3e\u25cf \u22cf \u25cf\uff3e ="));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":cute:", "(\u273f\u25e0\u203f\u25e0)"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":dab:", "<o/"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":dj:", "\u30fd(\u2310\u25a0_\u25a0)\u30ce\u266c"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":dog:", "(\u1d54\u1d25\u1d54)"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":gimme:", "\u0f3c\u3064\u25d5_\u25d5\u0f3d\u3064"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":java:", "\u2615"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":maths:", "\u221a(\u03c0+x)=L"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":no:", "\u2716"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":peace:", "\u270c"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":puffer:", "<('O')>"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":pvp:", "\u2694"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":shrug:", "\u00af\\_(\u30c4)_/\u00af"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":skull:", "\u2620"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":sloth:", "(\u30fb\u229d\u30fb)"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":snail:", "@'-'"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":snow:", "\u2603"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":star:", "\u272e"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":tableflip:", "(\u256f\u00b0\u25a1\u00b0\uff09\u256f\ufe35 \u253b\u2501\u253b"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":thinking:", "(0.o?)"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":totem:", "\u2609_\u2609"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":typing:", "\u270e..."));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":wizard:", "('-')\u2283\u2501\u2606\uff9f.*\uff65\uff61\uff9f"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":yes:", "\u2714"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>(":yey:", "\u30fd (\u25d5\u25e1\u25d5) \uff89"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>("ez", "\uff45\uff5a"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>("h/", "\u30fd(^\u25c7^*)/"));
        EMOTES.add(new AbstractMap.SimpleEntry<String, String>("o/", "( \uff9f\u25e1\uff9f)/"));
    }
}

