/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage;

import com.google.common.base.CaseFormat;
import com.mojang.logging.LogUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import net.mrqx.huajiage.client.renderer.entity.RenderFivePower;
import net.mrqx.huajiage.client.renderer.entity.RenderHeroArrow;
import net.mrqx.huajiage.client.renderer.entity.RenderItemBullet;
import net.mrqx.huajiage.client.renderer.entity.RenderMultiKnife;
import net.mrqx.huajiage.client.renderer.entity.RenderOrgaHairKnife;
import net.mrqx.huajiage.client.renderer.entity.RenderRoadRoller;
import net.mrqx.huajiage.client.renderer.entity.RenderSheerHeartAttack;
import net.mrqx.huajiage.compat.HuaJiCompat;
import net.mrqx.huajiage.config.HuaJiClientConfig;
import net.mrqx.huajiage.config.HuaJiCommonConfig;
import net.mrqx.huajiage.data.loot.RandomNbtFunction;
import net.mrqx.huajiage.entity.EntityFivePower;
import net.mrqx.huajiage.entity.EntityHeroArrow;
import net.mrqx.huajiage.entity.EntityItemBullet;
import net.mrqx.huajiage.entity.EntityMultiKnife;
import net.mrqx.huajiage.entity.EntityOrgaHairKnife;
import net.mrqx.huajiage.entity.EntityRoadRoller;
import net.mrqx.huajiage.entity.EntitySheerHeartAttack;
import net.mrqx.huajiage.network.NetworkManager;
import net.mrqx.huajiage.registy.HuaJiBlocks;
import net.mrqx.huajiage.registy.HuaJiCreativeTabs;
import net.mrqx.huajiage.registy.HuaJiEffects;
import net.mrqx.huajiage.registy.HuaJiItems;
import net.mrqx.huajiage.registy.HuaJiMenus;
import net.mrqx.huajiage.registy.HuaJiRecipes;
import net.mrqx.huajiage.registy.HuaJiSoundEvents;
import net.mrqx.huajiage.registy.HuaJiStands;
import org.slf4j.Logger;

@Mod(value="huajiage")
public class HuaJiAgeMod {
    public static final String MODID = "huajiage";
    public static final Logger LOGGER = LogUtils.getLogger();

    public static ResourceLocation prefix(String s) {
        return new ResourceLocation(MODID, s);
    }

    public HuaJiAgeMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        HuaJiItems.ITEMS.register(modEventBus);
        HuaJiBlocks.BLOCKS.register(modEventBus);
        HuaJiBlocks.BLOCK_ENTITIES.register(modEventBus);
        HuaJiCreativeTabs.CREATIVE_MODE_TABS.register(modEventBus);
        HuaJiEffects.MOB_EFFECTS.register(modEventBus);
        HuaJiMenus.CONTAINER_TYPES.register(modEventBus);
        HuaJiRecipes.RECIPE_TYPES.register(modEventBus);
        HuaJiRecipes.RECIPE_SERIALIZER.register(modEventBus);
        HuaJiSoundEvents.SOUND_EVENTS.register(modEventBus);
        HuaJiStands.STANDS.register(modEventBus);
        NetworkManager.register();
        HuaJiCompat.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)HuaJiCommonConfig.COMMON_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)HuaJiClientConfig.CLIENT_CONFIG);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        public static final ResourceLocation ENTITY_HERO_ARROW_RESOURCE_LOCATION = HuaJiAgeMod.prefix(RegistryEvents.classToString(EntityHeroArrow.class));
        public static final ResourceLocation ENTITY_ITEM_BULLET_RESOURCE_LOCATION = HuaJiAgeMod.prefix(RegistryEvents.classToString(EntityItemBullet.class));
        public static final ResourceLocation ENTITY_ROAD_ROLLER_RESOURCE_LOCATION = HuaJiAgeMod.prefix(RegistryEvents.classToString(EntityRoadRoller.class));
        public static final ResourceLocation ENTITY_FIVE_POWER_RESOURCE_LOCATION = HuaJiAgeMod.prefix(RegistryEvents.classToString(EntityFivePower.class));
        public static final ResourceLocation ENTITY_ORGA_HAIR_KNIFE_RESOURCE_LOCATION = HuaJiAgeMod.prefix(RegistryEvents.classToString(EntityOrgaHairKnife.class));
        public static final ResourceLocation ENTITY_SHEER_HEART_ATTACK_RESOURCE_LOCATION = HuaJiAgeMod.prefix(RegistryEvents.classToString(EntitySheerHeartAttack.class));
        public static final ResourceLocation ENTITY_MULTI_KNIFE_RESOURCE_LOCATION = HuaJiAgeMod.prefix(RegistryEvents.classToString(EntityMultiKnife.class));
        public static EntityType<EntityHeroArrow> heroArrowEntityType;
        public static EntityType<EntityItemBullet> itemBulletEntityType;
        public static EntityType<EntityRoadRoller> roadRollerEntityType;
        public static EntityType<EntityFivePower> fivePowerEntityType;
        public static EntityType<EntityOrgaHairKnife> orgaHairKnifeEntityType;
        public static EntityType<EntitySheerHeartAttack> sheerHeartAttackEntityType;
        public static EntityType<EntityMultiKnife> multiKnifeEntityType;

        @SubscribeEvent
        public static void register(RegisterEvent event) {
            event.register(ForgeRegistries.Keys.ENTITY_TYPES, entityTypeRegisterHelper -> {
                heroArrowEntityType = EntityType.Builder.m_20704_(EntityHeroArrow::create, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setTrackingRange(8).setUpdateInterval(3).setCustomClientFactory(EntityHeroArrow::createInstance).m_20712_(ENTITY_HERO_ARROW_RESOURCE_LOCATION.toString());
                entityTypeRegisterHelper.register(ENTITY_HERO_ARROW_RESOURCE_LOCATION, heroArrowEntityType);
                itemBulletEntityType = EntityType.Builder.m_20704_(EntityItemBullet::create, (MobCategory)MobCategory.MISC).m_20699_(0.2f, 0.2f).setTrackingRange(8).setUpdateInterval(3).setCustomClientFactory(EntityItemBullet::createInstance).m_20712_(ENTITY_ITEM_BULLET_RESOURCE_LOCATION.toString());
                entityTypeRegisterHelper.register(ENTITY_ITEM_BULLET_RESOURCE_LOCATION, itemBulletEntityType);
                roadRollerEntityType = EntityType.Builder.m_20704_(EntityRoadRoller::create, (MobCategory)MobCategory.MISC).m_20699_(2.0f, 2.0f).setTrackingRange(8).setUpdateInterval(3).setCustomClientFactory(EntityRoadRoller::createInstance).m_20712_(ENTITY_ROAD_ROLLER_RESOURCE_LOCATION.toString());
                entityTypeRegisterHelper.register(ENTITY_ROAD_ROLLER_RESOURCE_LOCATION, roadRollerEntityType);
                fivePowerEntityType = EntityType.Builder.m_20704_(EntityFivePower::create, (MobCategory)MobCategory.MISC).m_20699_(0.7f, 0.7f).setTrackingRange(8).setUpdateInterval(3).setCustomClientFactory(EntityFivePower::createInstance).m_20712_(ENTITY_FIVE_POWER_RESOURCE_LOCATION.toString());
                entityTypeRegisterHelper.register(ENTITY_FIVE_POWER_RESOURCE_LOCATION, fivePowerEntityType);
                orgaHairKnifeEntityType = EntityType.Builder.m_20704_(EntityOrgaHairKnife::create, (MobCategory)MobCategory.MISC).m_20699_(0.7f, 0.7f).setTrackingRange(8).setUpdateInterval(3).setCustomClientFactory(EntityOrgaHairKnife::createInstance).m_20712_(ENTITY_ORGA_HAIR_KNIFE_RESOURCE_LOCATION.toString());
                entityTypeRegisterHelper.register(ENTITY_ORGA_HAIR_KNIFE_RESOURCE_LOCATION, orgaHairKnifeEntityType);
                sheerHeartAttackEntityType = EntityType.Builder.m_20704_(EntitySheerHeartAttack::create, (MobCategory)MobCategory.MISC).m_20699_(0.6f, 0.8f).setTrackingRange(8).setUpdateInterval(3).setCustomClientFactory(EntitySheerHeartAttack::createInstance).m_20712_(ENTITY_SHEER_HEART_ATTACK_RESOURCE_LOCATION.toString());
                entityTypeRegisterHelper.register(ENTITY_SHEER_HEART_ATTACK_RESOURCE_LOCATION, sheerHeartAttackEntityType);
                multiKnifeEntityType = EntityType.Builder.m_20704_(EntityMultiKnife::create, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setTrackingRange(8).setUpdateInterval(3).setCustomClientFactory(EntityMultiKnife::createInstance).m_20712_(ENTITY_MULTI_KNIFE_RESOURCE_LOCATION.toString());
                entityTypeRegisterHelper.register(ENTITY_MULTI_KNIFE_RESOURCE_LOCATION, multiKnifeEntityType);
            });
        }

        @SubscribeEvent
        public static void onEntityAttributeCreationEvent(EntityAttributeCreationEvent event) {
            event.put(sheerHeartAttackEntityType, EntitySheerHeartAttack.createAttributes().m_22265_());
        }

        @SubscribeEvent
        public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer(heroArrowEntityType, RenderHeroArrow::new);
            event.registerEntityRenderer(itemBulletEntityType, RenderItemBullet::new);
            event.registerEntityRenderer(roadRollerEntityType, RenderRoadRoller::new);
            event.registerEntityRenderer(fivePowerEntityType, RenderFivePower::new);
            event.registerEntityRenderer(orgaHairKnifeEntityType, RenderOrgaHairKnife::new);
            event.registerEntityRenderer(sheerHeartAttackEntityType, RenderSheerHeartAttack::new);
            event.registerEntityRenderer(multiKnifeEntityType, RenderMultiKnife::new);
        }

        @SubscribeEvent
        public static void onCommonSetupEvent(FMLCommonSetupEvent event) {
            event.enqueueWork(RandomNbtFunction::register);
            HuaJiCompat.commonSetup();
        }

        private static String classToString(Class<? extends Entity> entityClass) {
            String entity = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, entityClass.getSimpleName()).replace("entity_", "");
            LOGGER.debug(entity);
            return entity;
        }
    }
}

