/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.block.blockentity;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.mrqx.huajiage.block.BlockHuaJiBlender;
import net.mrqx.huajiage.block.inventory.HuaJiBlenderMenu;
import net.mrqx.huajiage.recipe.HuaJiBlenderRecipe;
import net.mrqx.huajiage.registy.HuaJiBlocks;
import net.mrqx.huajiage.registy.HuaJiMenus;
import net.mrqx.huajiage.registy.HuaJiRecipes;
import net.mrqx.huajiage.utils.HuaJiUtils;
import org.jetbrains.annotations.Nullable;

public class HuaJiBlenderBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeHolder,
StackedContentsCompatible {
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_FUEL = 1;
    protected static final int SLOT_RESULT = 2;
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    public static final int DATA_LIT_TIME = 0;
    public static final int DATA_LIT_DURATION = 1;
    public static final int DATA_COOKING_PROGRESS = 2;
    public static final int DATA_COOKING_TOTAL_TIME = 3;
    public static final int NUM_DATA_VALUES = 4;
    public static final int BURN_TIME_STANDARD = 200;
    public static final String HUAJI_BLENDER_TIME_PREFIX = "huaji_blender/time_";
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    public int litTime;
    public int litDuration;
    public int processingProgress;
    public int processingTotalTime;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int p_58431_) {
            return switch (p_58431_) {
                case 0 -> HuaJiBlenderBlockEntity.this.litTime;
                case 1 -> HuaJiBlenderBlockEntity.this.litDuration;
                case 2 -> HuaJiBlenderBlockEntity.this.processingProgress;
                case 3 -> HuaJiBlenderBlockEntity.this.processingTotalTime;
                default -> 0;
            };
        }

        public void m_8050_(int p_58433_, int p_58434_) {
            switch (p_58433_) {
                case 0: {
                    HuaJiBlenderBlockEntity.this.litTime = p_58434_;
                    break;
                }
                case 1: {
                    HuaJiBlenderBlockEntity.this.litDuration = p_58434_;
                    break;
                }
                case 2: {
                    HuaJiBlenderBlockEntity.this.processingProgress = p_58434_;
                    break;
                }
                case 3: {
                    HuaJiBlenderBlockEntity.this.processingTotalTime = p_58434_;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private final RecipeManager.CachedCheck<Container, HuaJiBlenderRecipe> quickCheck;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public HuaJiBlenderBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)HuaJiBlocks.HUAJI_BLENDER_BLOCK_ENTITY.get(), pPos, pBlockState);
        this.quickCheck = RecipeManager.m_220267_((RecipeType)((RecipeType)HuaJiRecipes.HUAJI_BLENDER_RECIPE_TYPE.get()));
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)pTag, this.items);
        this.litTime = pTag.m_128451_("BurnTime");
        this.processingProgress = pTag.m_128451_("ProcessTime");
        this.processingTotalTime = pTag.m_128451_("ProcessTimeTotal");
        this.litDuration = this.getBurnDuration((ItemStack)this.items.get(1));
        CompoundTag compoundtag = pTag.m_128469_("RecipesUsed");
        for (String s : compoundtag.m_128431_()) {
            this.recipesUsed.put((Object)new ResourceLocation(s), compoundtag.m_128451_(s));
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("BurnTime", this.litTime);
        pTag.m_128405_("ProcessTime", this.processingProgress);
        pTag.m_128405_("ProcessTimeTotal", this.processingTotalTime);
        ContainerHelper.m_18973_((CompoundTag)pTag, this.items);
        CompoundTag compoundtag = new CompoundTag();
        this.recipesUsed.forEach((resourceLocation, integer) -> compoundtag.m_128405_(resourceLocation.toString(), integer.intValue()));
        pTag.m_128365_("RecipesUsed", (Tag)compoundtag);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.huaji_blender");
    }

    protected AbstractContainerMenu m_6555_(int pContainerId, Inventory pInventory) {
        return new HuaJiBlenderMenu((MenuType)HuaJiMenus.HUAJI_BLENDER.get(), pContainerId, pInventory, (Container)this, this.dataAccess);
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, HuaJiBlenderBlockEntity pBlockEntity) {
        boolean shouldWork;
        boolean flag = pBlockEntity.processingProgress > 0;
        boolean hasChanged = false;
        ItemStack fuel = (ItemStack)pBlockEntity.items.get(1);
        boolean hasInput = !((ItemStack)pBlockEntity.items.get(0)).m_41619_();
        boolean hasFuel = !fuel.m_41619_();
        boolean bl = shouldWork = pBlockEntity.isLit() || hasFuel && hasInput;
        if (shouldWork) {
            HuaJiBlenderRecipe recipe = hasInput ? (HuaJiBlenderRecipe)pBlockEntity.quickCheck.m_213657_((Container)pBlockEntity, pLevel).orElse(null) : null;
            int i = pBlockEntity.m_6893_();
            if (!pBlockEntity.isLit() && pBlockEntity.canBurn(pLevel.m_9598_(), recipe, pBlockEntity.items, i)) {
                pBlockEntity.litDuration = pBlockEntity.litTime = pBlockEntity.getBurnDuration(fuel);
                if (pBlockEntity.isLit()) {
                    hasChanged = true;
                    if (fuel.hasCraftingRemainingItem()) {
                        pBlockEntity.items.set(1, (Object)fuel.getCraftingRemainingItem());
                    } else if (hasFuel) {
                        fuel.m_41774_(1);
                        if (fuel.m_41619_()) {
                            pBlockEntity.items.set(1, (Object)fuel.getCraftingRemainingItem());
                        }
                    }
                }
            }
            if (pBlockEntity.canBurn(pLevel.m_9598_(), recipe, pBlockEntity.items, i)) {
                if (pBlockEntity.isLit()) {
                    ++pBlockEntity.processingProgress;
                    --pBlockEntity.litTime;
                    if (pBlockEntity.processingProgress == pBlockEntity.processingTotalTime) {
                        pBlockEntity.processingProgress = 0;
                        pBlockEntity.processingTotalTime = HuaJiBlenderBlockEntity.getTotalProcessTime(pLevel, pBlockEntity);
                        if (pBlockEntity.burn(pLevel.m_9598_(), recipe, pBlockEntity.items, i)) {
                            pBlockEntity.m_6029_(recipe);
                        }
                        flag = false;
                    } else {
                        hasChanged = true;
                    }
                }
            } else {
                pBlockEntity.processingProgress = 0;
                hasChanged = true;
            }
        }
        if (flag != pBlockEntity.processingProgress > 0 || hasChanged) {
            hasChanged = true;
            pState = (BlockState)pState.m_61124_((Property)BlockHuaJiBlender.LIT, (Comparable)Boolean.valueOf(pBlockEntity.processingProgress > 0));
            pLevel.m_7731_(pPos, pState, 3);
        }
        if (hasChanged) {
            HuaJiBlenderBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    private boolean canBurn(RegistryAccess pRegistryAccess, @javax.annotation.Nullable HuaJiBlenderRecipe pRecipe, NonNullList<ItemStack> pInventory, int pMaxStackSize) {
        if (!((ItemStack)pInventory.get(0)).m_41619_() && pRecipe != null) {
            ItemStack input = pRecipe.m_5874_((Container)this, pRegistryAccess);
            if (input.m_41619_()) {
                return false;
            }
            ItemStack output = (ItemStack)pInventory.get(2);
            if (output.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_41656_((ItemStack)output, (ItemStack)input)) {
                return false;
            }
            if (output.m_41613_() + input.m_41613_() <= pMaxStackSize && output.m_41613_() + input.m_41613_() <= output.m_41741_()) {
                return true;
            }
            return output.m_41613_() + input.m_41613_() <= input.m_41741_();
        }
        return false;
    }

    private boolean burn(RegistryAccess pRegistryAccess, @javax.annotation.Nullable HuaJiBlenderRecipe pRecipe, NonNullList<ItemStack> pInventory, int pMaxStackSize) {
        if (pRecipe != null && this.canBurn(pRegistryAccess, pRecipe, pInventory, pMaxStackSize)) {
            ItemStack input = (ItemStack)pInventory.get(0);
            ItemStack result = pRecipe.m_5874_((Container)this, pRegistryAccess);
            ItemStack output = (ItemStack)pInventory.get(2);
            if (output.m_41619_()) {
                pInventory.set(2, (Object)result.m_41777_());
            } else if (output.m_150930_(result.m_41720_())) {
                output.m_41769_(result.m_41613_());
            }
            input.m_41774_(1);
            return true;
        }
        return false;
    }

    protected int getBurnDuration(ItemStack pFuel) {
        if (pFuel.m_41619_()) {
            return 0;
        }
        return HuaJiUtils.getTagFuel(pFuel, HUAJI_BLENDER_TIME_PREFIX, 19);
    }

    private static int getTotalProcessTime(Level pLevel, HuaJiBlenderBlockEntity pBlockEntity) {
        return pBlockEntity.quickCheck.m_213657_((Container)pBlockEntity, pLevel).map(HuaJiBlenderRecipe::processTime).orElse(200);
    }

    public static boolean isFuel(ItemStack pStack) {
        return HuaJiUtils.isTagFuel(pStack, HUAJI_BLENDER_TIME_PREFIX, 19);
    }

    public int[] m_7071_(Direction pSide) {
        if (pSide == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return pSide == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES;
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @javax.annotation.Nullable Direction pDirection) {
        return this.m_7013_(pIndex, pItemStack);
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return true;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int pIndex) {
        return (ItemStack)this.items.get(pIndex);
    }

    public ItemStack m_7407_(int pIndex, int pCount) {
        return ContainerHelper.m_18969_(this.items, (int)pIndex, (int)pCount);
    }

    public ItemStack m_8016_(int pIndex) {
        return ContainerHelper.m_18966_(this.items, (int)pIndex);
    }

    public void m_6836_(int pIndex, ItemStack pStack) {
        ItemStack itemstack = (ItemStack)this.items.get(pIndex);
        boolean flag = !pStack.m_41619_() && ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)pStack);
        this.items.set(pIndex, (Object)pStack);
        if (pStack.m_41613_() > this.m_6893_()) {
            pStack.m_41764_(this.m_6893_());
        }
        if (pIndex == 0 && !flag) {
            if (this.f_58857_ != null) {
                this.processingTotalTime = HuaJiBlenderBlockEntity.getTotalProcessTime(this.f_58857_, this);
            }
            this.processingProgress = 0;
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player pPlayer) {
        return Container.m_272074_((BlockEntity)this, (Player)pPlayer);
    }

    public boolean m_7013_(int pIndex, ItemStack pStack) {
        if (pIndex == 2) {
            return false;
        }
        if (pIndex != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)this.items.get(1);
        return HuaJiBlenderBlockEntity.isFuel(itemstack);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void m_6029_(@Nullable Recipe<?> pRecipe) {
        if (pRecipe != null) {
            ResourceLocation resourcelocation = pRecipe.m_6423_();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    @javax.annotation.Nullable
    public HuaJiBlenderRecipe getRecipeUsed() {
        return null;
    }

    public void m_58395_(Player pPlayer, List<ItemStack> pItems) {
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer pPlayer) {
        List<HuaJiBlenderRecipe> list = this.getRecipesToAwardAndPopExperience(pPlayer.m_284548_(), pPlayer.m_20182_());
        pPlayer.m_7281_((Collection)list.stream().map(huaJiBlenderRecipe -> huaJiBlenderRecipe).collect(Collectors.toSet()));
        for (HuaJiBlenderRecipe recipe : list) {
            if (recipe == null) continue;
            pPlayer.m_280300_((Recipe)recipe, this.items);
        }
        this.recipesUsed.clear();
    }

    public List<HuaJiBlenderRecipe> getRecipesToAwardAndPopExperience(ServerLevel pLevel, Vec3 pPopVec) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            pLevel.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                if (recipe instanceof HuaJiBlenderRecipe) {
                    HuaJiBlenderRecipe huaJiBlenderRecipe = (HuaJiBlenderRecipe)recipe;
                    list.add(huaJiBlenderRecipe);
                    HuaJiBlenderBlockEntity.createExperience(pLevel, pPopVec, entry.getIntValue(), huaJiBlenderRecipe.experience());
                }
            });
        }
        return list;
    }

    private static void createExperience(ServerLevel pLevel, Vec3 pPopVec, int pRecipeIndex, float pExperience) {
        int i = Mth.m_14143_((float)((float)pRecipeIndex * pExperience));
        float f = Mth.m_14187_((float)((float)pRecipeIndex * pExperience));
        if (f > 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.m_147082_((ServerLevel)pLevel, (Vec3)pPopVec, (int)i);
    }

    public void m_5809_(StackedContents pHelper) {
        for (ItemStack itemstack : this.items) {
            pHelper.m_36491_(itemstack);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @javax.annotation.Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && facing != null && !this.f_58859_) {
            return switch (facing) {
                case Direction.UP -> this.handlers[0].cast();
                case Direction.DOWN -> this.handlers[1].cast();
                default -> this.handlers[2].cast();
            };
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    }
}

