/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.entity;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.PlayMessages;
import net.mrqx.huajiage.HuaJiAgeMod;
import net.mrqx.huajiage.entity.EntityItemBullet;
import net.mrqx.huajiage.entity.ExplosionHuaJi;
import net.mrqx.huajiage.registy.HuaJiItems;
import net.mrqx.huajiage.registy.HuaJiSoundEvents;
import net.mrqx.huajiage.utils.HuaJiDamageSources;
import net.mrqx.huajiage.utils.HuaJiSoundPlayer;

public class EntityRoadRoller
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(EntityRoadRoller.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Long> LIFE = SynchedEntityData.m_135353_(EntityRoadRoller.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    private boolean hasExploded = false;
    private int hitTime = 0;

    public EntityRoadRoller(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public EntityRoadRoller(LivingEntity shooter, Level level) {
        super(HuaJiAgeMod.RegistryEvents.roadRollerEntityType, shooter, level);
    }

    public static EntityRoadRoller createInstance(PlayMessages.SpawnEntity packet, Level worldIn) {
        return new EntityRoadRoller(HuaJiAgeMod.RegistryEvents.roadRollerEntityType, worldIn);
    }

    public static EntityRoadRoller create(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        return new EntityRoadRoller(pEntityType, pLevel);
    }

    protected Item m_7881_() {
        return (Item)HuaJiItems.ROAD_ROLLER.get();
    }

    @Nullable
    public ItemStack getPickedResult(HitResult target) {
        return this.m_7846_();
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("damage", this.getDamage());
        pCompound.m_128356_("life", this.getLife());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(10.0f));
        this.f_19804_.m_135372_(LIFE, (Object)200L);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setDamage(pCompound.m_128457_("damage"));
        this.setLife(pCompound.m_128454_("life"));
    }

    public void m_8119_() {
        this.setLife(this.getLife() - 1L);
        super.m_8119_();
        if (this.getLife() < 0L) {
            this.m_146870_();
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        this.setDamage(this.getDamage() + pAmount);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (pSource.m_7639_() != null && this.m_7846_().m_150930_((Item)HuaJiItems.ROAD_ROLLER.get())) {
                if (this.hitTime == 0) {
                    HuaJiSoundPlayer.playMovingSoundToClient(pSource.m_7639_(), (SoundEvent)HuaJiSoundEvents.DIO_FLAG.get(), 2.0f);
                } else if (this.hitTime % 4 == 0) {
                    HuaJiSoundPlayer.playMovingSoundToClient(pSource.m_7639_(), (SoundEvent)HuaJiSoundEvents.DIO_HIT.get(), 0.75f);
                }
            }
            ++this.hitTime;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 1.0, 1.0, 1.0, 1.0);
        }
        return false;
    }

    protected void m_8060_(BlockHitResult pResult) {
        super.m_8060_(pResult);
        if (!this.hasExploded) {
            this.explode();
            this.setLife(1L);
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        if (!(pResult.m_82443_() instanceof EntityItemBullet || pResult.m_82443_().equals((Object)this.m_19749_()) || this.hasExploded)) {
            this.explode();
            this.setLife(1L);
        }
    }

    protected void explode() {
        this.hasExploded = true;
        ExplosionHuaJi explosion = new ExplosionHuaJi(this.m_9236_(), this.m_19749_(), HuaJiDamageSources.standHit(this.m_9236_(), (Entity)this, this.m_19749_(), this.m_20182_()), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Explosion.BlockInteraction.KEEP, this.getDamage(), 0.0, false);
        explosion.m_46061_();
        explosion.m_46075_(true);
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public long getLife() {
        return (Long)this.f_19804_.m_135370_(LIFE);
    }

    public void setLife(long life) {
        this.f_19804_.m_135381_(LIFE, (Object)life);
    }
}

