/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.item.equipment.armor;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.mrqx.huajiage.capability.stand.StandDataCapabilityProvider;
import net.mrqx.huajiage.client.HuaJiLayers;
import net.mrqx.huajiage.client.model.HuaJiArmorModel;
import net.mrqx.huajiage.item.equipment.armor.HuaJiArmorMaterials;
import net.mrqx.huajiage.registy.HuaJiItems;
import net.mrqx.huajiage.stand.Stand;
import net.mrqx.huajiage.stand.StandOrgaRequiem;
import org.jetbrains.annotations.Nullable;

public abstract class ItemOrgaArmor
extends ArmorItem {
    public ItemOrgaArmor(ArmorItem.Type pType) {
        super((ArmorMaterial)HuaJiArmorMaterials.ORGA, pType, new Item.Properties().m_41497_(Rarity.RARE).m_41486_());
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "huajiage:textures/models/armor/orga.png";
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                EntityModelSet models = Minecraft.m_91087_().m_167973_();
                ModelPart root = models.m_171103_(HuaJiLayers.ORGA_HAIR);
                return new HuaJiArmorModel(root);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.huajiage.orga.tooltips.1").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            tooltip.add((Component)Component.m_237110_((String)"message.huajiage.prefix", (Object[])new Object[]{Component.m_237115_((String)((Item)HuaJiItems.ORGA_HELMET.get()).m_5524_()).m_130940_(((ItemStack)player.m_150109_().f_35975_.get(3)).m_150930_((Item)HuaJiItems.ORGA_HELMET.get()) ? ChatFormatting.YELLOW : ChatFormatting.GRAY)}));
            tooltip.add((Component)Component.m_237110_((String)"message.huajiage.prefix", (Object[])new Object[]{Component.m_237115_((String)((Item)HuaJiItems.ORGA_CHESTPLATE.get()).m_5524_()).m_130940_(((ItemStack)player.m_150109_().f_35975_.get(2)).m_150930_((Item)HuaJiItems.ORGA_CHESTPLATE.get()) ? ChatFormatting.YELLOW : ChatFormatting.GRAY)}));
            tooltip.add((Component)Component.m_237110_((String)"message.huajiage.prefix", (Object[])new Object[]{Component.m_237115_((String)((Item)HuaJiItems.ORGA_LEGGINGS.get()).m_5524_()).m_130940_(((ItemStack)player.m_150109_().f_35975_.get(1)).m_150930_((Item)HuaJiItems.ORGA_LEGGINGS.get()) ? ChatFormatting.YELLOW : ChatFormatting.GRAY)}));
            tooltip.add((Component)Component.m_237110_((String)"message.huajiage.prefix", (Object[])new Object[]{Component.m_237115_((String)((Item)HuaJiItems.ORGA_BOOTS.get()).m_5524_()).m_130940_(((ItemStack)player.m_150109_().f_35975_.get(0)).m_150930_((Item)HuaJiItems.ORGA_BOOTS.get()) ? ChatFormatting.YELLOW : ChatFormatting.GRAY)}));
        }
    }

    public static boolean hasAllOrgaArmor(LivingEntity livingEntity) {
        return livingEntity.getCapability(StandDataCapabilityProvider.STAND_DATA).map(data -> Stand.getStand(data.getStand()) instanceof StandOrgaRequiem).orElse(false) != false || livingEntity.m_6844_(EquipmentSlot.FEET).m_150930_((Item)HuaJiItems.ORGA_BOOTS.get()) && livingEntity.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)HuaJiItems.ORGA_LEGGINGS.get()) && livingEntity.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)HuaJiItems.ORGA_CHESTPLATE.get()) && livingEntity.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)HuaJiItems.ORGA_HELMET.get());
    }

    public static class ItemOrgaArmorBoots
    extends ItemOrgaArmor {
        public ItemOrgaArmorBoots() {
            super(ArmorItem.Type.BOOTS);
        }
    }

    public static class ItemOrgaArmorLeggings
    extends ItemOrgaArmor {
        public ItemOrgaArmorLeggings() {
            super(ArmorItem.Type.LEGGINGS);
        }
    }

    public static class ItemOrgaArmorChestplate
    extends ItemOrgaArmor {
        public ItemOrgaArmorChestplate() {
            super(ArmorItem.Type.CHESTPLATE);
        }
    }

    public static class ItemOrgaArmorHelmet
    extends ItemOrgaArmor {
        public ItemOrgaArmorHelmet() {
            super(ArmorItem.Type.HELMET);
        }
    }
}

