/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.item.stand;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.mrqx.huajiage.capability.stand.IStandData;
import net.mrqx.huajiage.capability.stand.StandDataCapabilityProvider;
import net.mrqx.huajiage.item.BaseItem;
import net.mrqx.huajiage.registy.HuaJiStands;
import net.mrqx.huajiage.stand.Stand;
import net.mrqx.huajiage.utils.AdvancementHelper;
import net.mrqx.huajiage.utils.ItemTagHelper;
import org.jetbrains.annotations.Nullable;

public class ItemDisc
extends BaseItem {
    public static final String DISC_STAND_KEY = "huajiage.discStand";
    public static final String DISC_STAND_LEVEL_KEY = "huajiage.discStandLevel";

    public ItemDisc() {
        super(new Item.Properties().m_41487_(1));
    }

    public Component m_7626_(ItemStack pStack) {
        ResourceLocation resourceLocation = ItemDisc.getStandResourceLocation(pStack);
        if (resourceLocation != null) {
            return Component.m_237110_((String)"item.huajiage.disc", (Object[])new Object[]{Component.m_237115_((String)("stand." + resourceLocation.m_135827_() + "." + resourceLocation.m_135815_()))});
        }
        return Component.m_237110_((String)"item.huajiage.disc", (Object[])new Object[]{Component.m_237115_((String)"stand.huajiage.null")});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        ResourceLocation resourceLocation = ItemDisc.getStandResourceLocation(stack);
        Stand stand = ItemDisc.getStand(stack);
        if (resourceLocation != null && stand != null) {
            tooltip.add((Component)Component.m_237110_((String)"item.huajiage.tooltips.stand", (Object[])new Object[]{Component.m_237115_((String)("stand." + resourceLocation.m_135827_() + "." + resourceLocation.m_135815_()))}).m_130940_(ChatFormatting.GRAY));
            int standLevel = ItemTagHelper.getInt(stack, DISC_STAND_LEVEL_KEY, 0);
            tooltip.add((Component)Component.m_237110_((String)"stand.huajiage.level", (Object[])new Object[]{standLevel >= stand.getMaxLevel() ? Component.m_237115_((String)"stand.huajiage.level.max") : Integer.valueOf(standLevel)}).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.huajiage.disc.tooltips.craft").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemStack = pPlayer.m_21120_(pUsedHand);
        pPlayer.m_6672_(pUsedHand);
        Stand stand = ItemDisc.getStand(itemStack);
        if (stand != null) {
            pPlayer.getCapability(StandDataCapabilityProvider.STAND_DATA).ifPresent(data -> {
                data.setStand(stand);
                data.setMaxEnergy(stand.getMaxEnergy((LivingEntity)pPlayer, (IStandData)data));
                data.setLevel(ItemTagHelper.getInt(itemStack, DISC_STAND_LEVEL_KEY, 0));
            });
            pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
            AdvancementHelper.grantCriterion((LivingEntity)pPlayer, AdvancementHelper.STAND);
            if (!pPlayer.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            pPlayer.m_21011_(pUsedHand, true);
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    @Nullable
    public static Stand getStand(ItemStack stack) {
        return (Stand)HuaJiStands.REGISTRY.get().getValue(ResourceLocation.m_135820_((String)ItemTagHelper.getString(stack, DISC_STAND_KEY, "huajiage:null")));
    }

    @Nullable
    public static ResourceLocation getStandResourceLocation(ItemStack stack) {
        return ResourceLocation.m_135820_((String)ItemTagHelper.getString(stack, DISC_STAND_KEY, "huajiage:null"));
    }
}

