/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.item.stand;

import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrqx.huajiage.capability.stand.StandDataCapabilityProvider;
import net.mrqx.huajiage.item.BaseItem;
import net.mrqx.huajiage.registy.HuaJiSoundEvents;
import net.mrqx.huajiage.stand.Stand;
import net.mrqx.huajiage.utils.HuaJiSoundPlayer;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class ItemSingularity
extends BaseItem {
    public static final String SINGULARITY_COUNT = "huajiage.singularityCount";
    private static int tick = 0;
    private static int curColor = 0;
    private static final String[] SINGULARITY_COLORS = new String[]{"\u00a7c", "\u00a76", "\u00a7e", "\u00a7a", "\u00a79", "\u00a7b"};

    public ItemSingularity() {
        super(new Item.Properties().m_41497_(Rarity.EPIC).m_41486_().m_41487_(1));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        String key;
        String translated;
        int index = 1;
        while (!(translated = Component.m_237115_((String)(key = this.m_5524_() + ".tooltips." + index)).getString()).toLowerCase(Locale.ENGLISH).equals(key)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < translated.length(); ++i) {
                sb.append(SINGULARITY_COLORS[(curColor + i) % SINGULARITY_COLORS.length]);
                sb.append(translated.charAt(i));
            }
            tooltip.add((Component)Component.m_237113_((String)sb.toString()));
            ++index;
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemStack = pPlayer.m_21120_(pUsedHand);
        pPlayer.m_6672_(pUsedHand);
        AtomicBoolean flag = new AtomicBoolean(false);
        pPlayer.getCapability(StandDataCapabilityProvider.STAND_DATA).ifPresent(data -> {
            CompoundTag persistentData;
            Stand stand = Stand.getStand(data.getStand());
            if (!(stand == null || stand.getMaxLevel() < data.getLevel() + 1 || (persistentData = pPlayer.getPersistentData()).m_128425_(SINGULARITY_COUNT, 3) && persistentData.m_128451_(SINGULARITY_COUNT) > 0)) {
                persistentData.m_128405_(SINGULARITY_COUNT, 200);
                pPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 200));
                pPlayer.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 200));
                pPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 200, 9));
                pPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 9));
                pPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 5));
                pPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 200, 9));
                HuaJiSoundPlayer.playMovingSoundToClient((Entity)pPlayer, (SoundEvent)HuaJiSoundEvents.CHARGE.get());
                HuaJiSoundPlayer.playMovingSoundToClient((Entity)pPlayer, (SoundEvent)HuaJiSoundEvents.ENERGY_HIT.get());
                HuaJiSoundPlayer.playMovingSoundToClient((Entity)pPlayer, (SoundEvent)HuaJiSoundEvents.NOISE_FURNACE.get());
                pPlayer.m_213846_((Component)Component.m_237115_((String)"message.huajiage.singularity").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
                flag.set(true);
            }
        });
        pPlayer.m_21011_(pUsedHand, true);
        if (flag.get()) {
            pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
            if (!pPlayer.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (++tick >= 2) {
            tick = 0;
            if (--curColor < 0) {
                curColor = SINGULARITY_COLORS.length - 1;
            }
        }
    }
}

