/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.item.stand;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.mrqx.huajiage.capability.stand.IStandData;
import net.mrqx.huajiage.capability.stand.StandDataCapabilityProvider;
import net.mrqx.huajiage.item.BaseItem;
import net.mrqx.huajiage.registy.HuaJiStands;
import net.mrqx.huajiage.stand.Stand;
import net.mrqx.huajiage.utils.ItemTagHelper;
import org.jetbrains.annotations.Nullable;

public class ItemTarot
extends BaseItem {
    public static final String TAROT_STAND_KEY = "huajiage.tarotStand";
    public static final String TAROT_STAND_LEVEL_KEY = "huajiage.tarotStandLevel";

    public ItemTarot() {
        super(new Item.Properties().m_41487_(1));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        ResourceLocation resourceLocation = ItemTarot.getStandResourceLocation(stack);
        if (resourceLocation != null && !"huajiage:null".equals(resourceLocation.toString())) {
            tooltip.add((Component)Component.m_237110_((String)"item.huajiage.tooltips.stand", (Object[])new Object[]{Component.m_237115_((String)("stand." + resourceLocation.m_135827_() + "." + resourceLocation.m_135815_()))}).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237110_((String)"stand.huajiage.level", (Object[])new Object[]{ItemTagHelper.getInt(stack, TAROT_STAND_LEVEL_KEY, 0)}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemStack = pPlayer.m_21120_(pUsedHand);
        pPlayer.m_6672_(pUsedHand);
        if (!pPlayer.m_9236_().f_46443_) {
            Stand stand = ItemTarot.getStand(itemStack);
            if (stand != null) {
                pPlayer.getCapability(StandDataCapabilityProvider.STAND_DATA).ifPresent(data -> {
                    Stand stand1 = Stand.getStand(data.getStand());
                    if (stand1 == null) {
                        data.setStand(stand);
                        data.setLevel(ItemTagHelper.getInt(itemStack, TAROT_STAND_LEVEL_KEY, 0));
                        data.setMaxEnergy(stand.getMaxEnergy((LivingEntity)pPlayer, (IStandData)data));
                        ItemTagHelper.removeEntry(itemStack, TAROT_STAND_KEY);
                        ItemTagHelper.removeEntry(itemStack, TAROT_STAND_LEVEL_KEY);
                        pPlayer.m_21011_(pUsedHand, true);
                        pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
                    } else {
                        pPlayer.m_213846_((Component)Component.m_237115_((String)"message.huajiage.tarot.stand.failed").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                    }
                });
            } else {
                pPlayer.getCapability(StandDataCapabilityProvider.STAND_DATA).ifPresent(data -> {
                    Stand stand1 = Stand.getStand(data.getStand());
                    if (stand1 != null) {
                        ItemTagHelper.setString(itemStack, TAROT_STAND_KEY, data.getStand().toString());
                        ItemTagHelper.setInt(itemStack, TAROT_STAND_LEVEL_KEY, data.getLevel());
                        data.setStand((ResourceLocation)null);
                        data.setLevel(0);
                        pPlayer.m_21011_(pUsedHand, true);
                        pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
                        pPlayer.m_213846_((Component)Component.m_237115_((String)"message.huajiage.tarot.stand.store").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.ITALIC}));
                    }
                });
            }
        }
        return InteractionResultHolder.m_19090_((Object)itemStack);
    }

    @Nullable
    public static Stand getStand(ItemStack stack) {
        return (Stand)HuaJiStands.REGISTRY.get().getValue(ResourceLocation.m_135820_((String)ItemTagHelper.getString(stack, TAROT_STAND_KEY, "huajiage:null")));
    }

    @Nullable
    public static ResourceLocation getStandResourceLocation(ItemStack stack) {
        return ResourceLocation.m_135820_((String)ItemTagHelper.getString(stack, TAROT_STAND_KEY, "huajiage:null"));
    }
}

