/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.mrqx.huajiage.utils.HuaJiSoundPlayer;
import net.mrqx.huajiage.utils.PentaConsumer;

public class HuaJiSoundMessage {
    public ResourceLocation soundEvent = SoundEvents.f_271165_.m_11660_();
    public SoundSource source = SoundSource.MUSIC;
    public int entityId;
    public float volume = 1.0f;
    public float pitch = 1.0f;

    public static HuaJiSoundMessage decode(FriendlyByteBuf buf) {
        HuaJiSoundMessage huaJiSoundMessage = new HuaJiSoundMessage();
        huaJiSoundMessage.soundEvent = buf.m_130281_();
        huaJiSoundMessage.source = (SoundSource)buf.m_130066_(SoundSource.class);
        huaJiSoundMessage.entityId = buf.readInt();
        huaJiSoundMessage.volume = buf.readFloat();
        huaJiSoundMessage.pitch = buf.readFloat();
        return huaJiSoundMessage;
    }

    public static void encode(HuaJiSoundMessage msg, FriendlyByteBuf buf) {
        buf.m_130085_(msg.soundEvent);
        buf.m_130068_((Enum)msg.source);
        buf.writeInt(msg.entityId);
        buf.writeFloat(msg.volume);
        buf.writeFloat(msg.pitch);
    }

    public static void handle(HuaJiSoundMessage huaJiSoundMessage, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            return;
        }
        PentaConsumer handler = (PentaConsumer)DistExecutor.safeCallWhenOn((Dist)Dist.CLIENT, () -> HuaJiSoundPlayer::playMovingSoundClient);
        if (handler != null) {
            ctx.get().enqueueWork(() -> handler.accept(huaJiSoundMessage.soundEvent, huaJiSoundMessage.source, huaJiSoundMessage.entityId, Float.valueOf(huaJiSoundMessage.volume), Float.valueOf(huaJiSoundMessage.pitch)));
        }
        ctx.get().setPacketHandled(true);
    }
}

