/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.network;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.mrqx.huajiage.stand.Stand;
import org.jetbrains.annotations.Nullable;

public class StandSyncMessage {
    @Nullable
    public CompoundTag data;
    public int entityId;

    public static StandSyncMessage decode(FriendlyByteBuf buf) {
        StandSyncMessage standSyncMessage = new StandSyncMessage();
        standSyncMessage.data = Objects.requireNonNull(buf.m_130261_());
        standSyncMessage.entityId = buf.readInt();
        return standSyncMessage;
    }

    public static void encode(StandSyncMessage msg, FriendlyByteBuf buf) {
        buf.m_130079_(msg.data);
        buf.writeInt(msg.entityId);
    }

    public static void handle(StandSyncMessage standSyncMessage, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            return;
        }
        BiConsumer handler = (BiConsumer)DistExecutor.safeCallWhenOn((Dist)Dist.CLIENT, () -> Stand.AbstractStandResource::setClientTag);
        if (handler != null) {
            ctx.get().enqueueWork(() -> handler.accept(standSyncMessage.data, standSyncMessage.entityId));
        }
        ctx.get().setPacketHandled(true);
    }
}

