/*
 * Decompiled with CFR 0.152.
 */
package net.mrqx.huajiage.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.mrqx.huajiage.recipe.HuaJiBlenderRecipeSerializer;
import net.mrqx.huajiage.registy.HuaJiRecipes;

public class HuaJiBlenderRecipeBuilder
implements RecipeBuilder {
    private final Item result;
    private final Ingredient ingredient;
    private final float experience;
    private final int processTime;
    @Nullable
    private String group;
    private final List<ICondition> recipeConditions;
    private final HuaJiBlenderRecipeSerializer serializer;

    public HuaJiBlenderRecipeBuilder(ItemLike itemLike, Ingredient ingredient, float experience, int processTime) {
        this.result = itemLike.m_5456_();
        this.ingredient = ingredient;
        this.experience = experience;
        this.processTime = processTime;
        this.recipeConditions = new ArrayList<ICondition>();
        this.serializer = (HuaJiBlenderRecipeSerializer)HuaJiRecipes.HUAJI_BLENDER_RECIPE_SERIALIZER.get();
    }

    public static HuaJiBlenderRecipeBuilder create(ItemLike itemLike, Ingredient ingredient, float experience, int processTime) {
        return new HuaJiBlenderRecipeBuilder(itemLike, ingredient, experience, processTime);
    }

    public HuaJiBlenderRecipeBuilder unlockedBy(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        return this;
    }

    public HuaJiBlenderRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_176498_(Consumer<FinishedRecipe> pFinishedRecipeConsumer) {
        this.m_126140_(pFinishedRecipeConsumer, HuaJiBlenderRecipeBuilder.getDefaultRecipeId((ItemLike)this.m_142372_()));
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.group == null ? "" : this.group, this.ingredient, this.result, this.experience, this.processTime, this.recipeConditions, this.serializer));
    }

    public HuaJiBlenderRecipeBuilder whenModLoaded(String modid) {
        return this.withCondition((ICondition)new ModLoadedCondition(modid));
    }

    public HuaJiBlenderRecipeBuilder whenModMissing(String modid) {
        return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modid)));
    }

    public HuaJiBlenderRecipeBuilder withCondition(ICondition condition) {
        this.recipeConditions.add(condition);
        return this;
    }

    protected static ResourceLocation getDefaultRecipeId(ItemLike pItemLike) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)pItemLike.m_5456_()).m_246208_("huaji_blender/");
    }

    record Result(ResourceLocation id, String group, Ingredient ingredient, Item result, float experience, int processTime, List<ICondition> recipeConditions, HuaJiBlenderRecipeSerializer serializer) implements FinishedRecipe
    {
        public void m_7917_(JsonObject pJson) {
            if (!this.group.isEmpty()) {
                pJson.addProperty("group", this.group);
            }
            pJson.add("ingredient", this.ingredient.m_43942_());
            pJson.addProperty("result", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).toString());
            pJson.addProperty("experience", (Number)Float.valueOf(this.experience));
            pJson.addProperty("processTime", (Number)this.processTime);
            if (this.recipeConditions.isEmpty()) {
                return;
            }
            JsonArray conditions = new JsonArray();
            this.recipeConditions.forEach(c -> conditions.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
            pJson.add("conditions", (JsonElement)conditions);
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

